#
# Small c Interpreter command shell
#
# The library functions:
#
putchar(c){return sys(c,1,1)}
getchar(){return sys(0,2)}
puts(b){return sys(b,1,3)}
gets(b){return sys(b,80,0,4)}
fputc(c,u){return sys(c,u,1)}
fgetc(u){return sys(u,2)}
fputs(b,u){return sys(b,u,3)}
fgets(b,n,u){return sys(b,n,u,4)}
sprintf(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9)
   {return sys(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,5)}
printf(a0,a1,a2,a3,a4,a5,a6,a7,a8)
   {char b[128];sys(b,a0,a1,a2,a3,a4,a5,a6,a7,a8,5);puts(b)}
sscanf(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9)
   {return sys(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,6)}
scanf(a0,a1,a2,a3,a4,a5,a6,a7,a8)
   {char b[128];gets(b);sys(b,a0,a1,a2,a3,a4,a5,a6,a7,a8,6)}
atoi(b){int v;sys(b,"%d",&v,6);return v}
fopen(f,m){return sys(f,m,7)}
fread(s,l,u){return sys(s,l,u,8)}
fwrite(s,l,u){return sys(s,l,u,9)}
fclose(u){return sys(u,10)}
exit(){sys(11)}
stmt(l,p,s){return sys(l,p,s,12)}
totok(s,b){return sys(s,b,13)}
untok(b,s){return sys(b,s,14)}
edit(l,p){return sys(l,p,15)}
strcmp(s,t){return sys(s,t,16)}
strncmp(s,t,n){return sys(s,t,n,16)}
memleft(){return sys(17)}
malloc(n){return sys(n,18)}
free(p){sys(p,19)}
load(f,p){return sys(f,p,20)}
save(f,p){return sys(f,p,21)}
list(p,f,t){return sys(p,f,t,22)}
trace(n){sys(n,23)}

#
# Entry point to the shell. All globals defined before the "entry" keyword
# are in the "library" and are accessible by user programs.
#
entry

int size,top;
char line[80];
char program[16000];

main()
{
   int from, to;

   top=16000;
   program[0]='Z';    # This is an "End of program" token - required
   size=1;

   # print sign-on message
   printf("%s\nShell V1.2M, 13 Nov 1985\n",sys(0));

   while(1)
   {
      puts("> ");
      if(gets(line))
      {
         if (!strncmp(line,"edit",4))
            size = sys(atoi(line+5),program,15); # envoke the editor
         else if (!strncmp(line,"list",4))
         {
            if(line[4])
               sscanf(line+4,"%d %d",&from,&to);
            else
            {
               from=1;
               to=32765;
            }
            sys(program,from,to,22);             # list the program buffer
         }
         else if (!strncmp(line,"save",4))
            sys(line+5,program,21);              # save the program buffer
         else if (!strncmp(line,"load",4))
            size = sys(line+5,program,20);       # load the program buffer
         else if (!strncmp(line,"core",4))
            printf("%d bytes free\n",top-size);  # show amount of free space
         else
         {
            #
            # attempt to parse the line as a small c statement. Note that
            # we will display (non-zero) results of a statement, so you
            # could enter something like: 2+2 and a 4 would be printed.
            #
            printf("\n%d\n",sys(line,program,12));
         }
      }
   }
}
