#ifndef MAX_ROUTES
#define MAX_ROUTES 1
#endif

#define MAX_SEGMENTS	18

struct route_info {
	unchar	ri_control0;
	unchar	ri_control1;
	ushort	ri_segments[MAX_SEGMENTS];
};

	/* Broadcast indicator bits, for control0 field */
#define	SRF	0x00	/* Specifically Routed Frame */
#define STE	0xc0	/* Spanning Tree Explorer Frame */
#define ARE	0x80	/* All Routes Explorer Frame */
#define IS_SRF(x) (((x) & 0x80)==SRF)
#define IS_STE(x) (((x) & 0xc0)==STE)
#define IS_ARE(x) (((x) & 0xc0)==ARE)
#define LEN_MASK	0x1f	/* Route Length mask */

	/* Direction indicator bits, for control1 field */
#define DIR_FORWARD	0x00		/* Interpret Route Left to Right */
#define DIR_BACKWARD	0x80		/* Interpret Route Right to Left */
#define DIR_BIT		0x80

	/* Maximum frame size, for control1 field */
#define LEN_516		0x00
#define LEN_1500	0x10
#define LEN_2052	0x20
#define LEN_4472	0x30
#define LEN_8144	0x40
#define LEN_11407	0x50
#define LEN_17800	0x60
#define LEN_NOT_SPEC	0x70

	/* Route Indicator bit of source address */
#define ROUTE_INDICATOR	0x80

struct route {
	struct route	       *r_next, *r_back;
	time_t			r_timeout;	/* lbolt when times out */
	unchar			r_mac_addr[6];
	unchar			r_state;
	struct route_info	r_info;
};

struct route_table {
	uint		nroutes;	/* number of routes in route_table */
	uint		ninuse;		/* #Currently in use */
	struct route	*free;		/* Free list head */
	struct route	*inuse;		/* List head for 'SR_IN_USE' */
	struct route	*discovering;	/* List head for other states */

		/* Garbage collector parameters */
	int		t_id;		/* ID of garbage collector timeout */
	uint		t_values[4];	/* Values for short/med/long timer */

		/* Routes */
	struct route	no_route,	/* 'No route' */
			ste_route,	/* 'Single-route broadcast' */
			are_route;	/* 'All-routes broadcast' */
	struct route	routes[MAX_ROUTES];
};

#if defined(__STDC__) && !defined(_NO_PROTOTYPE)
extern void lliSR_init(struct route_table *, uint, uint);
extern void lliSR_halt(struct route_table *);
extern lliSR_parse_header(struct route_table *, unchar *, unchar *, unchar *);
extern lliSR_make_header(struct route_table *,unchar *,unchar *, unchar *);
extern lliSR_primitives(struct route_table *, queue_t *, mblk_t *);
#endif
