/****************************************************************************

  File                  : yreset.c	
  Date                  : 3-18-91	
  Description           : Reset function for YM3812 libraries
				

  Progammer(s)          : Don Fowler, Lance Williams	
  Last Modifications    : 	

  Additional Notes      : 

****************************************************************************
               Copyright (c) 1991,  Covox, Inc.  All Rights Reserved      
****************************************************************************/

#include "cvxfmsy.h"

VOID resetChip( VOID );

/****************************************************************************

	Function	 : BYTE fmReset( VOID )

	Parameters: VOID

	Actions	 :	 1.) Check for system intialized
					 2.) Reset all of the global variables( AM Depth, FM Depth )
					 3.) Clear all of the kon and percussion bits

*****************************************************************************/

WORD fmReset( VOID )
{
	// Generic counter
	BYTE 	Counter_i;

	// Check to see if the system is initialized
	if( !_fmGlobalParameters.systemInitialized )
		return( _ERROR_SYSTEM_NOT_INITIALIZED );
	  
	// Set the AM and FM depth
	_fmPercussionRegister &= _RESET_DEPTH;

	// Reset all of the kon bit flags
	for( Counter_i = 0; Counter_i < _MEL_VOICES; Counter_i++ )
		_fmKONBLOCKReg[ Counter_i ] &=  _RESET_KON;

	// Set all of the instrument set flags to false
	for( Counter_i = 0; Counter_i < _TOT_VOICES; Counter_i ++ )
		_fmInstrumentSet[ Counter_i ] = _FALSE; 

   // Reset the chip
   resetChip();

   // Return the no errors message
	return( _ERROR_NONE );
}


/****************************************************************************

	Function	 : VOID resetChip( VOID )

	Parameters: VOID

	Actions	 :	Reset the chip

*****************************************************************************/

VOID resetChip( VOID )
{
   BYTE  Counter_i;
   
   // Reset the am /  vib registers
   for( Counter_i  =  0x20; Counter_i  <  0x35; Counter_i ++  )
      fmSetRegister(  Counter_i, 0x00 );

   // Reset the key scaling and total level registers
   for( Counter_i  =  0x40; Counter_i  <  0x55; Counter_i ++  )
      fmSetRegister(  Counter_i, 63 );

   // Reset the attack and decay rate registers
   for( Counter_i  =  0x60; Counter_i  <  0x75; Counter_i ++  )
      fmSetRegister(  Counter_i, 0xff );

   // Reset the sustain level and decay rate registers
   for( Counter_i  =  0x80; Counter_i  <  0x75; Counter_i ++  )
      fmSetRegister(  Counter_i, 0xff );

   // Reset the f-number low registers
   for( Counter_i  =  0xa0; Counter_i  <  0xa8; Counter_i ++  )
      fmSetRegister(  Counter_i, 0x00 );

   // Reset the kon block and f-number high registers
   for( Counter_i  =  0xb0; Counter_i  <  0xb8; Counter_i ++  )
      fmSetRegister(  Counter_i, 0x00 );
   
   // Reset the percussion register
   fmSetRegister( 0xbd, 0x00  );

   // Reset the feedback and connection register
   for( Counter_i  =  0xc0; Counter_i  <  0xc8; Counter_i ++  )
      fmSetRegister(  Counter_i, 0x00 );

   // Reset the wave select register
   for( Counter_i  =  0xe0; Counter_i  <  0xf5; Counter_i ++  )
      fmSetRegister(  Counter_i, 0x00 );
}

