;****************************************************************************
;**                                                                        **
;**                    IBM PC/XT/AT System data segment                    **
;**                Memory addresses in low ram used by BIOS                **
;**                                                                        **
;****************************************************************************

PC      EQU   0FFh
XT      EQU   0FEh
PCjr    EQU   0FDh
AT      EQU   0FCh

system_data   SEGMENT AT 40h      ; ROM BIOS data area in low memory

      ORG   00h
com1      LABEL   WORD
      ORG   02h
com2      LABEL   WORD
      ORG   04h
com3      LABEL   WORD
      ORG   06h
com4      LABEL   WORD
      ORG   08h
lpt1      LABEL   WORD            ; Printer port 1.
      ORG   0Ah
lpt2      LABEL   WORD            ; Printer port 2.
      ORG   0Ch               
lpt3      LABEL   WORD            ; Printer port 3.
      ORG   10h
equip_flags   LABEL   WORD        ; Equiptment flags
      ORG   17h
kb_flag      LABEL   BYTE         ; First shift status flag (see below)
      ORG   18h
kb_flag_1   LABEL   BYTE          ; Second ss flag.
      ORG   1ah
key_head_ptr   LABEL   WORD       ; The position of the buffers head.
      ORG   1ch
key_tail_ptr   LABEL   WORD       ; Buffers tail.
      ORG   1eh
kb_buffer   LABEL   WORD          ; The keyboard.
      ORG   3eh
kb_buffer_end   LABEL   WORD      ; Address of the end of KB buffer.
      ORG   49h
_crt_mode   LABEL   BYTE          ; Current BIOS video mode number.
      ORG   4ah
_crt_cols   LABEL   WORD          ; Num of video columns.
      ORG   4ch
_crt_len   LABEL   WORD           ; Size of video buffer in bytes.
      ORG   4eh
_crt_start   LABEL   WORD         ; Offset of start of video buffer.
      ORG   50h                   ; Array of 8 words for each of 8.
_cursor_posn   LABEL   WORD       ; Display pages (of 40 column text).
      ORG   60h                   ; Starting and ending lines for
_cursor_mode   LABEL   WORD       ;    alpha-numeric cursor.
      ORG   62h
_active_page   LABEL   BYTE       ; Currently displayed video page.
      ORG   63h                   ; I/O port address for Mode control
_addr_6845   LABEL   WORD         ;   register (3B4h mono, 3D4h CGA).
      ORG   65h                   ; Current value of the mode control 
_crt_mode_set   LABEL   BYTE      ;   register (of port 3x8h).
      ORG   66h                   ; Current value for CGA color select
_crt_palette   LABEL   BYTE       ;   register (3D9h).
      ORG   6ch
timer_data   LABEL   DWORD        ; 4 byte location of timer.
      ORG   80h
kb_adr_buf_strt   LABEL   WORD    ; Address of keyboard buffer start.
      ORG   82H
kb_adr_buf_end   LABEL   WORD     ; Address of keyboard buffer end.
      ORG   84h
_rows      LABEL   BYTE           ; Number of displayed char rows - 1
      ORG   85h
_points      LABEL   WORD         ; Height of character matrix
      ORG   87h
_info      LABEL   BYTE           ; See page 437 of Video subsystems
      ORG   88h
_info_3      LABEL   BYTE         ; ditto
      ORG   89h
_flags      LABEL   BYTE          ; Miscelaneous flags, see _info
      ORG   8ah
_DCC      LABEL   BYTE            ; Display Combo Code table index.
      ORG   0a8h
_save_ptr   LABEL   DWORD         ; Pointer to BIOS save area.
      ORG   12eh
unknown_start   LABEL   WORD      ; 466 byte buffer that DOS uses to
      ORG   2feh                  ;    boot with, but then is never used.
unknown_end   LABEL   WORD

system_data     ENDS

;**  From page 236 of "Mapping the IBM", kb_flag above has the following
;**  values:
;**
;**  bit 7 -- Insert toggled
;**  bit 6 -- Caps lock toggled
;**  bit 5 -- Num lock toggled
;**  bit 4 -- Scroll lock toggled
;**  bit 3 -- Alt key pressed
;**  bit 2 -- Ctrl pressed
;**  bit 1 -- Left shift pressed
;**  bit 0 -- Right shift pressed

system_high_data SEGMENT AT 0ffffh ; ROM BIOS data area in high memory.

      ORG   0eh                    ; What model of computer.  For possible
model_values   LABEL   BYTE        ;   values

system_high_data ENDS


