#include <alloc.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <sys\stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define false 0
#define left 1
#define right 2
#define true 1

unsigned char powers2[8]={1, 2, 4, 8, 16, 32, 64, 128};
unsigned char line[320], nobitin, nobitout, wib;
unsigned int w;

void fillchar(char far *vidmem, unsigned int size, unsigned char c) {
	unsigned int work;
	for(work=0; work<size; work++) {
		vidmem[work]=c;
	}
}

unsigned char flag(char *t) {
	unsigned char o;
	printf("%s ", t);
	do {
		o=toupper(getch());
	} while(o!='Y'&&o!='N');
	printf("%c\n", o);
	if(o=='N')
		return false;
	else
		return true;
}

void error(char *message) {
	printf("%s\n", message);
	exit(0);
}

void addext(char *name) {
	char ext, work;
	work=0;
	ext=0;
	while(name[work]!=0) {
		if(name[work]=='.')
			ext=1;
		work++;
	}
	if(ext==0)
		strcat(name, ".DVM");
}

unsigned char getbyte(void) {
	unsigned char o;
	switch(nobitin) {
		case 1:
			o=(line[w]>>(wib-1))&1;
			wib--;
			break;
		case 2:
			switch(wib) {
				case 8:
					o=(line[w]&0xc0)>>6;
					break;
				case 6:
					o=(line[w]&0x30)>>4;
					break;
				case 4:
					o=(line[w]&0x0c)>>2;
					break;
				case 2:
					o=line[w]&0x03;
			}
			wib-=2;
			break;
		case 4:
			if(wib==8)
				o=(line[w]&0xf0)>>4;
			else
				o=(line[w]&0x0f);
			wib-=4;
			break;
		case 8:
			o=line[w];
			wib-=8;
			break;
	}
	if(wib==0) {
		wib=8;
		w++;
	}
	return o;
}

void putbyte(unsigned char byte) {
	switch(nobitout) {
		case 1:
			if(wib==8)
				line[w]=0;
			if(byte>0)
				line[w]+=powers2[wib-1];
			wib--;
			break;
		case 2:
			switch(wib) {
				case 8:
					line[w]=(byte&0x03)<<6;
					break;
				case 6:
					line[w]+=(byte&0x03)<<4;
					break;
				case 4:
					line[w]+=(byte&0x03)<<2;
					break;
				case 2:
					line[w]+=byte&0x03;
			}
			wib-=2;
			break;
		case 4:
			if(wib==8)
				line[w]=(byte&0x0f)<<4;
			else
				line[w]+=(byte&0x0f);
			wib-=4;
			break;
		case 8:
			line[w]=byte;
			wib-=8;
	}
	if(wib==0) {
		wib=8;
		w++;
	}
}

void main() {
	char answer, c256, cbit, compression, dstname[80], enhanced, first, fullqrt, fullscreen, header[4], itxt, oneenh, srcname[80], t, txts[80];
	int dst, src, txt;
	unsigned char b, c, g, palette[768], r, ib, infobyte, usebyte, version, vout;
	unsigned int dtime, linesize, linesizein, nocolors, palettesize, textsize, work, work2;
	unsigned char far *vidmem;
	printf("DVM to DVM v2.0\nWritten by Bert Greevenbosch for Magic Software Rotterdam\nPublic Domain Version\n\n");
	if((vidmem=(char far*)malloc(64000))==NULL)
		error("Out of memory");
	printf("Enter source name: ");
	gets(srcname);
	addext(srcname);
	if((src=open(srcname, O_BINARY|O_RDONLY))==-1)
		error("Cannot open source");
	read(src, &header, 3);
	header[3]=0;
	if(strcmp(header, "DVM")!=0)
		error("Not a DVM");
	read(src, &fullqrt, 1);
	switch(fullqrt) {
		case 'F':
			version=0x10;
			infobyte=160;
			break;
		case 'Q':
			version=0x10;
			infobyte=32;
			break;
		case 'V':
			read(src, &version, 1);
			if(version>0x40)
				error("Cannot handle this DVM version");
			read(src, &infobyte, 1);
			break;
		default:
			error("Wrong DVM");
	}
	read(src, &dtime, 2);
	t=false;
	if((infobyte&0x08)==0x08) {
		read(src, &textsize, 2);
		txt=creat("DVMTXT.TMP", S_IWRITE);
		for(work=0; work<textsize; work++) {
			read(src, &c, 1);
			_write(txt, &c, 1);
		}
		close(txt);
		t=true;
	}
	printf("\nInformation about the source:\n\nDVM version %u.%u\n",(version&0xf0)>>4,(version&0x0f));
	if((infobyte&0x80)==0x80)
		printf("Full screen (320x200)\n");
	else
		printf("Quarter screen (160x100)\n");
	switch(infobyte&0x14) {
		case 0x14:
			nobitin=1;
			linesizein=20;
			nocolors=2;
			break;
		case 0x04:
			nobitin=2;
			linesizein=40;
			nocolors=4;
			break;
		case 0x00:
			nobitin=4;
			linesizein=80;
			nocolors=16;
			break;
		case 0x10:
			nobitin=8;
			linesizein=160;
			nocolors=256;
	}
	printf("%d colors ", nocolors);
	switch(infobyte&0x20) {
		case 0x00:
			printf("Standard palette\n");
			break;
		case 0x20:
			printf("Enhanced palette\n");
			break;
		case 0x22:
			printf("One enhanced palette for whole file\n");
	}
	if((infobyte&0x40)==0x40)
		printf("Compressed\n");
	else {
		printf("Not compressed\n");
		nobitin=8;
		linesizein=160;
	}
	if((infobyte&0x08)==0x08) {
		printf("Text included:\n");
		txt=open("DVMTXT.TMP",O_RDONLY|O_BINARY);
		do {
			read(txt, &c, 1);
			printf("%c", c);
		} while(eof(txt)==0);
		close(txt);
		printf("\n");
	}
	else
		printf("No text included\n");
	printf("\nEnter destination name: ");
	gets(dstname);
	addext(dstname);
	printf("Which version?\n\n(1) version 1.0\n(2) version 2.0\n(3) version 3.0\n(4) version 3.1\n(5) version 4.0\n\nEnter version: ");
	do {
		answer=getch();
	} while(answer<'1'||answer>'5');
	printf("%c\n", answer);
	switch(answer) {
		case '1':
			vout=0x10;
			break;
		case '2':
			vout=0x20;
			break;
		case '3':
			vout=0x30;
			break;
		case '4':
			vout=0x31;
			break;
		case '5':
			vout=0x40;
	}
	fullscreen=flag("Full screen?");
	if(vout==0x30|vout==0x31)
		c256=flag("Use 256 colors?");
	else
		c256=false;
	if(c256) {
		palettesize=768;
		nobitout=8;
		linesize=160;
	}
	else {
		palettesize=48;
		nobitout=4;
		linesize=80;
	}
	cbit=false;
	if(vout>=0x40) {
		printf("How many colors?\n\n(1) 2\n(2) 4\n(3) 16\n(4) 256\n\nEnter number of colors: ");
		do {
			answer=getch();
		} while(answer<'1'||answer>'5');
		printf("%c\n", answer);
		switch(answer) {
			case '1':
				c256=true;
				cbit=true;
				palettesize=6;
				nobitout=1;
				linesize=20;
				break;
			case '2':
				c256=false;
				cbit=true;
				palettesize=12;
				nobitout=2;
				linesize=40;
				break;
			case '3':
				c256=false;
				cbit=false;
				palettesize=48;
				nobitout=4;
				linesize=80;
				break;
			case '4':
				c256=true;
				cbit=false;
				palettesize=768;
				nobitout=8;
				linesize=160;
		}
	}
	if(vout>=0x20) {
		compression=flag("Use compression?");
		enhanced=flag("Use enhanced palette?");
		if((enhanced)&&(vout>=0x40))
			oneenh=flag("Use one palette for whole DVM?");
		else
      	oneenh=false;
	}
	else {
		compression=false;
		enhanced=true;
	}
	if(!compression) {
		nobitout=8;
		linesize=160;
	}
	if(vout>=0x31)
		itxt=flag("Include text?");
	else
		itxt=false;
	dst=creat(dstname, S_IWRITE);
	_write(dst, &header, 3);
	if(vout==0x10) {
		if(fullscreen==1) {
			fullqrt='F';
			ib=160;
			linesize=160;
		}
		else {
			fullqrt='Q';
			ib=32;
		}
		_write(dst, &fullqrt, 1);
	}
	else {
		fullqrt='V';
		_write(dst, &fullqrt, 1);
		_write(dst, &vout, 1);
		ib=0;
		if(fullscreen)
			ib+=128;
		if(compression)
			ib+=64;
		if(enhanced)
			ib+=32;
		if(c256)
			ib+=16;
		if(itxt)
			ib+=8;
		if(cbit)
			ib+=4;
		if(oneenh)
			ib+=2;
		_write(dst, &ib, 1);
	}
	_write(dst, &dtime, 2);
	if(itxt)
		if(t) {
			txt=open("DVMTXT.TMP", O_RDONLY|O_BINARY);
			textsize=filelength(txt);
			_write(dst, &textsize, 2);
			do {
				read(txt, &c, 1);
				_write(dst, &c, 1);
			} while(eof(txt)==0);
			close(txt);
		}
		else {
			printf("Enter text: ");
			gets(txts);
			textsize=strlen(txts);
			_write(dst, &textsize, 2);
			_write(dst, &txts, textsize);
		}
	for(work=0; work<16; work++) {
		palette[work*3]=work*4.2;
		palette[work*3+1]=work*4.2;
		palette[work*3+2]=work*4.2;
	}
	for(r=0; r<6; r++)
		for(g=0; g<6; g++)
			for(b=0; b<6; b++) {
				palette[(r*36+g*6+b)*3+48]=r*12.6;
				palette[(r*36+g*6+b)*3+49]=g*12.6;
				palette[(r*36+g*6+b)*3+50]=b*12.6;
			}
	for(work=0; work<8; work++) {
		palette[696+work]=work*9;
		palette[697+work]=0;
		palette[698+work]=0;
		palette[720+work]=0;
		palette[721+work]=work*9;
		palette[722+work]=0;
		palette[744+work]=0;
		palette[745+work]=0;
		palette[746+work]=work*9;
	}
	printf("Converting");
	first=true;
	do {
		switch(infobyte&0x22) {
			case 0x20:
				read(src, &palette, nocolors*3);
				break;
			case 0x22:
				if(first)
					read(src, &palette, nocolors*3);
		}
		if((infobyte&0x80)==0x80)
			for(work=0; work<200; work++) {
				read(src, &line, linesizein*2);
				w=0;
				wib=8;
				for(work2=0; work2<320; work2++)
					vidmem[work2+work*320]=getbyte();
			}
		else {
			for(work=0; work<100; work++) {
				read(src, &line, linesizein);
				w=0;
				wib=8;
				for(work2=0; work2<160; work2++) {
					usebyte=getbyte();
					vidmem[work2*2+work*640]=usebyte;
					vidmem[work2*2+work*640+1]=usebyte;
					vidmem[work2*2+work*640+320]=usebyte;
					vidmem[work2*2+work*640+321]=usebyte;
				}
			}
		}
		if((ib&0x20)==0x20)
			if(!(ib&0x02))
				_write(dst, &palette, palettesize);
			else {
				if(first)
					_write(dst, &palette, palettesize);
				first=false;
			}
		if(fullscreen)
			for(work=0; work<200; work++) {
				w=0;
				wib=8;
				for(work2=0; work2<320; work2++)
					putbyte(vidmem[work*320+work2]);
				_write(dst, &line, linesize*2);
			}
		else
			for(work=0; work<100; work++) {
				w=0;
				wib=8;
				for(work2=0; work2<160; work2++)
					putbyte(vidmem[work*640+work2*2]);
				_write(dst, &line, linesize);
			}
		printf(".");
		first=false;
	} while(!eof(src));
	close(src);
	close(dst);
	if(t)
		unlink("DVMTXT.TMP");
}