/****************************************************************************
    RANDFILE.C:  Randomly selects a file out of the path specified by the
                 first parameter, and copies it to the target specified by
                 the second parameter.


    Copyright (C) 1993 by Zachary G. Ives.  All Rights Reserved.

    Language:  Microsoft C++ 7.0.


    Custom-written for Robert Griffith, sysop of The Griffon's Lair BBS:
     WWIVnet node 7729.  (707) 486-5935; 14.4Kbps, CD-ROM, 90+ message bases!

    This program may be freely copied, modified, and distributed, provided
    that:
        The original copyright notices are not removed.
        This program is not sold or licensed to anyone for a fee.


 ****************************************************************************/



#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <time.h>

struct NodeStruc {
    char FileName[13];
    struct NodeStruc *Next;
};

typedef struct NodeStruc Node;


#define BUFSIZE 1024

int main(int argc, char *argv[]);
char *randchoose(char *filespec);


int main(int argc, char *argv[])
{
    FILE *source, *dest;
    char path[_MAX_PATH], dir[_MAX_PATH], search[13];
    char drive[3], ext[5];
    static char buf[BUFSIZE];
    size_t bytes;

    puts ("RandFile 1.00, copyright (C) 1993 by Zachary G. Ives.  All Rights Reserved.\n");


    if (argc != 3) {            /* Not two args */
        puts ("Syntax:");
        puts ("\tRandFile {source filespec} {dest filename}");
    }
    else {                      /* Two names given on command line */


        /* Here we will read in the filenames */

        /* Expand first parameter to a full pathname */
        if (_fullpath(path, argv[1], _MAX_PATH) == NULL) {
            puts ("Source file specification invalid.");
            exit (1);
        }


        _splitpath(path, drive, dir, search, ext);
        strcat (search, ext);       /* Search path is now set */


        /* Go to drive we're supposed to */
        if (_chdrive(toupper(*drive) - 'A' + 1) != 0) {
            puts ("Source file specification invalid.");
            exit (1);
        }

        /* Now go to directory */
        dir[strlen(dir) - 1] = 0;   /* Chop off trailing \ char */
        if (_chdir(dir) != 0) {
            puts ("Source file specification invalid.");
            exit (1);
        }


        strcpy (path, randchoose(search));
        if (path == NULL) {
            puts ("Source file specification invalid.");
            exit (1);
        }

        /* Try to create an output file */
        if ((dest = fopen(argv[2], "wb")) != NULL) {
            if ((source = fopen(path, "rb")) != NULL) {

                /* Read bytes from the input file and output them to the
                   destination file until we get to EOF */
                while (bytes = fread (buf, sizeof (char), BUFSIZE, source))
                    fwrite (buf, sizeof (char), bytes, dest);

                fclose(source);
                fclose(dest);
                exit(0);
            }
            else {
                puts ("Cannot open source file.");
                exit (1);
            }
        }
        else {
            puts ("Destination filename invalid or file I/O error.");
            exit (1);
        }

    }

    exit (0);
}


char *randchoose(char *filespec)
{
    struct _find_t fileinfo;
    int count = 0, i;
    Node *Start = NULL, *Current = NULL;
                                    /* Search for normal & archive files */
    unsigned attrib = _A_NORMAL | _A_ARCH;
    time_t nowtime;


    /* See if there exists at least one file */
    if (_dos_findfirst(filespec, attrib, &fileinfo) != 0)
        return NULL;


    do {
        count++;
        if (Current == NULL)
                                    /* Create a first node */
            Start = Current = (Node *) malloc(sizeof(Node));
        else {                      /* Attach a new node */
            Current->Next = (Node *) malloc(sizeof(Node));
            Current = Current->Next;
        }
        strcpy(Current->FileName, fileinfo.name);

        Current->Next = NULL;       /* Be sure next node ptr is always NULL */
    } while (_dos_findnext(&fileinfo) == 0);


    time (&nowtime);                /* Get seconds since midnight */

    srand (nowtime);

    do {
        i = (int) ((double) count / RAND_MAX * 2 * rand());
    } while (i > count);

    count = i;
    Current = Start;
    for (i = 0; i < count - 1; i++)
        Current = Current->Next;

    return Current->FileName;
}
