/* 

	The IBMCOM library implements a simple set of interrupt
   routines for ports 1 thru 4 of the IBM PC/XT/AT family and
   clones.	The interrupt routines use circular buffers. These
   routines have been tested up 112 kbaud.  Buffer sizes and
   other features can be changed	by changing defines in ibmcom's
   source code.

	The input side of the routines are interrupt driven using the
	conventional approach to implementing interrupts with TurboC.
   The output side of the routines use a simple polled technique
   or optionally are interrupt driven.

   If you have any comments lets us know via our compuserve number
   (75036,1602). Any bugs?  Let us know.

									Thanks 
									Al Morgan

		PS. This code is subject to the normal disclaimer. We specifically
	disclaim all warranties, expressed or implied, including but not
	limited to implied warranties of merchantability and fitness for a
	particular purpose with respect to defects in the documentation and
	with 	respect to any particular application, use, or 	purpose.  In
	no event shall Intrinsic be liable for any loss of profit or any
	other commercial damage, including but not limited to special,
	incidental consequential or other damages.  	 	
																				*/

   #include "ibmcom.h"
	#include "circ_buf.h"			/* contains circular buffer structure definitions */

	#define		FALSE						0
	#define		TRUE						1

main()
{
	int pe,i,j,nc,port;
	char tbuffer[100];
/*

	This main routine is mainly for testing the communications routines.
	Its also shows how the routine can be used, and in what sequence.

																							*/
	printf("Testing %s\n",__FILE__);
	printf("Version Date: %s, Time: %s\n",__DATE__,__TIME__);
	port = 1;


	/* First initialize the ports baud rate, parity, etc */

	if( init_port(port,19,'n',8,1) != TRUE)
	{
		puts("Error on initializing the baud rate,etc\n");
		exit(0);
	}

	/* Next initialize the interrupt drivers for the port */

	if(!init_handl(port))
   {
      puts("Error on intializing the interrupt handlers\n");
      exit(0);
   }

	/* Initialize the interrupt output buffers for the port */
   /* Only needed if you want to use interrupt driven output */

      init_buffer_out(port);

   puts("Press the ESC key to exit this demo...");
   putsi_com(port,"Hello\n\r",7);      /* interrupt driven output */


do
	{
		if( (pe=check_port_hw(port)) < 0 ) /* If < 0 then a port error */
		{
			printf("Port Error 0x%02x%c\n",-pe,7);
			report_serial_status(-pe);	/* print out the error code in english */
   		report_circ_status(port); 	/* for debugging */
		}
		if(pe > 0 )	/* If no port errors, see any chars in ports buffer */
		{
			while((nc = gets_com (tbuffer,sizeof(tbuffer),port)) != 0)
			{
            printf("\nPrint out of buffer nc = %d\n",nc);
            putsi_com(port,"Hello\n\r",7);
				for(i=0;i<nc;i++)
					putch(tbuffer[i]);  	/* display the characters on the console */
			}
		}
	}
	while(ci() != 27);
	reset_port(port);		/* before we exit, turn off interrupts */
   printf("Exiting program...\n");
}
