/****************************************************************************/
/* TGROUP                                                                   */
/*--------------------------------------------------------------------------*/
/* Objet TGroup (Type gnrique d'objet comprenant d'autres objets dont un  */
/*               seul  la fois a le focus)                                 */
/****************************************************************************/

#ifndef _TGROUP_H_
#define _TGROUP_H_

#include "Types.h"

#include "Keyboard.h"

#include "TObject.h"


class TGroup:public TObject
{
  /*-------------*/
  /* Objets amis */
  /*-------------*/

  friend TObject; // Pour que les objets puissent se
		  // rajouter au groupe...

  /*-----------------*/
  /* Champs protgs */
  /*-----------------*/

  protected:

    // Objet du groupe qui a le focus

    PObjectNode f_focused_element;

    // Indique si le groupe peut n'avoir aucun lment
    // avec le focus quand lui l'a

    boolean f_need_focused_element;

  /*--------------------*/
  /* Mthodes publiques */
  /*--------------------*/

  public:

    // Constructeur / Destructeur

		    TGroup(PObject parent,
			   int type,
			   int rel_x,int rel_y,
			   int width,int height,
			   unsigned background,
			   char *caption,
			   boolean enabled,
			   boolean focus_depending_aspect,
                           boolean can_be_enabled,
			   boolean need_focused_element);
    virtual         ~TGroup();

    // Mthodes d'accs

    virtual PObject m_get_focused_element();

    // Donne le focus au groupe (au 1er/dernier de ses objets qui le veut)

    virtual boolean m_can_lose_focus();
    virtual boolean m_set_focus();
    virtual boolean m_set_focus_to_last_element();

    // Retourne l'objet du groupe qui a le focus

    virtual PObject m_get_focused_object();



  /*--------------------*/
  /* Mthodes protges */
  /*--------------------*/

  protected:

    virtual void    m_del_element(int object_number);

    // Attribution du focus  un objet du groupe

    virtual boolean m_set_focus_to_element(int object_number);

    // Prise/Perte du focus

    virtual void    m_lose_focus();

    virtual void    m_take_focus();

    // Evnements

    virtual boolean m_left_button_pressed_event(int x,int y);
    virtual boolean m_left_button_double_click_event(int x,int y);
    virtual boolean m_key_pressed_event(TKey key);

    // Donne le focus (si possible)  celui qui prcde ou suit celui
    // qui a le focus

    virtual boolean m_set_focus_to_previous_element();
    virtual boolean m_set_focus_to_next_element();


  /*------------------*/
  /* Mthodes prives */
  /*------------------*/

  private:

    // Evnements

    virtual boolean m_tab_pressed_event();
    virtual boolean m_shift_tab_pressed_event();

    // L'objet peut obtenir le focus lors d'un dplacement
    // avec les touches flches

    virtual boolean m_focus_can_be_set_by_arrow_key() {return(FALSE);};
};

#endif