/*
    A generic help system.  Written by Sean O'Connor on 11-19-90.
        
    See help_sys.doc for more info.
*/        

#include "eel.h"

command help_sys() on reg_tab[FALT(1)]  /* use alt-f1 */
{
    char doc_file[FNAMELEN],    /* helpfile.doc (should be in EPSPATH dir) */
         idx_file[FNAMELEN],    /* helpfile.idx */
         *original_buffer = bufname,    /* save original buffer name */
         helpfunc[80],                  /* name of topic to look up */
         line[160],                     /* line of input from file */
         *p,                            /* pointer to parse digits */
         digits[10],                    /* string of digits */
         buf[2];                        /* buffer to read help file */
    short index,                        /* index in string */
          done = 0;                     /* at end of help topic? */
    int  offset,                        /* offset of topic in help file */
         handle,                        /* file handle for help file */
         orig_point = point;            /* save oroginal point */
    
    iter = 0;
    helpfunc[0] = ':';       /* stuff in a colon to avoid partial matches */
    re_search (1, word_pattern);        /* get topic at cursor */
    re_search (-1, word_pattern);
    grab (point, matchstart, line);     /* grab info at cursor */
    get_strdef (helpfunc + 1, "Topic", line);   /* check with user */

    if (strlen(helpfunc+1) == 0)        /* return if zero length */
        return;
    
    zap("tempbuf");                     /* clear temporary buffer */
    bufname = "tempbuf";                /* temp buffer active */
    
    /* get helpfile index name from path */
    strcpy(idx_file, lookpath("helpfile.idx"));
    
    if (file_read(idx_file, 1) > 0)     /* read index into buffer */
    {
        error("Read error: %s", idx_file);
        return;
    }

    if (!search(1, helpfunc))           /* find topic */
    {
        bufname = original_buffer;
        point = orig_point;
        delete_buffer("tempbuf");
        error("Help entry not found: %s", helpfunc+1);
        return;
    }
                
    to_begin_line();                    /* grab topic info */
    grab(point, point+80, line);
    
    p = line;                           /* point to line begin */
    while (*p && !isspace(*p))          /* skip topic name */
        p++;
    index = 0;
    p++;
    while (*p && isdigit(*p))           /* get offset */
    {
        digits[index++] = *p;
        p++;
    }
    digits[index] = '\0';
    offset = strtoi(digits, 10);        /* convert to int */
    bufname = original_buffer;
    delete_buffer("tempbuf");           /* destroy temp buffer */
    
    zap("-helpsys");                    /* clear previous help buffer */
    bufname = "-helpsys";               /* make help buffer */
    
    /* get helpfile doc from path */
    strcpy(doc_file, lookpath("helpfile.doc"));
    
    /* open file and seek to proper offset from index */
    handle = lowopen(doc_file, 0);
    lowseek(handle, offset, 0);

    do
    {
        index = 0;
        while (1)       /* get a line until LF */
        {
            if (!lowread(handle, buf, 1))   /* check for EOF */
            {
                done = 1;
                line[index] = '\0';
                break;
            }
            line[index++] = buf[0];
            if (buf[0] == 10)
            {
                line[index - 2] = '\0'; /* trim CR/LF */
                break;
            }
        }
        strcat(line, "\n");         /* add a newline */
        
        /* check to see if next context found */
        if (!strncmp(line, ".context ", 9))
            done = 1;
        else
            stuff(line);            /* stuff line into help buffer */
        
    } while (!done);

    lowclose(handle);                   /* close help doc file */

    window_split(HORIZONTAL);           /* split window to show help */
    
    point = 0;                          /* move cursor to begin of help */

    next_window();                      /* go to other window (source) */

    bufname = original_buffer;          /* go back to buffer and point saved */
    point = orig_point;
}
