;*
;* Loading routines for PCX images and VSA 3d objects
;* by Piotr Ulaszewski
;* The called function clears the stack
;* All arguments are 32bit
;* See MANUAL.TXT for detailed info about each function
;*

; globals for the file formats (FFORMATS.ASM)
global _PcxUnpack                                ;proc
global _ActivePcxPal                             ;proc

%include "include\segments.inc"
%include "include\message.mac"

segment _DATA

FileHandle dw 0                         ; used only temporarly
FileSize dd 0                           ; used only temporarly

CompressedPcxAddress dd 0
CompressedPcxMemoryHandle dd 0
PCXAddress dd 0
PCXSize dd 0


segment _TEXT

;******************************************************************************
;*
;* PcxUnpack: Load & Decompress an 8bit PCX image of any size
;* In:
;*    push dword - Linear address of destination (memory allocated by user)
;*    push dword - ASCIIZ path name
;*
;* Out:
;*    EAX    - NULL in case of error
;*           - pointer to uncompressed PCX in case of success
;*
;******************************************************************************
_PcxUnpack:
	push ebx
	push ecx
	push edx
	push esi
	push edi
	push ebp
	mov edx,[esp+4+24]			; ASCIIZ path name at DS:EDX
	mov edi,[esp+8+24]			; destination address

	push edi
	mov [PCXAddress],edi                    ; uncompressed PCX address
	mov ax,3D02h
	int 21h
	jc near .@@pcx_exit2
	mov [FileHandle],ax

	mov ax,4202h
	mov bx,[FileHandle]
	xor dx,dx
	xor cx,cx
	int 21h
	shl edx,16
	mov dx,ax
	mov [FileSize],edx                      ; size of compressed PCX image

	mov ax,4200h
	mov bx,[FileHandle]
	xor dx,dx
	xor cx,cx
	int 21h

	mov ax,0501h
	mov ebx,[FileSize]
	mov cx,bx
	shr ebx,16
	int 31h
	jc near .@@pcx_exit                     ; not enough memory
	shl ebx,16
	mov bx,cx
	mov [CompressedPcxAddress],ebx
	shl esi,16
	mov si,di
	mov [CompressedPcxMemoryHandle],esi

	mov ax,3F00h
	mov bx,[FileHandle]
	mov ecx,[FileSize]
	mov edx,[CompressedPcxAddress]
	int 21h
	jc near .@@pcx_error

	mov ax,3E00h
	mov bx,[FileHandle]
	int 21h

	mov esi,[CompressedPcxAddress]          ; ESI = compressed PCX header
	cmp byte [esi+3],8
	jne near .@@pcx_error
	movzx eax,word [esi+8]                  ; X1
	sub ax,[esi+4]                          ; X0
	inc eax
	movzx ebx,word [esi+10]                 ; y1
	sub bx,word [esi+6]                     ; y0
	inc ebx
	imul eax,ebx
	mov [PCXSize],eax

	pop edi                                 ; EDI = uncompressed PCX address
	add esi,128
	xor ecx,ecx
.@@GoUnpack:
	mov cl,[esi]
	cmp cl,192
	jna .@@NoCrunch
	sub cl,192
	mov al,[esi+1]
	rep stosb
	add esi,byte 2
	jmp short .@@EndCrunch
.@@NoCrunch:
	mov [edi],cl
	inc edi
	inc esi
.@@EndCrunch:
	mov eax,edi
	sub eax,[PCXAddress]                            ; uncompressed PCX address
	cmp eax,[PCXSize]
	jb .@@GoUnpack

	mov esi,[CompressedPcxAddress]
	add esi,[FileSize]
	sub esi,768

	mov cx,768
.@@PcxUpkPal:
	mov al,[esi]
	shr al,2
	mov [edi],al
	inc esi
	inc edi
	dec cx
	jnz .@@PcxUpkPal

	mov eax,0502h
	mov esi,[CompressedPcxMemoryHandle]
	mov di,si
	shr esi,16
	int 31h
	mov eax,[PCXAddress]
	jmp .@@pcx_done
.@@pcx_error:
	mov ax,0502h
	mov esi,[CompressedPcxMemoryHandle]
	mov di,si
	shr esi,16
	int 31h
.@@pcx_exit:
	mov ax,3E00h
	mov bx,[FileHandle]
	int 21h
.@@pcx_exit2:
	pop edi
	xor eax,eax
.@@pcx_done:
	pop ebp
	pop edi
	pop esi
	pop edx
	pop ecx
	pop ebx
	ret



;******************************************************************************
;*
;* ActivePcxPal: Active the palette stored at end of the buffer
;* In:
;*    push dword    - Linear address of uncompressed PCX
;*
;******************************************************************************
_ActivePcxPal:
	pushad
	mov     edi,[esp+4+32]			
	add     edi,[PCXSize]
	cmp     edi,64000
	ja      .@@NoPCXModif
	dec     edi
.@@NoPCXModif:
	mov     cx,256
.@@Pcxactivpall:
	mov     dx,03C8h
	mov     ax,256
	sub     ax,cx
	out     dx,al
	inc     dx
	mov     al,[edi]
	out     dx,al
	mov     al,[edi+1]
	out     dx,al
	mov     al,[edi+2]
	out     dx,al
	add     edi,3
	dec     cx
	jnz     .@@Pcxactivpall
	popad
	ret



