;
; interrupt handlers for protected mode (v 0.1)
; by Piotr Ulaszewski
;

%include "include\segments.inc"

global _key_table			; pointer to key table
global _exit_program			; proc
global _key_init			; proc
global _key_deinit			; proc


segment _DATA
_key_table dd 0                         ; address of key_tab
old_key_handler_offset dd 0
old_key_handler_selector dw 0
flat_mode_data_selector dw 0            ; needed for IRQ
key_tab times 128 db 0                  ; a 128 byte buffer to hold key info

;******************************************************************************
;* keyboard handler
;* enable    :      call key_init
;*
;* disable   :      call key_deinit
;*
;******************************************************************************
segment _TEXT
_key_init:
	cli
	pushad
	push ds
	push es

	mov eax,key_tab
	mov [_key_table],eax
	mov edi,eax
	mov ecx,32
	xor eax,eax
	rep stosd
	
	mov ax,3509h
	int 21h
	mov [old_key_handler_offset],ebx
	mov [old_key_handler_selector],es

	mov ax,0ah                              ; losing ds,es,fs,gs on IRQ!
	mov bx,cs
	int 31h
	mov [flat_mode_data_selector],ax

	mov ax,2509h
	mov edx,irq9
	push cs
	pop ds
	int 21h

	pop es
	pop ds
	popad
	sti
	ret

_key_deinit:
	cli
	pushad
	push ds

	mov edx,[old_key_handler_offset]
	mov ds,[old_key_handler_selector]
	mov ax,2509h
	int 21h

	pop ds
	popad
	sti
	ret

irq9:
	cli
	pushad

	mov ds,[cs:flat_mode_data_selector]     ; needed for IRQ

	mov al,020h
	out 20h,al

	xor eax,eax
	in al,60h
	cmp al,080h
	jae .@@clr
	mov edi,[_key_table]
	add edi,eax
	mov byte [edi],1
	jmp .@@end
.@@clr:
	mov edi,[_key_table]
	sub eax,080h
	add edi,eax
	mov byte [edi],0
.@@end:
	sti
	cmp al,1                        ; was ESC pressed ?
	je _exit_program                ; if yes then end up the program
	popad
	iretd

_exit_program:                          ; you may call this from anywhere
	mov ax,03
	int 10h
	call _key_deinit
	mov ax,4c01h
	int 21h

