/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       DPUDUMP.C
**     SYSTEM   NAME:       PACKET DISPATCHER
**     ORIGINAL AUTHOR(S):  Ling Thio
**     VERSION  NUMBER:     v1.00
**     CREATION DATE:       1989/11/30
**
** DESCRIPTION: Functions to display a percentage
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPUPERC.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPU/VCS/DPUPERC.C_V  $
**              
**                 Rev 1.0   25 Oct 1990 15:26:38   etstjan
**              Initial revision.
*************************************************************************/
#include "dpuinc.h"

/************************************************************************
** NAME:        DpuPerc
** SYNOPSIS:    void DpuPerc(pWin, row, col, Perc)
**              PWWIN *pWin         Ptr to POWER window
**              int row, col        Position
**              int Perc            1/10 percentage
** DESCRIPTION: Prints percentage in window (xxx.x).
** RETURNS:     void
*************************************************************************/
void DpuPerc(pWin, row, col, Perc)
PWWIN *pWin;
int row;
int col;   
int Perc;
{
    int i = 0;

    pw_putcat(pWin, row, col+4, Perc % 10 + '0');
    Perc /= 10;
    pw_putcat(pWin, row, col+3, '.');
    while ((i<2) && (Perc || !i))
    {
        pw_putcat(pWin, row, col+2-i, Perc % 10 + '0');
        Perc /= 10;
        i++;
    }
    while (i<2)
    {
        pw_putcat(pWin, row, col+2-i, ' ');
        i++;
    }
}


