/* [DOC] File ****************************************************
** MODULE INFORMATION*
**********************
**      FILE    NAME:       PWGHSCR.C
**      SYSTEM  NAME:       POWER
**      VERSION NUMBER      3.00
**
** Descr:       Horizontal scroll function
**              Programmer Oriented Window Environment Routines.
**              (NoC) July 1989 - Ling Thio Software Productions.
******************************************************************
** ADMINISTRATIVE INFORMATION*
******************************
**      ORIGINAL AUTHOR:    Ling Thio
**      CREATION DATE:      89/07/10
**      CHANGES:            none
*****************************************************************/

#include "pwinc.h"                          /* main include file */

/* [DOC] Function *********************************************
** Name:        pw_hscroll                                [API]
** SYNOPSIS:    void pw_hscroll(win, srow, scol, nrow, ncol, 
**                              nscrolls)
**              PWWIN *win          Pointer to window handle
**              int   srow, scol    Topleft scroll area
**              int   nrow, ncol    Bottomright scroll area
**              int   nscrolls      # of rows to scroll
** Descr:       Scrolls portion of window up or down.
**              The 'pw_hscroll' function scrolls the window
**                'win' by a number of columns.
**              If 'nscrolls' < 0: scroll -'nscrolls' lines right.
**              If 'nscrolls' > 0: scroll 'nscrolls' lines left.
**              If 'nrow' == 0 or 'ncol' == 0:
**                the function will make the scroll area
**                as large as possible (window size).
**              The attribute used for the new lines is
**                PWT_NORMAL.
** RETURNS:     void
** EXAMPLE:         ...Scroll an entire window 2 lines left:...
**              pw_hscroll(example_win, 0, 0, 0, 0, 2);        
**                  ....
** SEE ALSO:    pw_vscroll
**************************************************************/
void pw_hscroll(PWWIN *win, int srow, int scol, int nrow, int ncol,
                int nscrolls)
{
    int row = (nrow) ? nrow : win->nrow-srow;
    int col = (ncol) ? ncol : win->ncol-scol;

    if (nscrolls<0)
        pwb_scroll_right(win, srow, scol, row, col, -nscrolls);
    else
        pwb_scroll_left(win, srow, scol, row, col, (nscrolls) ? nscrolls : col);
}
