/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       iplib.h
**     SYSTEM   NAME:       ip
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/5/10
**
** DESCRIPTION: Contains headers for the IP library file.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   IPLIB.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/IPLIB.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 11:40:48   etstjan
**              No explicit note
*************************************************************************/

/* global defines */
#ifdef BIG_ENDIAN
  #define LIMBRCAST      0xffffffffl        /* limited bcast address      */
  #define NONSTBRCAST    0x00000000l        /* non standard bcast address */
  #define INTLOOPBACK    0x7f000001l        /* internal loopback address  */
  #define INADDR_ANY     0x00000000l        /* wildcard IP address        */
  #define AHOSTMASK      0x00ffffffl        /* A-Class Host part mask     */
  #define BHOSTMASK      0x0000ffffl        /* B-Class Host part mask     */
  #define CHOSTMASK      0x00ffffffl        /* C-Class Host part mask     */

  #define IN_CLASSA(i)   ((i & 0x80000000l) == 0l)
  #define IN_CLASSB(i)   ((i & 0xc0000000l) == 0x80000000l)
  #define IN_CLASSC(i)   ((i & 0xe0000000l) == 0xc0000000l)
#endif                                            

#ifdef LITTLE_ENDIAN
  #define LIMBRCAST      0xffffffffl        /* limited bcast address      */
  #define NONSTBRCAST    0x00000000l        /* non standard bcast address */
  #define INTLOOPBACK    0x0100007fl        /* internal loopback address  */
#ifndef INADDR_ANY
  #define INADDR_ANY     0x00000000l        /* wildcard IP address        */
#endif
  #define AHOSTMASK      0xffffff00l        /* A-Class Host part mask     */
  #define BHOSTMASK      0xffff0000l        /* B-Class Host part mask     */
  #define CHOSTMASK      0xff000000l        /* C-Class Host part mask     */

  #define IN_CLASSA(i)   ((i & 0x00000080l) == 0l)
  #define IN_CLASSB(i)   ((i & 0x000000c0l) == 0x00000080l)
  #define IN_CLASSC(i)   ((i & 0x000000e0l) == 0x000000c0l)
#endif                                            

/* prototypes */

USHORT     OnesSum(ULONG Source);
ULONG      CompSum(BYTE *Data, USHORT Len);
USHORT     CompCheck(BYTE *Data, USHORT Len);
ULONG      LinkCheckSum(DATALINK *ThisLink);
int        CipToByte(BYTE *Destin, CIPHEAD *Source);
int        ByteToCip(CIPHEAD *Destin, BYTE *Source);
int        OptionsToCip(CIPHEAD *Destin, BYTE *Source, USHORT Length);
int        CipToOptions(BYTE *Destin, CIPHEAD *Source);
void       AllignOptions(CIPHEAD *ThisHeader);
void       RemoveNonCopyOptions(CIPHEAD *ThisHeader);
void       RemoveOption(CIPHEAD *ThisHeader, USHORT Distance);
void       MakeRespondOptions(CIPHEAD *ThisHeader);
USHORT     DLinkToByte(BYTE *Destin, DATALINK *Source);
int        CudpToByte(BYTE *Destin, CUDPHEAD *Source);
int        ByteToCudp(CUDPHEAD *Destin, BYTE *Source);
USHORT     UDPCheckSum(CIPHEAD *IPHead, DATALINK *ThisLink);

void       AddressSwap(ADDRESS_T *Address1, ADDRESS_T *Address2);

USHORT     DLinkLen(DATALINK *Source);
void       DiscardAll(DATALINK *LinkPnt);
DATALINK   *SplitDataLink(DATALINK *ThisLink, DATALINK **LastLink, USHORT Size);
DATALINK   *IPDataLinkGet(USHORT Size);
int        IPDataLinkFree(DATALINK *ThisLink);

int        CicmpToByte(BYTE *Destin, CICMPHEAD *Source);
int        ByteToCicmp(CICMPHEAD *Destin, BYTE *Source);

ADDRESS_T  GetNetMask(ADDRESS_T ThisAddress);

#ifdef BIG_ENDIAN
  #define    htonl(x)  x
  #define    htons(x)  x
  #define    ntohl(x)  x
  #define    ntohs(x)  x
#endif

#ifdef LITTLE_ENDIAN
  ULONG      htonl(ULONG hostlong);
  USHORT     htons(USHORT hostshort);
  ULONG      ntohl(ULONG netlong);
  USHORT     ntohs(USHORT netshort);
#endif

ULONG      TimeMilSec(void);






