                page    60, 132
                title   Gate A20 status utility


;************************************************************************
;*
;*      Check to see if line A20 is enabled or disabled.  This routine
;*   is hardware dependent and will only work properly on AT's and 100%
;*   compatibles.
;*
;************************************************************************

                ORG     100h
CODE            segment public 'CODE'
                assume cs:CODE, ds:CODE, es:CODE

Start:          jmp     QueryA20

A20OnMessage    db      13, 10, 'The A20 line is currently ENABLED.', 13, 10, '$'
A20OffMessage   db      13, 10, 'The A20 line is currently DISABLED.', 13, 10, '$'

QueryA20:       mov     ax, cs
                add     ax, 0010h
                mov     ds, ax
                mov     es, ax
                call    IsA20On
                or      ax, ax
                jz      A20Off

A20On:          mov     dx, offset A20OnMessage
                jmp     short QueryDone

A20Off:         mov     dx, offset A20OffMessage

QueryDone:      mov     ah, 09h
                int     21h

                mov     ax, 4C00h
                int     21h


;************************************************************************
;*
;*      Check line A20 status.
;*
;*      Proc    : IsA20On
;*      Params  : None
;*      Return  : AX = 1                --> A20 enabled
;*                AX = 0                --> A20 disabled
;*      Regs    : AX, CX, DI, SI & flags clobbered.
;*      Notes   :
;*
;************************************************************************

LowMemory       label   dword
                dw      00080h
                dw      00000h

HighMemory      label   dword
                dw      00090h
                dw      0FFFFh

IsA20On         proc    near

                push    ds
                push    es

                lds     si, es:LowMemory
                les     di, es:HighMemory
                mov     cx, 4
                cld
                repe    cmpsw

                pop     es
                pop     ds
                xor     ax, ax

                jcxz    IAONoWrap
                inc     ax

IAONoWrap:      xor     bl, bl
                ret

IsA20On         endp


CODE            ends
                end     Start
