// file.c RHS functions for the File pulldown menu selections

#include<windows.h>
#include<stdio.h>
#include"wsmooth.h"
#include"wsmooth2.h"
#include"filebuf.h"
#include<string.h>

#define WM_WSM_DLGPAINT (WM_USER+0x100)

extern HWND WinSmooth;
HANDLE hDlgBrush;

void InitSettings(HWND hDlg);
void ProcessHScroll(WORD wParam, LONG lParam);
BOOL ValidateSRate(HWND hDlg);
BOOL ValidatePixRows(HWND hDlg);

void od_UpdateListBox(HWND hDlg);
void od_ChangeDfExt(PSTR Ext, PSTR Name);
void od_SeparateFilePath(HWND hDlg, LPSTR lpDestPath,
      LPSTR lpDestFileName, LPSTR lpSrcFileName);
void od_AddExtension(PSTR Name, PSTR Ext);

// About Box manager function
BOOL FAR PASCAL About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
    {
    switch (message)
        {
        case WM_INITDIALOG:
            return (TRUE);

        case WM_COMMAND:
    	    if (wParam == IDOK || wParam == IDCANCEL)
                {
                EndDialog(hDlg, TRUE);
                return (TRUE);
                }
            break;
        }
    return (FALSE);
    }

extern HANDLE hOrgBrush;
extern SETTINGS settings;

static SETTINGS s;
static HWND hSrateScroll,hPixRowsScroll,hRedScroll,hGreenScroll,hBlueScroll;
static HDC hDC;
static short fRed = 0, fGreen = 0, fBlue = 0, bRed = 0xff, bGreen = 0xff,
   bBlue = 0xff;
static unsigned foreground = 1;
static char text[50];

BOOL FAR PASCAL Settings(HWND hDlg, unsigned message, WORD wParam,
   LONG lParam)
    {
    switch (message)
        {
        case WM_INITDIALOG:
            InitSettings(hDlg);
            return (TRUE);

        case WM_PAINT:                  // if dialog is painted
            PostMessage(hDlg, WM_WSM_DLGPAINT, 0, 0L);
            return FALSE;

        case WM_WSM_DLGPAINT:
            SetBkMode(hDC,OPAQUE);      // has to be OPAQUE for background color to show
            SetTextColor(hDC, RGB(fRed,fGreen,fBlue));
            SetBkColor(hDC, RGB(bRed,bGreen,bBlue));

            TextOut(hDC,0,0,(LPSTR)text,strlen(text));
            return TRUE;

        case WM_VSCROLL:                // handle changes to 2 scroll bars
            {
            HWND hsb;
            char temp[10];

            if(hsb = HIWORD(lParam))
                {
                if(hsb == hSrateScroll)   // handle changes to rate scroll
                    {
                    if(wParam == SB_LINEDOWN && settings.Msecs > MINMSECS)
                        settings.Msecs--;
                    else if(wParam == SB_LINEUP && settings.Msecs < MAXMSECS)
                        settings.Msecs++;
                    sprintf(temp,"%4u",settings.Msecs);
                    SetDlgItemText(hDlg, IDC_EB_SRATE, temp);
                    }
                if(hsb == hPixRowsScroll) // handle changes to row scroll
                    {
                    if(wParam == SB_LINEDOWN &&
                           settings.PixelRows > MINPIXELROWS)
                        settings.PixelRows--;
                    else if(wParam == SB_LINEUP &&
                           settings.PixelRows < MAXPIXELROWS)
                        settings.PixelRows++;
                    sprintf(temp,"%1u",settings.PixelRows);
                    SetDlgItemText(hDlg, IDC_EB_PIXROWS, temp);
                    }
                }
            }
            return TRUE;

        case WM_HSCROLL:
            ProcessHScroll(wParam, lParam);
            return TRUE;

        case WM_COMMAND:
            switch(wParam)
                {
                case IDC_RB_FG:         // foreground/background switch
                case IDC_RB_BG:
                    foreground = (wParam == IDC_RB_FG) ? TRUE : FALSE;
                    SendMessage(GetDlgItem(hDlg,IDC_RB_FG),BM_SETCHECK,
                        foreground,0L);
                    SendMessage(GetDlgItem(hDlg,IDC_RB_BG),BM_SETCHECK,
                        !foreground,0L);
                    SetScrollPos(hRedScroll,SB_CTL,(foreground ? fRed : bRed),
                        TRUE);
                    SetScrollPos(hGreenScroll,SB_CTL,
                        (foreground ? fGreen : bGreen),TRUE);
                    SetScrollPos(hBlueScroll,SB_CTL,
                        (foreground ? fBlue : bBlue),TRUE);
                    break;

                case IDC_CB_STRIP:
                    settings.stripbits = !settings.stripbits;
                    break;

                case IDC_BU_SAVE:         // save settings
                    {
                    char buf[20];

                    if(!ValidateSRate(hDlg))
                        break;
                    if(!ValidatePixRows(hDlg))
                        break;
                    SendMessage(WinSmooth,WM_WSM_HOURGLASS_CURSOR,0,0L);
                    settings.back = RGB(bRed,bGreen,bBlue);
                    settings.fore = RGB(fRed,fGreen,fBlue);

                    sprintf(buf,"%d",settings.Msecs);
                    WriteProfileString((LPSTR)"WinSmooth",(LPSTR)"Msecs",(LPSTR)buf);
                    sprintf(buf,"%d",settings.PixelRows);
                    WriteProfileString((LPSTR)"WinSmooth",(LPSTR)"PixelRows",(LPSTR)buf);
                    sprintf(buf,"%lu",settings.back);
                    WriteProfileString((LPSTR)"WinSmooth",(LPSTR)"BackGround",(LPSTR)buf);
                    sprintf(buf,"%lu",settings.fore);
                    WriteProfileString((LPSTR)"WinSmooth",(LPSTR)"ForeGround",(LPSTR)buf);
                    sprintf(buf,"%d",settings.stripbits);
                    WriteProfileString((LPSTR)"WinSmooth",(LPSTR)"StripBits",(LPSTR)buf);

                    SendMessage(WinSmooth,WM_WSM_NORMAL_CURSOR,0,0L);
                    }
                    break;

                case IDCANCEL:
                    settings = s;       // structure assign to restore settings
                case IDOK:              // save current settings
                    if(wParam == IDOK)  // save to WIN.INI
                        {
                        HDC h;

                        if(!ValidateSRate(hDlg))
                            break;
                        if(!ValidatePixRows(hDlg))
                            break;
                        h = GetDC(WinSmooth);
                        settings.back = RGB(bRed,bGreen,bBlue);
                        settings.fore = RGB(fRed,fGreen,fBlue);
                        ResetBackGround(h);
                        settings.stripbits = (SendMessage(
                                 GetDlgItem(hDlg,IDC_CB_STRIP),
                                 BM_GETCHECK, 0, 0L) ? TRUE: FALSE);
                        filebuf_strip(settings.stripbits);
                        ReleaseDC(WinSmooth,h);
                        InvalidateRect(WinSmooth,NULL,TRUE);
                        }
                        // code common to OK and CANCEL
                    DeleteObject(hDlgBrush);
                    ReleaseDC(hDlg, hDC);
                    EndDialog(hDlg, TRUE);
                    return (TRUE);
                default:
                    break;
                }
            break;
        }
    return (FALSE);
    }

   // initialize Settings dialog
void InitSettings(HWND hDlg)
    {
    HWND hwnd;
    char temp[10];

    s = settings;               // structure assign to save settings
                                // initialize the edit boxes
    sprintf(temp,"%4u",settings.Msecs);
    SetDlgItemText(hDlg, IDC_EB_SRATE, temp);
    sprintf(temp,"%1u",settings.PixelRows);
    SetDlgItemText(hDlg, IDC_EB_PIXROWS, temp);
                                // get the horz scroll handles
    hSrateScroll = GetDlgItem(hDlg, IDC_SB_SRATE);
    hPixRowsScroll = GetDlgItem(hDlg, IDC_SB_PIXROWS);
    hRedScroll = GetDlgItem(hDlg, IDC_SB_RED);
    hGreenScroll = GetDlgItem(hDlg, IDC_SB_GREEN);
    hBlueScroll = GetDlgItem(hDlg, IDC_SB_BLUE);
                                // set the scroll bar ranges
    SetScrollRange(hSrateScroll,SB_CTL,MINMSECS,MAXMSECS,TRUE);
    SetScrollRange(hPixRowsScroll,SB_CTL,MINPIXELROWS,MAXPIXELROWS,TRUE);
    SetScrollRange(hRedScroll,SB_CTL,0,255,TRUE);
    SetScrollRange(hGreenScroll,SB_CTL,0,255,TRUE);
    SetScrollRange(hBlueScroll,SB_CTL,0,255,TRUE);
                                // and color scroll bar positions
    fRed = GetRValue(settings.fore);
    fGreen = GetGValue(settings.fore);
    fBlue = GetBValue(settings.fore);
    bRed = GetRValue(settings.back);
    bGreen = GetGValue(settings.back);
    bBlue = GetBValue(settings.back);

    SetScrollPos(hRedScroll,SB_CTL,(foreground ? fRed : bRed),TRUE);
    SetScrollPos(hGreenScroll,SB_CTL,(foreground ? fGreen : bGreen),TRUE);
    SetScrollPos(hBlueScroll,SB_CTL,(foreground ? fBlue : bBlue),TRUE);
                                // and color of sample text
    hDC = GetDC(hwnd = GetDlgItem(hDlg,IDC_EB_COLOR));
    GetDlgItemText(hDlg,IDC_EB_COLOR,(LPSTR)text,sizeof(text)-1);

    {
    HANDLE hOldBrush;

    hDlgBrush = CreateSolidBrush(settings.back);
    hOldBrush = SelectObject(hDC,hDlgBrush);
    DeleteObject(hOldBrush);
    SetClassWord(hwnd,GCW_HBRBACKGROUND,hDlgBrush);
    }

    SetBkMode(hDC,OPAQUE);      // has to be OPAQUE for background color to show
                                // check/uncheck the check box
    SendMessage(GetDlgItem(hDlg,IDC_CB_STRIP),BM_SETCHECK,settings.stripbits,0L);
                                // check the foreground radio button
    SendMessage(GetDlgItem(hDlg,IDC_RB_FG),BM_SETCHECK,foreground,0L);
                                // uncheck the background
    SendMessage(GetDlgItem(hDlg,IDC_RB_BG),BM_SETCHECK,!foreground,0L);
    
                                // limit scrolling rate box to 4 chars
    SendMessage(GetDlgItem(hDlg,IDC_EB_SRATE),EM_LIMITTEXT,4,0L);
                                // limit pixel rows box to 1 char
    SendMessage(GetDlgItem(hDlg,IDC_EB_PIXROWS),EM_LIMITTEXT,1,0L);
    }

   // processes color-setting horizontal scroll bars
void ProcessHScroll(WORD wParam, LONG lParam)
    {
    HWND hsb;
    short *color;

    hsb = HIWORD(lParam);
    if(hsb == hRedScroll)
        color = (foreground ? &fRed : &bRed);
    if(hsb == hGreenScroll)
        color = (foreground ? &fGreen : &bGreen);
    if(hsb == hBlueScroll)
        color = (foreground ? &fBlue : &bBlue);

    switch(wParam)
        {
        case SB_PAGEDOWN:
            *color += 15;       // fall thru
        case SB_LINEDOWN:
            *color = min(255,*color+1);
            break;
        case SB_PAGEUP:
            *color -= 15;       // fall thru
        case SB_LINEUP:
            *color = max(0, *color-1);
            break;
        case SB_TOP:
            *color = 0;
            break;
        case SB_BOTTOM:
            *color = 255;
            break;
        case SB_THUMBPOSITION:
        case SB_THUMBTRACK:
            *color = LOWORD(lParam);
        default:
            break;
        }
    SetScrollPos(hsb,SB_CTL,*color,TRUE);
    SetBkMode(hDC,OPAQUE);      // has to be OPAQUE for background color to show
    SetTextColor(hDC, RGB(fRed,fGreen,fBlue));
    SetBkColor(hDC, RGB(bRed,bGreen,bBlue));

    TextOut(hDC,0,0,(LPSTR)text,strlen(text));
    }


BOOL ValidateSRate(HWND hDlg)
    {
    int newrate;
    BOOL flag;
    
    newrate = GetDlgItemInt(hDlg, IDC_EB_SRATE,(BOOL far *)&flag,0);
    if(!flag || (newrate < MINMSECS) || (newrate > MAXMSECS))
        {
        Message(WinSmooth,"Scrolling rate must be a value between %u and %u.",
            MINMSECS,MAXMSECS);
        SendDlgItemMessage(hDlg, IDC_EB_SRATE, EM_UNDO, 0, 0L);
        return FALSE;
        }
    settings.Msecs = newrate;
    return TRUE;
    }

BOOL ValidatePixRows(HWND hDlg)
    {
    int newrate;
    BOOL flag;
    
    newrate = GetDlgItemInt(hDlg, IDC_EB_PIXROWS,(BOOL far *)&flag,0);
    if(!flag || (newrate < MINPIXELROWS) || (newrate > MAXPIXELROWS))
        {
        Message(WinSmooth,"Number of pixel rows scrolled must be a value between %u and %u.",
            MINPIXELROWS,MAXPIXELROWS);
        SendDlgItemMessage(hDlg, IDC_EB_PIXROWS, EM_UNDO, 0, 0L);
        return FALSE;
        }
    settings.PixelRows = newrate;
    return TRUE;
    }



char od_filename[128];
char od_openname[128];
char od_defpath[128];
char od_defspec[13] = "*.txt";
char od_default_extension[] = ".txt";
char str[255];

   // lets user select and open files
HANDLE FAR PASCAL OpenDlg(HWND hDlg, unsigned message, WORD wParam,
   LONG lParam)
    {
    BOOL result;

    switch (message)
        {
        case WM_INITDIALOG:                        // message: initialize    
            od_UpdateListBox(hDlg);
            SetDlgItemText(hDlg, IDC_EDIT, od_defspec);
            SendDlgItemMessage(hDlg,IDC_EDIT,EM_SETSEL,NULL,
               MAKELONG(0, 0x7fff));
            SetFocus(GetDlgItem(hDlg, IDC_EDIT));
            return (FALSE); // Indicates the focus is set to a control 
            break;

        case WM_COMMAND:
            switch (wParam)
                {
                case IDC_LISTBOX:
                    switch (HIWORD(lParam))
                        {
                        case LBN_SELCHANGE:
                            //  If item is a directory name, append "*.*" 
                            if (DlgDirSelect(hDlg, str, IDC_LISTBOX))
                                strcat(str, od_defspec);

                            SetDlgItemText(hDlg, IDC_EDIT, str);
                            SendDlgItemMessage(hDlg,IDC_EDIT,EM_SETSEL,NULL,MAKELONG(0, 0x7fff));
                            break;

                        case LBN_DBLCLK:
                            goto openfile;
                        }
                    return (TRUE);
                    break;

                case IDOK:
openfile:
                    GetDlgItemText(hDlg, IDC_EDIT, od_openname, 128);
                    if (strchr(od_openname, '*') || strchr(od_openname, '?'))
                        {
                        od_SeparateFilePath(hDlg, (LPSTR) str, (LPSTR) od_defspec,
                            (LPSTR) od_openname);
                        if (str[0])
                            strcpy(od_defpath, str);
                        od_ChangeDfExt(od_default_extension, od_defspec);
                        od_UpdateListBox(hDlg);
                        return (TRUE);
                        }

                    if (!od_openname[0])
                        {
                        MessageBox(hDlg, "No filename specified.",
                            NULL, MB_OK | MB_ICONHAND);
                        return (TRUE);
                        }

                    od_AddExtension(od_openname, od_default_extension);
                        // open the file
                    result = WSopenfile(od_openname);
                    strcpy(od_filename, od_openname);
                    EndDialog(hDlg, result);
                    return (TRUE);

                case IDCANCEL:
                    EndDialog(hDlg, FALSE);
                    return (TRUE);
                }
        }
    return FALSE;
    }

   // updates the list box in the Open Dialog
void od_UpdateListBox(HWND hDlg)
    {
    strcpy(str, od_defpath);
    strcat(str, od_defspec);
    DlgDirList(hDlg, str, IDC_LISTBOX, IDC_PATH, 0x4010);

        // list is for subdir of current drive directory
    if (!strchr (od_defpath, ':'))
    	DlgDirList(hDlg, od_defspec, IDC_LISTBOX, IDC_PATH, 0x4010);

        // remove the '..', if one
    if (strstr (od_defpath, ".."))
	    od_defpath[0] = '\0';
    SetDlgItemText(hDlg, IDC_EDIT, od_defspec);
    }

   // changes default extension
void od_ChangeDfExt(PSTR Ext, PSTR Name)
    {
    PSTR pTptr;

    pTptr = Name;
    while (*pTptr && *pTptr != '.')
        pTptr++;
    if (*pTptr)
        if (!strchr(pTptr, '*') && !strchr(pTptr, '?'))
            strcpy(Ext, pTptr);
    }

   // separates file and path names
void od_SeparateFilePath(HWND hDlg, LPSTR lpDestPath,
      LPSTR lpDestFileName, LPSTR lpSrcFileName)
    {
    LPSTR lpTmp;
    char  cTmp;

    lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);
    while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
        lpTmp = AnsiPrev(lpSrcFileName, lpTmp);
    if (*lpTmp != ':' && *lpTmp != '\\') {
        lstrcpy(lpDestFileName, lpSrcFileName);
        lpDestPath[0] = 0;
        return;
    }
    lstrcpy(lpDestFileName, lpTmp + 1);
    cTmp = *(lpTmp + 1);
    lstrcpy(lpDestPath, lpSrcFileName);
     *(lpTmp + 1) = cTmp;
    lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
    }

   // adds default extension
void od_AddExtension(PSTR Name, PSTR Ext)
    {
    PSTR pTptr;

    pTptr = Name;
    while (*pTptr && *pTptr != '.')
        pTptr++;
    if (*pTptr != '.')
        strcat(Name, Ext);
    }



