/*  Test program which shows how to perform internal task spawns
    test program spawns six functions as internal tasks each of which
    increments a global counter.  The main program prints the counters.
    You should see the numbers change when this program is run.  The
    numbers will change at different rates depending on what the stall
    value for the task incrementing the variable is set to.  Be sure to
    use a large enough value for the RM command prior to loading ISPWN
    so the internal tasks have enough memory for their stacks.  If the
    value is too small, the internal spawn will fail with a code of 2.
   
    This example must be compiled using a large model, both code and
    data must have both segments and offsets.  Be sure that the 
    compiler run time frees up memory at the end of the program so
    MultiDos Plus has some memory to allocate for the internal task's
    stacks.  If your compiler automatically checks for program stack
    integrity when a function is entered, be sure to turn the feature
    off when compiling ispwn.c.
    
    Some C compilers may not like the assignment of a function pointer
    to an int pointer, Quick C produces a warning which can be ignored.
*/


/* ISPWN.C */
  
#include <stdio.h>
#include <dos.h>

int c1 = 0;
int c2 = 0;
int c3 = 0;
int c4 = 0;
int c5 = 0;
int c6 = 0;

/******************************/
/*  Suspend task for N ticks  */
/******************************/

void mdstall(ticks)
int ticks;
{
	union REGS in,out;

	in.h.ah = 3; /*  suspend task for interval function code */
	in.x.dx = ticks; /*  number of ticks to suspend for  */
	int86(0x15,&in,&out);
}

/**********************/
/*  internal task #1  */
/**********************/

void f1()
{
	for (;;)
	{
		mdstall(1);
		c1++;
	}
}

/**********************/
/*  internal task #2  */
/**********************/

void f2()
{
	for (;;)
	{
		mdstall(4);
		c2++;
	}
}

/**********************/
/*  internal task #3  */
/**********************/

void f3()
{
	for(;;)
	{
		mdstall(8);
		c3++;
	}
}

/**********************/
/*  internal task #4  */
/**********************/

void f4()
{
	for (;;)
	{
		mdstall(18);
		c4++;
	}
}

/**********************/
/*  internal task #5  */
/**********************/

void f5()
{
	for (;;)
	{
		mdstall(36);
		c5++;
	}
}

/**********************/
/*  internal task #6  */
/**********************/

void f6()
{
	int i;
	
	for (;;) 
	{
		for (i = 0;i < 400; ++i) c6++;
		mdstall(3);
	}
}

/*************************************/
/*  SPAWN A TASK IN SAME BOUND UNIT  */
/*************************************/

int md_spawn_task(task,task_stack_size)
int *task;
unsigned int task_stack_size;
{
	union REGS in,out;
	int *ptr,ptrl,ptrh;

	ptr = task;
	ptrl = *(ptr+0);
	ptrh = *(ptr+1);
	in.h.ah = 07;
	in.x.bx = ptrh;
	in.x.cx = ptrl;
	in.x.dx = task_stack_size;
	int86(0x15,&in,&out); 
	return(int)(out.h.ah);
}

/********************/
/* the main program */
/********************/

void main()
{
	int err, *ptr;
	
	ptr = (int *)f1;
	err = md_spawn_task(&ptr,25);
	printf("spawn err = %d\n",err);

	ptr = (int *)f2;
	err = md_spawn_task(&ptr,25);
	printf("spawn err = %d\n",err);

	ptr = (int *)f3;
	err = md_spawn_task(&ptr,25);
	printf("spawn err = %d\n",err);

	ptr = (int *)f4;
	err = md_spawn_task(&ptr,25);
	printf("spawn err = %d\n",err);

	ptr = (int *)f5;
	err = md_spawn_task(&ptr,25);
	printf("spawn err = %d\n",err);

	ptr = (int *)f6;
	err = md_spawn_task(&ptr,25);
	printf("spawn err = %d\n",err);

	printf("\r\n\n");

	for (;;)
	{
	  printf(
	     "c1 = %7.d c2 = %7.d c3 = %7.d c4 = %7.d c5 = %7.d c6 = %7.d\r",
			c1, c2, c3, c4, c5, c6);
		mdstall(7);
	}
}
