/* mstring.c */

/* The purpose of this file is to provide subroutines for handling
   strings whose space is allocated with malloc - in this way we remove
   all limitations on length of strings */

#include "mstring.h"
#include <ctype.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <process.h>
#include <stdio.h>

#define DLEN 80

int linenumber = 0;

        char
lastchar(p)
        char *p;{
        char c=0;
        while (*p) c = *p++;
        return c;
        }

        char *
endptr(p)
        char *p;{
        while (*p) p++;
        return p;
        }

        mstring
mfgets (stream)
        FILE *stream;{
        mstring p; int plen;
        if (feof(stream)) return NULL;
        p = talloc(plen = DLEN);
        p[0] = '\0';
        while (1) {
                if (strlen(p) + DLEN > plen) {
                        p = realloc(p, plen += DLEN);
                        if (p==NULL) puts("no more memory (mfgets)"), exit(1);
                        }
                if (NULL == fgets(endptr(p),DLEN,stream))
                        if (*p) return p;
                        else {
                                free(p);
                                return NULL;
                                }
                if (lastchar(p) != '\n') continue;
                linenumber++;
                endptr(p)[-1] = 0;
#if 0
                /* this next bit allows \ at end of line to force continuation */
                if (lastchar(p) == '\\') {
                        endptr(p)[-1] = 0;
                        continue;
                        }
#endif
                break;
                }
        p = realloc (p,strlen(p)+1) ;
        if (p==NULL) puts("no more memory (mfgets)"), exit(1);
        return p;
        }

        mstring
msubstr(p,i,l)  /* creates a string from p[i],p[i+1],...,p[i+l-1] */
        mstring p;{
        mstring q;
        q = talloc(l+1);
        strncpy(q,p+i,l);
        q[l] = '\0';
        return q;
        }

        mstring
mstrcat(p,q)
        mstring p,q;{
        mstring r = talloc (strlen(p) + strlen(q) + 1);
        strcpy(r,p);
        strcat(r,q);
        return r;
        }

        mstring
strperm(s)
        char *s;{       /* allocate space for s, return new pointer */
        char *t = talloc(strlen(s)+1);
        if (s==NULL) error ("strperm - NULL pointer");
        strcpy(t,s);
        return t;
        }

passpace(p)
        char **p;{
        if (p==NULL  ||  *p==NULL) error("NULL arg to passpace");
        while (isspace (**p)) (*p)++;
        }

passnonsp(p)
        char **p;{
        if (p==NULL  ||  *p==NULL) error("NULL arg to passnonsp");
        while (**p && !isspace(**p)) (*p)++;
        }

password(p)
        char **p;{
        while (isalnum(**p)) (*p)++;
        }

fputint(i,file)
        int i; FILE *file;{
        char b[20];
        itoa(i,b,10);   /* we're trying to avoid using printf here */
        fputs(b,file);
        };

        void
error (errmsg)
    char *errmsg;{
    /* unfortunately, this assumes only one file is being used */
    if (linenumber) {
         fputs("at line ",stderr);
         fputint(linenumber,stderr);
         fputs(" : ",stderr);
         }
    fputs(errmsg,stderr);
    exit (1);
    }

        mstring
talloc(i)
        int i;{
        char *p;
        char *malloc();
        p = malloc(i);
        if (p==NULL) error ("no more memory");
        return p;
        }

        char *
token(s)
        char *s;{
        char *t;
        static char *old=NULL;
        if (s == NULL  &&  (s = old) == NULL) return NULL;
        passpace(&s);
        if (!*s) return old = NULL;

        if (*s == '"')
             for (t=++s; *t ; t++) {
                  if (t[0] == '"') break;
                  else if (t[0]=='\\' && t[1]=='"') t++;
                  }
        else t = s, passnonsp(&t);

        if (*t) *t = '\0', old = t+1;
        else               old = NULL;
        return s;
        }


numtokens(s)
        char *s;{
        int n=0;
        s = strperm(s);
        if (token(s)) {
                n++;
                while (token(NULL)) n++;
                }
        free(s);
        return n;
        }

        mstring*
tokenize(s)
        char *s; {
        int argc    = numtokens(s);
        char **argv = (char **) talloc ( (argc+1) * sizeof(char *) ) ;
        int i = 1 ;
        s = strperm(s);
                       argv[0]    =         token(s) ;
        while (i<argc) argv[i++]  = strperm(token(NULL));
                       argv[argc] = NULL ;
        free(s);
        return argv;
        }

        void
freev(v)
        char **v;{
        char **w=v;
        while (*w) free(*w++);
        free((char *)v);
        }

        int
mspawn(cmd) char * cmd; {
        char **argv = tokenize(cmd);
        int runsts = spawnvp (P_WAIT, argv[0], argv);
        freev(argv);
        return runsts;
        }

