{ BPVLIB.PAS - Borland Pascal Turbo Vision enhancement library

  title   : BPVLIB
  version : 1.5
  date    : Apr 12,1994
  author  : J R Ferguson
  language: Borland Pascal v7.0 with Objects + Borland Turbo Vision v2.0
  usage   : Unit
}

UNIT BPVLIB;



INTERFACE
  Uses Dialogs, Drivers, Objects, Views;

{$I OBJTYPE.INC}

type
  P_ScrollWindow= ^T_ScrollWindow;
  P_ListWindow  = ^T_ListWindow;

  T_ScrollWindow= Object(TWindow)
  { Automatically handles horizontal and vertical scrolling of text lines.
    This object is much like Borland Turbo Vision's TListViewer, but it
    also is a full featured (mode-less) resizable TWindow.
    This object can not be used as is. You must derive an object that at
    least redefines the GetText method, and optionally ProcessItem and
    others. }
    HScrollBar  : PScrollBar;
    VScrollBar  : PScrollBar;
    TopRow      : integer;    { first visible row }
    CurRow      : integer;    { current row }
    MaxRow      : integer;    { last row }
    LftCol      : integer;    { leftmost visible column }
    Constructor Init(var V_Bounds: TRect; V_Title: TTitleStr;
                     V_Number:integer);
    Constructor Load(var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    procedure   NewTitle(V_Title: TTitleStr); virtual;
    function    GetText     (V_Row: integer): String;  virtual;
                { Dummy routine returning an empty string.
                  Overwrite this function to return a line to be displayed
                  at the given absolute V_Row offset. }
    procedure   ProcessItem (V_Row: integer); virtual;
                { Dummy routine here.
                  Overwrite to define any action to be performed when the
                  current line is selected by pressing ENTER or double
                  clicking it with the mouse. }
    procedure   Draw; virtual;
    procedure   Zoom; virtual;
    procedure   HandleEvent(var V_Event: TEvent); virtual;
    procedure   SetTopRow   (V_Row: integer); virtual;
    procedure   SetCurRow   (V_Row: integer); virtual;
    procedure   SetMaxRow   (V_Row: integer); virtual;
    procedure   SetLftCol   (V_Col: integer); virtual;

  private
    MaxCol      : integer;    { max line width ofcurrent page }
    RowsPerPage : integer;    { number of rows in current window }
    ColsPerPage : integer;    { number of columns in current window }
    procedure   AdjustTopRow;
    procedure   SetScrollParms;
    procedure   DoLButtonDown(V_WhereLocal: TPoint);
    procedure   DoLButtonDbl (V_WhereLocal: TPoint);
    function    YToRow(V_Y: integer; var V_Row: integer): boolean;
  end;


  T_ListWindow = Object(T_ScrollWindow)
  { A derivate of T_ScrollWindow that handles a list display of a
    collection (of strings).
    This object is much like Borland Turbo Vision's TListBox, but it
    also is a full featured (mode-less) resizable TWindow. }
    List        : PCollection; { considered to contain PString entries.}
    Constructor Init(var V_Bounds: TRect; V_Title: TTitleStr;
                     V_Number: integer; V_List: PCollection);
    Destructor  Done; virtual;
                { Disposes of the List before it disposes of itself. }
    Constructor Load(var V_Stream: TStream);
    procedure   Store(var V_Stream: TStream);
    function    GetText(V_Row: integer): String;  virtual;
                { As defined here, GetText assumes that List^.At(V_Row)
                  points to the string to be displayed.
                  Override this method if this is not the case. }
    procedure   NewList(V_List: PCollection); virtual;
                { Disposes of the current list, if any, and sets a new
                  one. }
  end;

{.hlptx skip 14}
const

  R_ScrollWindow : TStreamRec = (
    ObjType : OT_BPVLIB_ScrollWindow;
    VmtLink : Ofs(TypeOf(T_ScrollWindow)^);
    Load    : @T_ScrollWindow.Load;
    Store   : @T_ScrollWindow.Store);

  R_ListWindow   : TStreamRec = (
    ObjType : OT_BPVLIB_ListWindow;
    VmtLink : Ofs(TypeOf(T_ListWindow)^);
    Load    : @T_ListWindow.Load;
    Store   : @T_ListWindow.Store);



procedure RegisterBPVLIB;
{ Register all object types defined in this unit for stream I/O. }

function  BPVStreamMsg(var V_Stream: TStream): String;
{ Formats a message based on V_Stream's Status and ErrorInfo values. }


IMPLEMENTATION


{ --- General --- }

procedure RegisterBPVLIB;
begin
  RegisterType(R_ScrollWindow);
  RegisterType(R_ListWindow);
end;

function BPVStreamMsg(var V_Stream: TStream): String;
var StatStr,StatMsg,InfoStr: String;
begin with V_Stream do begin
  Str(Status,StatStr); Str(ErrorInfo,InfoStr);
  case Status of
    stOk         : StatMsg:= 'No error';
    stError      : StatMsg:= 'Access error';
    stInitError  : StatMsg:= 'Cannot initialize stream';
    stReadError  : StatMsg:= 'Read beyond end of stream';
    stWriteError : StatMsg:= 'Cannot expand stream';
    stGetError   : StatMsg:= 'Get of unregistered object type';
    stPutError   : StatMsg:= 'Put of unregistered object type';
    else           StatMsg:= 'Unknown status code';
  end;
  BPVStreamMsg:= StatStr+'('+InfoStr+') '+StatMsg;
end; end;


{ --- T_ScrollWindow --- }

Constructor T_ScrollWindow.Init(var V_Bounds: TRect; V_Title: TTitleStr;
                                V_Number: integer);
begin
  Inherited Init(V_Bounds,V_Title,V_Number);
  HScrollBar:= StandardScrollBar(sbHorizontal or sbHandleKeyboard);
  VScrollBar:= StandardScrollBar(sbVertical   or sbHandleKeyboard);
  TopRow:= 0; CurRow:= 0; MaxRow:= -1; LftCol:= 0;
  MaxCol:= -1; RowsPerPage:= 0; ColsPerPage:= 0;
  SetScrollParms;
end;

Constructor T_ScrollWindow.Load(var V_Stream: TStream);
begin
  Inherited Load(V_Stream);
  GetSubViewPtr(V_Stream,HScrollBar);
  GetSubViewPtr(V_Stream,VScrollBar);
  V_Stream.Read(TopRow,SizeOf(TopRow));
  V_Stream.Read(CurRow,SizeOf(CurRow));
  V_Stream.Read(MaxRow,SizeOf(MaxRow));
  V_Stream.Read(LftCol,SizeOf(LftCol));
  MaxCol:= -1; RowsPerPage:= 0; ColsPerPage:= 0;
  SetScrollParms;
end;

procedure   T_ScrollWindow.Store(var V_Stream: TStream);
begin
  Inherited Store(V_Stream);
  PutSubViewPtr(V_Stream,HScrollBar);
  PutSubViewPtr(V_Stream,VScrollBar);
  V_Stream.Write(TopRow,SizeOf(TopRow));
  V_Stream.Write(CurRow,SizeOf(CurRow));
  V_Stream.Write(MaxRow,SizeOf(MaxRow));
  V_Stream.Write(LftCol,SizeOf(LftCol));
end;

procedure   T_ScrollWindow.NewTitle(V_Title: TTitleStr);
begin
  if Title <> nil then DisposeStr(Title);
  Title:= NewStr(V_Title); Frame^.Draw;
end;

function    T_ScrollWindow.GetText     (V_Row: integer): String;
begin end;

procedure   T_ScrollWindow.ProcessItem (V_Row: integer);
begin end;

procedure   T_ScrollWindow.Draw;
const ColorNormal=6; ColorSelected=7;
var R: TRect; row,w: integer; Line: String; color: byte; i: byte;
begin
  Inherited Draw;
  MaxCol:= -1;
  if MaxRow >= 0 then begin
    GetExtent(R); RowsPerPage:= R.B.Y-3; ColsPerPage:= R.B.X-3;
    AdjustTopRow;
    for row:= TopRow to TopRow + RowsPerPage do begin
      if (row < 0) or (row > MaxRow) then begin Line:= ''; w:= 0; end
      else begin Line:= GetText(row); w:= Length(Line); end;
      if w > MaxCol then MaxCol:= w;
      Line:= Copy(Line,LftCol+1,ColsPerPage+1);
      for i:= Length(line) to ColsPerPage do line:= line+' ';
      if row=CurRow then color:= ColorSelected else color:= ColorNormal;
      WriteStr(1,1+(row-TopRow),line,color);
    end;
  end;
  SetScrollParms;
end;

procedure   T_ScrollWindow.Zoom;
var OldSize: TPoint;
begin
  OldSize:= Size;
  Inherited Zoom;
  if (Size.X = OldSize.X) and (Size.Y = OldSize.Y) then DrawView;
end;

procedure   T_ScrollWindow.HandleEvent(var V_Event: TEvent);
  const kbGrayEnter=$E00D;
  var WhereLocal: TPoint;
  procedure Clear; begin ClearEvent(V_Event); end;
begin
  Inherited HandleEvent(V_Event);
  with V_Event do case What of
    evKeyDown: case Command of
      kbEnter,
      kbGrayEnter : begin ProcessItem(CurRow); Clear; end;
      kbCtrlHome  : begin SetCurRow(TopRow); Clear; end;
      kbCtrlEnd   : begin SetCurRow(TopRow + RowsPerPage); Clear; end;
    end;
    evMouseDown: if Buttons = mbLeftButton then begin
      MakeLocal(Where,WhereLocal);
      if Double then DoLButtonDbl(WhereLocal) else DoLButtonDown(WhereLocal);
      Clear;
    end;
    evMouseAuto: if Buttons = mbLeftButton then begin
      MakeLocal(Where,WhereLocal);
      DoLButtonDown(WhereLocal); Clear;
    end;
    evBroadCast: if Command = cmScrollBarChanged then begin
      if      InfoPtr = HScrollBar then begin
        SetLftCol(HScrollBar^.Value); Clear;
      end
      else if InfoPtr = VScrollBar then begin
        SetCurRow(VScrollBar^.Value); Clear;
      end;
    end;
  end;
end;

procedure   T_ScrollWindow.SetTopRow   (V_Row: integer);
begin
  if V_Row  >  MaxRow then V_Row := MaxRow;
  if V_Row  <  0      then V_Row := 0;
  if TopRow <> V_Row  then TopRow:= V_Row;
  if CurRow <> V_Row  then CurRow:= V_Row;
  DrawView;
end;

procedure   T_ScrollWindow.SetCurRow   (V_Row: integer);
begin
  if V_Row  >  MaxRow then V_Row:= MaxRow;
  if V_Row  <  0      then V_Row:= 0;
  if CurRow <> V_Row  then begin CurRow:= V_Row; DrawView; end;
end;

procedure   T_ScrollWindow.SetMaxRow   (V_Row: integer);
begin
  if V_Row < -1 then V_Row:= -1;
  if MaxRow <> V_Row then begin
    MaxRow:= V_Row;
    if CurRow > MaxRow then CurRow:= MaxRow;
    DrawView;
  end;
end;

procedure   T_ScrollWindow.SetLftCol   (V_Col: integer);
begin
  if V_Col < 0 then V_Col:= 0
  else if V_Col > MaxCol - ColsPerPage then V_Col:= MaxCol - ColsPerPage;
  if LftCol <> V_Col then begin LftCol:= V_Col; DrawView; end;
end;

{private}

procedure   T_ScrollWindow.AdjustTopRow;
var R: TRect; H: integer;
begin
  if      MaxRow < 1                    then TopRow:= 0
  else if TopRow > CurRow               then TopRow:= CurRow
  else if TopRow < CurRow - RowsPerPage then TopRow:= CurRow - RowsPerPage;
  if TopRow < 0 then TopRow:= 0;
end;

procedure   T_ScrollWindow.SetScrollParms;
begin
  {HScrollBar:}
  if (MaxRow < 0) or ((MaxCol-ColsPerPage) < 2) then begin
    LftCol:= 0;
    if HScrollBar^.GetState(sfVisible) then HScrollBar^.Hide;
  end
  else begin
    HScrollBar^.SetParams(LftCol,0,MaxCol-(ColsPerPage+1),ColsPerPage,1);
    if not HScrollBar^.GetState(sfVisible) then HScrollBar^.Show;
  end;
  {VScrollBar:}
  if MaxRow < 1 then begin
    if VScrollBar^.GetState(sfVisible) then VScrollBar^.Hide;
  end
  else begin
    VScrollBar^.SetParams(CurRow,0,MaxRow,RowsPerPage,1);
    if not VScrollBar^.GetState(sfVisible) then VScrollBar^.Show;
  end;
end;

procedure   T_ScrollWindow.DoLButtonDown(V_WhereLocal: TPoint);
var Row: integer;
begin if YToRow(V_WhereLocal.Y,Row) then SetCurRow(Row); end;

procedure   T_ScrollWindow.DoLButtonDbl (V_WhereLocal: TPoint);
var Row: integer;
begin if YToRow(V_WhereLocal.Y,Row) then begin
  SetCurRow(Row);
  ProcessItem(Row);
end; end;

function    T_ScrollWindow.YToRow(V_Y: integer; var V_Row: integer): boolean;
begin
  if MaxRow < 0 then YToRow:= false
  else begin
    Dec(V_Y);
    if V_Y<0 then V_Y:= 0 else if V_Y>RowsPerPage then V_Y:= RowsPerPage;
    if (TopRow+V_Y)>MaxRow then V_Row:= MaxRow else V_Row:= TopRow+V_Y;
    YToRow:= true;
  end;
end;


{ --- T_ListWindow --- }

Constructor T_ListWindow.Init(var V_Bounds: TRect; V_Title: TTitleStr;
                               V_Number: integer; V_List: PCollection);
begin
  Inherited Init(V_Bounds,V_Title,V_Number);
  List:= nil; NewList(V_List);
end;

Destructor  T_ListWindow.Done;
begin
  NewList(nil);
  Inherited Done;
end;

Constructor T_ListWindow.Load(var V_Stream: TStream);
var InpList: PCollection;
begin
  Inherited Load(V_Stream);
  InpList:= PCollection(V_Stream.Get); List:= nil; NewList(InpList);
end;

procedure   T_ListWindow.Store(var V_Stream: TStream);
begin
  Inherited Store(V_Stream);
  V_Stream.Put(List);
end;

function    T_ListWindow.GetText(V_Row: integer): String;
begin
  if (V_Row < 0) or (V_Row >= List^.Count) then GetText:= ''
  else GetText:= PString(List^.At(V_Row))^
end;

procedure   T_ListWindow.NewList(V_List: PCollection);
begin
  if List <> nil then Dispose(List,Done);
  List:= V_List;
  if List=nil then SetMaxRow(-1) else SetMaxRow(List^.Count-1);
  TopRow:= 0; CurRow:= 0; LftCol:= 0; MaxCol:= -1;
  SetScrollParms;
end;


END.
