{ CONLIB.PAS : CRT console constant and routine library

  Title   : CONLIB
  Version : 4.1
  Language: Borland Turbo Pascal v4.0+ (all targets)
  Date    : Jan 29, 1997
  Author  : J.R. Ferguson
  Usage   : Unit
}

UNIT ConLib;

INTERFACE
uses
 DefLib, {$IFDEF WINDOWS} WinCrt {$ELSE} Dos {$ENDIF};

const
 KeyCtrAt    =$00;
 KeyCtrA     =$01;
 KeyCtrB     =$02;
 KeyCtrC     =$03;
 KeyCtrD     =$04;
 KeyCtrE     =$05;
 KeyCtrF     =$06;
 KeyCtrG     =$07;
 KeyBS       =$08;
 KeyCtrH     =$08;
 KeyTab      =$09;
 KeyCtrI     =$09;
 KeyCtrJ     =$0A;
 KeyCtrK     =$0B;
 KeyCtrL     =$0C;
 KeyCR       =$0D;
 KeyCtrM     =$0D;
 KeyCtrN     =$0E;
 KeyCtrO     =$0F;
 KeyCtrP     =$10;
 KeyCtrQ     =$11;
 KeyCtrR     =$12;
 KeyCtrS     =$13;
 KeyCtrT     =$14;
 KeyCtrU     =$15;
 KeyCtrV     =$16;
 KeyCtrW     =$17;
 KeyCtrX     =$18;
 KeyCtrY     =$19;
 KeyCtrZ     =$1A;
 KeyEsc      =$1B;
 KeyCtrLBrack=$1B;
 KeyCtrBSlash=$1C;
 KeyCtrRBrack=$1D;
 KeyCtrCaret =$1E;
 KeyCtrUScore=$1F;
 KeyCtrBS    =$7F;
 KeyIns      =$80;
 KeyEnd      =$81;
 KeyDown     =$82;
 KeyPgDn     =$83;
 KeyLeft     =$84;
 KeyCenter   =$85;
 KeyRight    =$86;
 KeyHome     =$87;
 KeyUp       =$88;
 KeyPgUp     =$89;
 KeyBackTab  =$8A;
 KeyCtrPrtScr=$8B;
 KeyCtrLeft  =$8C;
 KeyCtrCenter=$8D;
 KeyCtrRight =$8E;
 KeyCtrEnd   =$8F;
 KeyCtrIns   =$90;
 KeyCtrF01   =$91;
 KeyCtrF02   =$92;
 KeyCtrF03   =$93;
 KeyCtrF04   =$94;
 KeyCtrF05   =$95;
 KeyCtrF06   =$96;
 KeyCtrF07   =$97;
 KeyCtrF08   =$98;
 KeyCtrF09   =$99;
 KeyCtrF10   =$9A;
 KeyCtrF11   =$9B;
 KeyCtrF12   =$9C;
 KeyCtrPgUp  =$9D;
 KeyCtrDown  =$9E;
 KeyCtrUp    =$9F;
 KeyCtrDel   =$A0;
 KeyShfF01   =$A1;
 KeyShfF02   =$A2;
 KeyShfF03   =$A3;
 KeyShfF04   =$A4;
 KeyShfF05   =$A5;
 KeyShfF06   =$A6;
 KeyShfF07   =$A7;
 KeyShfF08   =$A8;
 KeyShfF09   =$A9;
 KeyShfF10   =$AA;
 KeyShfF11   =$AB;
 KeyShfF12   =$AC;
 KeyAltMinus =$AD;
 KeyCtrPgDn  =$AE;
 KeyCtrHome  =$AF;
 KeyAlt0     =$B0;
 KeyAlt1     =$B1;
 KeyAlt2     =$B2;
 KeyAlt3     =$B3;
 KeyAlt4     =$B4;
 KeyAlt5     =$B5;
 KeyAlt6     =$B6;
 KeyAlt7     =$B7;
 KeyAlt8     =$B8;
 KeyAlt9     =$B9;
 KeyAltEqual =$BD;
 KeyAltCenter=$BE;
 KeyAltRight =$BF;
 KeyAltA     =$C1;
 KeyAltB     =$C2;
 KeyAltC     =$C3;
 KeyAltD     =$C4;
 KeyAltE     =$C5;
 KeyAltF     =$C6;
 KeyAltG     =$C7;
 KeyAltH     =$C8;
 KeyAltI     =$C9;
 KeyAltJ     =$CA;
 KeyAltK     =$CB;
 KeyAltL     =$CC;
 KeyAltM     =$CD;
 KeyAltN     =$CE;
 KeyAltO     =$CF;
 KeyAltP     =$D0;
 KeyAltQ     =$D1;
 KeyAltR     =$D2;
 KeyAltS     =$D3;
 KeyAltT     =$D4;
 KeyAltU     =$D5;
 KeyAltV     =$D6;
 KeyAltW     =$D7;
 KeyAltX     =$D8;
 KeyAltY     =$D9;
 KeyAltZ     =$DA;
 KeyAltIns   =$DB;
 KeyAltEnd   =$DC;
 KeyAltDown  =$DD;
 KeyAltPgDn  =$DE;
 KeyAltLeft  =$DF;
 KeyBreak    =$E0;
 KeyAltF01   =$E1;
 KeyAltF02   =$E2;
 KeyAltF03   =$E3;
 KeyAltF04   =$E4;
 KeyAltF05   =$E5;
 KeyAltF06   =$E6;
 KeyAltF07   =$E7;
 KeyAltF08   =$E8;
 KeyAltF09   =$E9;
 KeyAltF10   =$EA;
 KeyAltF11   =$EB;
 KeyAltF12   =$EC;
 KeyAltHome  =$ED;
 KeyAltUp    =$EE;
 KeyAltPgUp  =$EF;
 KeyAltDel   =$F0;
 KeyF01      =$F1;
 KeyF02      =$F2;
 KeyF03      =$F3;
 KeyF04      =$F4;
 KeyF05      =$F5;
 KeyF06      =$F6;
 KeyF07      =$F7;
 KeyF08      =$F8;
 KeyF09      =$F9;
 KeyF10      =$FA;
 KeyF11      =$FB;
 KeyF12      =$FC;
 KeyDel      =$FF;

function TstEnhKbd: boolean;
{ Test if the BIOS of the current system supports the enhanced keyboard
  with, amongst others, function keys F11 and F12. 
  In a Windows environment, this function always returns false, since
  extended keys are not supported by this library for MS-Windows programs. 
} 

procedure SetCur(row: RowInd; col: ColInd);
{ Place the cursor at the given row and column. The upper-left corner of
  the screen has row=1 and col=1. }

function Key: char;
{ Wait until a key is pressed on the keyboard and return the corresponding
  character value without echoing it on the screen.
  In DOS programs, using a PC-compatible keyboard, extended keys like
  function keys that produce a 0-character plus some non-zero keycode are
  translated into a single character with a unique ordinal value.
  In MS-Window programs extended keys are not supported.

  See also: <UppKey>
}

function UppKey: char;
{ Like Key, wit upper case translation.

  See also: <Key>
}

function YesNo(prompt: ColStp): boolean;
{ Displays the given prompt, followed buy the text '? (Y/N) : ', waits
  until one of the keys 'Y', 'y', 'N' or 'n' is pressed, and echoes 'Y'
  or 'N' followed by a carriage return and a line feed. The function
  result is true if 'Y' or 'y' was pressed, and false otherwise.

  See also: <JaNee>
}

function JaNee(prompt: ColStp): boolean;
{ Dutch or German version of YesNo. Prompts with '? (J/N) : ' and
  waits for 'J', 'j', 'N' or 'n'.

  See also: <YesNo>
}

procedure WaitCR;
{ Displays the text ' CR:' and waits until the Return key is pressed.
  A carriage return and a line feed character is then echoed. }

procedure Message(msg: ColStp);
{ Displays the msg string, preceded and followed by a carriage return
  and a line feed character. }


IMPLEMENTATION

{
--- local definitions ---
}

const HasEnhKbd: boolean = false;

const KeyTable : array[byte] of byte = (
  $FE,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$8A,
  $D1,$D7,$C5,$D2,$D4,$D9,$D5,$C9,$CF,$D0,$00,$00,$00,$00,$C1,$D3,
  $C4,$C6,$C7,$C8,$CA,$CB,$CC,$00,$00,$00,$00,$00,$DA,$D8,$C3,$D6,
  $C2,$CE,$CD,$00,$00,$00,$00,$00,$00,$00,$00,$F1,$F2,$F3,$F4,$F5,
  $F6,$F7,$F8,$F9,$FA,$00,$00,$87,$88,$89,$00,$84,$85,$86,$00,$81,
  $82,$83,$80,$FF,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$91,$92,
  $93,$94,$95,$96,$97,$98,$99,$9A,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,
  $E9,$EA,$8B,$8C,$8E,$8F,$AE,$AF,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,
  $B9,$B0,$AD,$BD,$9D,$FB,$FC,$AB,$AC,$9B,$9C,$EB,$EC,$9F,$00,$8D,
  $00,$9E,$90,$A0,$00,$00,$00,$ED,$EE,$EF,$00,$DF,$BE,$BF,$00,$DC,
  $DD,$DE,$DB,$F0,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00);


{
--- public definitions ---
}

function TstEnhKbd: boolean;
{$IFDEF WINDOWS}
begin TstEnhKbd:= false; end;
{$ELSE}
var CPU: Dos.Registers;
begin with CPU do begin
  AH:= $05; CX:= $FFFF; Intr($16,CPU);  { Stuff FFFFh into keyboard buffer }
  AH:= $11; Intr($16,CPU);              { Get extended keyboard status }
  if AX <> $FFFF then TstEnhKbd:= false { Check if FFFFh was returned }
  else begin
    AH:= $10; Intr($16,CPU);            { If so, remove key from buffer }
    TstEnhKbd:= true;
  end;
end end;
{$ENDIF}

procedure SetCur(row: RowInd; col: ColInd);
{$IFDEF WINDOWS}
begin GotoXY(col,row) end;
{$ELSE}
var CPU: Dos.Registers;
begin with CPU do begin
  AH:= 2; BH:= 0; DH:= pred(row); DL:= pred(col); Intr($10,CPU);
end end;
{$ENDIF}

function Key: char;
{$IFDEF WINDOWS}
begin Key:= ReadKey; end;
{$ELSE}
var CPU: Dos.Registers;
begin with CPU do begin
  if HasEnhKbd then AH:= $10 else AH:= $00;
  Intr($16,CPU);
  if AL<>0 then Key:= chr(AL) else Key:= chr(KeyTable[AH]);
end end;
{$ENDIF}

function UppKey: char;
begin UppKey:= UpCase(Key) end;

function YesNo(prompt: ColStp): boolean;
var antw: char;
begin
  write(prompt,'? (Y/N) : ');
  repeat antw:=UppKey until antw in ['Y','N']; writeln(antw);
  YesNo:=antw='Y'
end;

function JaNee(prompt: ColStp): boolean;
var antw: char;
begin
  write(prompt+'? (J/N) : ');
  repeat antw:=UppKey until antw in ['J','N']; writeln(antw);
  JaNee:=antw='J'
end;

procedure WaitCR;
begin write(' CR:'); repeat until Key=chr(KeyCR); writeln end;

procedure Message(msg: ColStp);
begin writeln; writeln(msg) end;

BEGIN
{$IFNDEF WINDOWS}
  HasEnhKbd:= TstEnhKbd;
{$ENDIF}
END.
