{----------------------------------------------------------------------.
|   OpenDOS    |  Unit dedicated to DR-DOS (ex OpenDOS, ex Novell DOS, |
|--------------'   ex DRDOS)  multitasking functions & DPMS detection  |
| Author: Gautier.deMontmollin@Maths.UniNe.CH           v. 14.VII.1998 |
`----------------------------------------------------------------------}

{$B-}
unit OpenDOS;

{$DEFINE Use_Exec_Unit}
       { ^---- Use exec (exec23.zip or exec33b from Thomas Wagner,
         simtel archives) to obtain maximum conventional memory when
         shelling / spawning }

interface

{====------------------ Basic functions of task manager -----------------====}

{======| Installation, status, informations |======}

function  Task_manager_installed: boolean;
procedure Get_status(var tasks, maximum_tasks, foreground_task_index: word);
procedure Get_version(var major_version, minor_version: byte);
function  Get_foreground_task_index: word; 
function  Check_open_files(task_index:word):word; 
procedure Get_swap_space_info(var available_KB, total_KB: word); 
function  Get_per_task_EMS_limit: word; 
procedure Set_per_task_EMS_limit(limit: word; var new_limit: word);

{======| Switching and shelling tasks |======}

procedure Switch_to(task_index:word); 
procedure Switch_to_task_manager; 
function  Release_time_slice: boolean; { true: done; false: impossible }
procedure Task_shelling(comline: String; new_task: boolean);

{======| Names, IDs |======}

type task_name = string[8];
const invalid_task_ID=$ffff;

function  Get_task_name(index: word): task_name;
procedure Name_task(task_index: word; name: task_name; { ''=clear renaming }
                    var flag:byte; var ID:word);
function  Index_to_ID(index:word):word; 
function  ID_to_index(id:word):word; 

{======| DPMS |======}

type DPMS_server_structure = record
  ID: array[1..4] of char; {'DPMS'}
  major_version: byte;
  minor_version: byte;
  OEM_name: array[1..8] of char;
  OEM_major_version: byte;
  OEM_minor_version: byte;
  flags: word;
  CPU: byte;
end;

type P_DPMS_server_structure = ^DPMS_server_structure;

const
  DPMS_SERVER_FAST_RESET = 1;
  DPMS_SERVER_ENABLED    = 2;
  DPMS_SERVER_MAPPED     = 4;

function DPMS_installed: boolean;
function DPMS_information: P_DPMS_server_structure;

{----------------------------------------------------------------------------}

implementation

uses DOS {$IFDEF Use_Exec_Unit}, Exec {$ENDIF};

const pseudo_max_tasks=5000;

type id_table     = array[0..pseudo_max_tasks] of word;
     p_id_table   = ^id_table;
     task_name_a  = array[0..7] of char;
     name_table   = array[0..pseudo_max_tasks] of task_name_a;
     p_name_table = ^name_table;

function Task_manager_installed: boolean; assembler;
  asm mov ax,$2700; int $2F; 
      cmp al,$ff; mov al,0; jnz @@F01non; inc ax; @@F01non: end;

procedure Get_status(var tasks, maximum_tasks, foreground_task_index: word);
assembler;
  asm mov ax,$2701; int $2F;
      LES DI,tasks; MOV ES:[DI],cx;
      LES DI,maximum_tasks; MOV ES:[DI],ax;
      LES DI,foreground_task_index; MOV ES:[DI],bx;
  end;

procedure Get_version(var major_version, minor_version: byte); assembler;
  asm mov ax,$2701; int $2F;
      LES DI,major_version; MOV ES:[DI],dl;
      LES DI,minor_version; MOV ES:[DI],dh;
  end;

function Get_name_table_pointer: p_name_table; assembler; {interne}
  asm mov ax,$2701; int $2F;
      MOV DX,ES; xchg AX,DI; {result= ptr(DX,AX)}
  end;

function Get_foreground_task_index: word; assembler;
  asm mov ax,$2701; int $2F; xchg ax,bx end;

function Get_per_task_EMS_limit: word; assembler;
  asm mov ax,$2702; int $2F; xchg ax,dx end;
  
procedure Set_per_task_EMS_limit(limit: word; var new_limit: word); assembler;
  asm mov ax,$2703; mov dx,limit; int $2F;
      LES DI,new_limit; MOV ES:[DI],dx end;

procedure Switch_to(task_index:word); assembler;
  asm mov ax,$2706; mov dx,task_index; int $2F end;

procedure Switch_to_task_manager; assembler;
  asm mov ax,$2715; int $2F end;  

function Release_time_slice: boolean; assembler;
  asm mov ax,$1680; int $2F;
      and ax,ax; mov al,0; jnz @@pas_de_pret; inc ax; @@pas_de_pret: end;

function Get_task_name(index: word): task_name;
  var r:task_name; n:task_name_a;
  begin
    n:= Get_name_table_pointer^[index];
    r:='';
    while (length(r)<=7) and (n[length(r)]<>#0) do r:= r+ n[length(r)];
    Get_task_name:= r
  end;

procedure Name_task_a(task_index, n_seg,n_ofs: word;
                      var flag:byte; var id:word); assembler;
  asm push ds
      mov ax,$2709;
      mov dx,task_index;
      mov bx,n_seg; mov cx,n_ofs; mov ds,bx; mov si,cx; int $2F;
      LES DI,flag; MOV ES:[DI],al;
      LES DI,id; MOV ES:[DI],bx;
      pop ds
  end;

procedure Name_task(task_index: word; name: task_name;
                    var flag:byte; var id:word);
  var name_a: task_name_a; i,l:byte;
  begin
    for i:= 0 to 7 do name_a[i]:= #0;
    l:= length(name); if l>8 then l:= 8;
    for i:= 1 to l do name_a[i-1]:= name[i];
    Name_task_a(task_index, seg(name_a), ofs(name_a), flag, id)
  end;

function Index_to_id(index:word):word; assembler;
  asm mov ax,$270A; mov dx,index; int $2F; xchg ax,dx end;

function Id_to_index(id:word):word; assembler;
  asm mov ax,$270B; mov dx,id; int $2F; xchg ax,dx end;

function Check_open_files(task_index:word):word; assembler;
  asm mov ax,$270C; mov dx,task_index; int $2F end;   

procedure Get_swap_space_info(var available_KB, total_KB: word); assembler;
  asm mov ax,$2714; int $2F;
      LES DI,available_KB; MOV ES:[DI],dx;
      LES DI,total_KB; MOV ES:[DI],cx end;
      
procedure Task_shelling(comline: String; new_task: boolean);
  var COMSPEC: string;

  procedure Command(tm:boolean; cp: string);

    procedure Execute(Path, CmdLine: string); 
    {$IFDEF Use_Exec_Unit}
      const Exec_Method= 1 { Use_all + Hide_file for exec v 3.3b };
    {$ENDIF}
      begin
        {$IFDEF Use_Exec_Unit}
          DosError:= Do_exec(Path, CmdLine, Exec_Method, $ffff, false)
        {$ELSE}
          Exec(Path, CmdLine)
        {$ENDIF}
      end;

    begin
      SwapVectors;
      if tm then Execute(GetEnv('OPENDOSCFG')+'\taskmgr.exe', cp)
            else Execute(COMSPEC, cp);
      SwapVectors
    end;

  BEGIN
    COMSPEC:= GetEnv('COMSPEC');
    if new_task and Task_manager_installed then begin
      if comline='' then Command(true, '/C'+COMSPEC)
                    else Command(true, '/C'+comline)
    end else begin
      if comline='' then Command(false, '')
                    else Command(false, '/C'+comline)
    end
  END;

function DPMS_installed: boolean; assembler;
  asm mov ax,$43E0; xor bx,bx; mov cx,$4450; mov dx,$4D53; int $2F;
      and ax,ax; mov al,0; jnz @@DPMS01non; inc ax; @@DPMS01non: end;

function DPMS_information: P_DPMS_server_structure; assembler;
  asm mov ax,$43E0; xor bx,bx; mov cx,$4450; mov dx,$4D53; int $2F;
      and ax,ax; mov ax,0; mov dx,ax; jnz @@DPMS02non;
      mov dx,es; xchg ax,di
      @@DPMS02non: end;

end.
