{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+}
{$M 16384,0,655360}

{
TILE.PAS
Demonstrates 	- tile loading
		- scrolling background usage
		- virtual world panning
}

uses	crt,uve32;

var	dsin,dcos	:array[0..255] of longint;


procedure init;
var
	i,j:integer;
begin
	ia_inituve;
	ia_setscrolling;
	usebackground:=false;
	ia_loadtil('tiles.uvl',1);
	ia_loadpalette('tiles.pal',pcxpal);
	ia_setscrollarea(-160,-160,40,32);
	ia_setcycletime(40);
	for i:=-10 to 29 do
	for j:=-10 to 21 do ia_puttile(i*16,j*16,(2*(abs(j) mod 2))+1+abs(i) mod 2);
	for i:=0 to 255 do begin
		dsin[i]:=round(-256*sin(pi/2-(2*pi*i/256)));
		dcos[i]:=round( 256*cos(pi/2-(2*pi*i/256)));
	end;
	ia_powerup;
	ia_setpalette(pcxpal);
end;

procedure deinit;
begin
	ia_shutdown;
	halt;
end;

procedure animate;
var	i:integer;
begin
	ia_doframe;
end;

var	i,j:integer;
begin
	init;
	repeat
		vpx:=dcos[frame mod 256];
		vpy:=dsin[frame mod 256];
		animate;
	until keypressed;

	deinit;
end.