;		ip.inc
;========================================================================

; Copyright (C) 1991-95 by Jan.Engvald@ldc.lu.se, see file COPYING.

						; send errors:
SERRNOERR	equ	0			; no error
SERRNETUNR	equ	1			; net unreachable
SERRHOSTUNR	equ	2			; host unr
SERRPROTUNR	equ	3			; protocol unr
SERRPORTUNR	equ	4			; port unr
SERRFRAG	equ	5			; fragm needed but prohibited
SERRSRCROUTE	equ	6			; source route err

SERRNOBUF	equ	8			; temporary out of buffers
SERRNOARP	equ	9			; got no ARP reply
SERRTIMOUT	equ	10			; general timeout
SERRNOTRAF	equ	11			; received no traffic from dst
SERRNOIP	equ	12			; no IP # to send to

ICMP_PROT	equ	1			; Internet Control Msg Prot
UDP_PROT	equ	17			; IP protocol type UDP

IpStruc 	struc
iIpVerHlen	db	45h			; ver 4, 5 32-bit hdr words
iIpTos		db	0			; type of service
iIpLen		dw	0			; IP packet length
iIpId		dw	0100h			; id 0001
iIpFlFrag	dw	0			; no flags or fragments
iIpTtl		db	90			; time to live
iIpProt 	db	0			; 17 = udp
iIpXsum 	dw	0			; header checksum
iIpSrc		dw	0, 0			; Don't know my IP nmbr
iIpDst		dw	0ffffh, 0ffffh		; local net broadcast IP
iIpOptions	equ	$-iIpVerHlen
IpStruc 	ends
IPHDRLEN	equ	SIZE IpStruc

UdpStruc	struc
uUdpSrc 	dw	4400h			; source port 44h = 68
uUdpDst 	dw	4300h			; dest port 43h = 67
uUdpLen 	dw	0			; length in bytes
uUdpXsum	dw	0			; udp checksum
uUdpData	equ	$-uUdpSrc
UdpStruc	ends
UDPHDRLEN	equ	SIZE UdpStruc

BootpStruc	struc
uUdpStruc	UdpStruc	<>
uBotOp		db	1			; bootp request
uBotHtype	db	0			; hardware type
uBotHlen	db	0			; hardware addr lenght
uBotHops	db	0			; hops
uBotXid 	dw	0, 0			; transaction id
uBotSecs	dw	0001			; 0100h seconds since boot
uBotUnused	dw	0			; not defined
uBotCliIp	dw	0, 0			; Client IP unknown
uBotYourIp	dw	0, 0			; my IP yet unknown
uBotServIp	dw	0, 0			; Server IP
uBotGwyIp	dw	0, 0			; Gateway IP
uBotCliHwAd	db	16 dup (0)		; My Hardware address
uBotSname	db	64 dup (0)		; server name
uBotFilNam	db	128 dup (0)		; file name
uBotMagNum	dw	8263h, 6353h		; Magic number
uBotVend	db	64-4 dup (0)		; Vendor specific area
BootpStruc	ends
BPDATALEN	equ	SIZE BootpStruc - UDPHDRLEN

IcmpStruc	struc
uIcmpTypecode	dw	0
uIcmpXsum	dw	0
uIcmpData	dw	0, 0
uIcmpIpHdr	equ	$-uIcmpTypecode
uIcmpUdpHdr	equ	$-uIcmpTypecode+IPHDRLEN
IcmpStruc	ends
ICMPHDRLEN	equ	SIZE IcmpStruc

		even
IpHandle	dw	0
MyMask		dw	2 dup (0h)
MyNet		dw	2 dup (0h)
MyIpNr		dw	0, 0
IpIdCounter	dw	0
BootpXid	dw	0
AdrBootpReply	dd	0			; save address of bootp reply

if RFCC
AgeNext 	dw	0			; time to check slots
AgeFragsNext	dw	0
endif ; RFCC


ifndef		MAXDEFGWYS
MAXDEFGWYS	equ	4
endif

DefGwyIndex	dw	0
DefGwyNum	dw	0
DefGwys 	dw	MAXDEFGWYS*2 dup (0)

if TBLBUILD or PINGCLIENT
DefNSnum	dw	0
DefNS		dw	MAXDEFNS*2 dup (0)
endif ; TBLBUILD or PINGCLIENT

ifndef		ROUTESLOTS
ROUTESLOTS	equ	8
endif

; The route table contains information on hosts behind gateways.
;
; If we don't receive anything from an IP number within one minute after we
; last sent to it, we return SERRNOTRAF on the next send. This is cleared
; after another minute.

RouteTabIpD2	dw	ROUTESLOTS dup (0)	; destination IP #
RouteTabIpD1	dw	ROUTESLOTS dup (0)
RouteTabTos	dw	ROUTESLOTS dup (0)	; type of service
RouteTabIpG2	dw	ROUTESLOTS dup (0)	; gateway IP #
RouteTabIpG1	dw	ROUTESLOTS dup (0)
RouteTabTrTx	dw	ROUTESLOTS dup (0)	; transmit timer
RouteTabTrRx	dw	ROUTESLOTS dup (0)	; receive timer
RouteTabFlags	dw	ROUTESLOTS dup (0)	; flags (must follow TrRx)
RouteTabTrSq	dw	ROUTESLOTS dup (0)	; source quench timer
RouteTabSqDelay dw	ROUTESLOTS dup (0)	; source quench delay
RouteTabUnreach dw	ROUTESLOTS dup (0)	; destination unreachable

RoutePutSlot	dw	0

;========================================================================
;		endinclude
