/* EMS Library for Microsoft Quick C with Assembler   */
/* John A. Ball         October 9, 1995               */

#include <EMS.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <memory.h>


static unsigned EMM_in_memory,
		EMM_version,
		EMM_top_page;
static int      EMM_handle=-1;

/* find Expanded Memory Manager using device open method.  */
/* If not found return 0 else version number in BCD format */

int EMM_find_manager()
{
int     file_handle;
int     result;

	if(EMM_version) return EMM_version;     /* skip if already known */
	if((file_handle=open("EMMXXXX0", O_RDONLY))==0)
	   return 0;
	_asm{
	    mov bx,file_handle  ;handle of file or device
	    mov ax,4400h        ;Get Device Data
	    int 21h
	    jc error
	    mov ax,dx           ;get device status bit 7
	    and ax,0x80
	    je error
	    mov bx,file_handle  ;handle of file or device
	    mov ax,4407h        ;Check device output status
	    int 21h
	    jc error
	    cmp al,0ffh         ;0ffh means device ready
	    jne error
	    mov ax,1
	    jmp end
	error:
	    mov ax,0
	end:
	    mov result,ax
	    }
	if(result){
	   EMM_in_memory=1;
	   result=EMM_version=EMM_get_version();
	   }
	close(file_handle);
	return result;
}

/* GET EMM version */

int EMM_get_version()
{
	if(!EMM_in_memory) return 0;
    _asm{
	mov ah,0x46
	int 67h
	}
}

/* Get EMM Status */

int EMM_get_status()
{
	if(!EMM_in_memory) return 0x80;
    _asm{
	mov ah,0x40
	int 67h
	}
}

/* Get EMM page frame */

void _far *EMM_get_page_frame()
{
	if(!EMM_in_memory) return (void far *)0;
    _asm{
	mov ah,0x41
	int 67h
	or ah,ah
	jnz frame_error
	mov dx,bx
	jmp frame_end
    frame_error:
	mov ax,0
	mov dx,ax
    frame_end:
	}
}

/* Get total number of EM pages */

int EMM_get_pages()
{
	if(!EMM_in_memory) return 0x80;
    _asm{
	mov ah,0x42
	int 67h
	or ah,ah
	jnz get_error
	mov ax,dx
    get_error:
	}
}

/* Get number of EM pages free */

int EMM_get_pages_free()
{
	if(!EMM_in_memory) return 0x80;
    _asm{
	mov ah,0x42
	int 67h
	or ah,ah
	jnz getp_error
	mov ax,bx
    getp_error:
	}
}


/* Allocate EMM pages */

int EMM_alloc_pages(int pages)
{
	if(!EMM_in_memory) return 0x80;
    _asm{
	mov ah,0x43
	mov bx,pages
	int 67h
	or ah,ah
	jnz alloc_error
	mov EMM_handle,dx
	mov ax,0
    alloc_error:
	}
}

/* Map memory */

int EMM_map_page(int phys_page, int logical_page)
{
	if(!EMM_in_memory) return 0x80;
    _asm{
	mov ah,0x44
	mov al,phys_page
	mov bx,logical_page
	mov dx,EMM_handle
	int 67h
	or ah,ah
	jnz map_error
	mov ax,0
    map_error:
	}
}

/* Release handle and memory */

int EMM_release_pages(void)
{
	if(!EMM_in_memory) return 0x80;
    _asm{
	mov ah,0x45
	mov dx,EMM_handle
	int 67h
	or ah,ah
	jnz release_error
	mov ax,0
	mov EMM_handle,ax
    release_error:
	}
}
