/* --------------------------------- log.c ---------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* log file stuff.
*/

#include <stdio.h>
#include <stdarg.h>

#include "fly.h"

static FILE *flog = 0;

extern int FAR
log_init (void)
{
	if (!st.lname) {
#ifndef NOSTDERR
		fprintf (stderr, "missing log file name\n");
#endif
		return (1);
	}
	if (!(flog = fopen (st.lname, ATMODE))) {
#ifndef NOSTDERR
		fprintf (stderr, "open failed for log file '%s'\n", st.lname);
#endif
		return (1);
	}
	return (0);
}

extern void FAR
log_term (void)
{
	if (flog) {
		fclose (flog);
		flog = 0;
	}
	return;
}

extern int FAR
LogPrintf (const char *fmt, ...)
{
	va_list		ap;
	int		i;

	if (!flog)
		return (-1);

	va_start (ap, fmt);
	i = vfprintf (flog, fmt, ap);
	va_end (ap);

	return (i);
}
