/* --------------------------------- otower.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object control tower.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"

static SHAPE shape_tower = {
	0,
	0,
	0,
	100000*1000L,	/* weight */
	0		/* drag */
};

static int FAR
init_tower (BODY *b)
{
	if (shape_read (&shape_tower, "tower.vxx"))
		return (1);
	return (0);
}

static void FAR
term_tower (BODY *b)
{
	shape_free (shape_tower.v);
}

static int FAR
create_tower (OBJECT *p)
{
	p->color = st.brown;
	p->time = FOREVER;
	p->flags |= F_VISIBLE;
	Mident (p->T);
	return (0);
}

BODY BoTower = {
	0,
	0,
	"TOWER",
	&shape_tower,
	init_tower,
	term_tower,
	create_tower,
	body_delete,
	body_dynamics,
	body_hit
};
