/* --------------------------------- vmodes.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Read in the video modes table.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fly.h"

static int FAR
get_mode (char *line, DEVICE *dev)
{
	char	*p;
	long	l;
	int	errs;

	errs = 0;

	if ((p = get_parg (line, 0)))
		dev->name = p;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 1)))
		dev->mode = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 2)))
		dev->colors = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 3)))
		dev->minx = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 4)))
		dev->miny = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 5)))
		dev->sizex = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 6)))
		dev->sizey = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 7)))
		dev->npages = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 8)))
		dev->lengx = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 9)))
		dev->lengy = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 10)))
		dev->FontWidth = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 11)))
		dev->FontHeight = (int)l;
	else
		++errs;
	if (-1L != (l = get_inarg (line, 12)))
		dev->sync = (int)l;
	else
		dev->sync = 0;

	return (errs);
}

extern int FAR
vm_read (void)
{
	FILE	*vm;
	DEVICE	*dev, *tail;
	char	mline[256];
	int	errs, i;

	vm = fopen (st.vmdname, RTMODE);
	if (!vm) {
		LogPrintf ("vmd: could not open file %s\n", st.vmdname);
		return (1);
	}

	tail = 0;
	dev = 0;
	Gr->devices = 0;
	errs = 0;

	for (i = 1; fgets (mline, sizeof (mline), vm); ++i) {
		if (mline[0] == '\n' || mline[0] == '#')
			continue;
		if (!NEW (dev)) {
			LogPrintf ("vmd: out of memory\n");
			++errs;
			continue;
		}
		mline[strlen(mline)-1] = '\0';
		if (get_mode (mline, dev)) {
			LogPrintf ("vmd: bad line %d\n", i);
			++errs;
			DEL0 (dev);
			continue;
		}
		dev->next = 0;
		if (tail)
			tail->next = dev;
		else
			Gr->devices = dev;
		tail = dev;
		dev->pdevice = 0;
	}
	fclose (vm);

	return (errs);
}

extern void FAR
vm_free (void)
{
	DEVICE	*dev, *next;

	if (!Gr)
		return;

	for (dev = Gr->devices; dev; dev = next) {
		next = dev->next;
		dev->name = xfree (dev->name);
		DEL (dev);
	}
}
