(*  .....................................................................  *)
(*  :	file    	:  MYNESTTL.PAS                                 :  *)
(*  :  	contents	:  the title and hall-of-fame for MYNES!	:  *)
(*  :	last update	:  07-JUL-93                                    :  *)
(*  :...................:...............................................:  *)
(*
        - WaitALittle
        - intro, show_title
	- draw_HallOfFame
        - game_end
*)

PROCEDURE   WaitALittle;
(* wait 8 secs or until any button is pressed *)
(* NOTE:  changes Game_Status to 'QUIT' if <ESC> is pressed  *)
VAR     dummyINT	: INTEGER;
	dummySCENE	: SCENE_TYPE;
	dummyWORD	: WORD;
BEGIN
	PLAYTIMER.init(8);
        (* use spare time to AdjustDelay once more ... *)
        AdjustDelay(CHECK_TIME);

	dummyINT := get_mouse_button(dummySCENE, dummyWORD, dummyWORD, dummyWORD);
END;	(*  Wait8sForKey  *)


PROCEDURE	Intro;
BEGIN
	SetFillStyle(SOLIDFILL, GREY);
  	Bar(0, 0, GetMaxX, GetMaxY);

  	SetDrawColSize(WHITE, DKGREY, 3);
  	DrawTextAt(MIDDLE_X, 55, 'The Silicon Veterans', CENTERED_TEXT);
  	DrawTextAt(MIDDLE_X, 111, '@ Proudly Present @', CENTERED_TEXT);
  	DrawTextAt(24, 183,'@', LEFT_ALIGNED_TEXT);
  	DrawTextAt(590,357,'@', LEFT_ALIGNED_TEXT);

  	SetDrawColSize(WHITE, DKGREY, 10);
  	DrawStringAt(14,127, '.12o61r:12u:61l', FALSE);
  	DrawStringAt(24,368, '.L21oO59r:R21uU59l', FALSE);
  	DrawStringAt(14,470, '.9o61r:9u:61l', FALSE);

  	SetDrawColSize(WHITE, DKGREY, 2);
  	DrawTextAt(190, 188, 'Marc Palms''', LEFT_ALIGNED_TEXT);

  	SetDrawColSize(WHITE, DKGREY, 9);
	DrawTextAt(MIDDLE_X, 312, 'Mynes!', CENTERED_TEXT);

  	SetDrawColSize(WHITE, DKGREY, 2);
        DrawTextAt(MIDDLE_X, 412, 'Mynes! Is Shareware.', CENTERED_TEXT);
  	SetDrawColSize(WHITE, DKGREY, 1);
        DrawTextAt(MIDDLE_X, 433, 'If You Like It, Please Think About A Registration.', CENTERED_TEXT);
        DrawTextAt(MIDDLE_X, 449, 'To Become A Registered Myner Send 5 US-Dollars To:', CENTERED_TEXT);
        DrawTextAt(MIDDLE_X, 465, 'Marc Palms, Am Forst 12, D-54597 Rommersheim, GERMANY.', CENTERED_TEXT);

	dim_palette(100, FAST_DIM);
        GameStatus := TITLE;	(* mustn't be QUIT *)
        WaitALittle;
END;	(*  Intro  *)


(*  show_HallOfFame *)
PROCEDURE	show_HallOfFame;
VAR	entry 		: BYTE;
	y		: WORD;
	Date,
        HiScore_str 	: STRING;
	myFrame	 	: FRAME_TYPE;
BEGIN
        dim_palette(0, SLOW_DIM);
        HideMouse;
        ClearDevice;
	myFrame.init(1, 1, 638, 106,
		     NORMWIDTH, CLR_MARKED + 2, CLR_MARKED, WHITE,
		     GAD_PUSHED, FALSE);
	myFrame.show;

	SetDrawColSize(WHITE, CLR_MARKED, 2);
        DrawTextAt(320, 36, 'The', CENTERED_TEXT);

	SetDrawColSize(WHITE, CLR_MARKED, 4);
        DrawTextAt(320, 96, 'Hall Of Fame', CENTERED_TEXT);

	myFrame.init(1, 117, 638, 16,
		     NORMWIDTH, GREY, DKGREY, WHITE,
		     GAD_PUSHED, FALSE);
	myFrame.show;

        ShadowTextXY(14, 121, WHITE, BLACK,
	             'LEVEL            MYNER                    SCORE              DATE');

        dim_palette(100, FAST_DIM);
        y := 127;
        FOR  entry := 1  TO  HOF_SIZE  DO
        BEGIN
		MyDelay(400);
                IF  (GetMouseButton <> NO_MOUSEBUTTON)  OR
                    (ESC_pressed)  THEN
		    	EXIT;	(* exit during build up-phase *)
		INC(y, 43);
		WITH  HallOfFame[entry]  DO
		BEGIN
			myFrame.init(1, y - 29, 638, 36,
				     NORMWIDTH, CLR_VISIBLE1 + entry,
				     WHITE, GREY,
		     		     GAD_PUSHED, FALSE);
			myFrame.show;

			SetDrawColSize(WHITE, BLACK, 2);
			DrawTextAt(33, y, CHR(ORD('0') + entry), CENTERED_TEXT);

			DrawTextAt(180, y, Name, CENTERED_TEXT);

                	STR(HiScore, HiScore_str);
			DrawTextAt(405, y, HiScore_str, RIGHT_ALIGNED_TEXT);

                        (*  make a string in FORMAT  1ddyy  *)
                        STR((100 + Day) * 100 + (Year MOD 100), Date);
                        (*  now get digits 2,3 then '-'month'-' then 4,5  *)
			DrawTextAt(520, y,
			           Date[2] + Date[3] + '-' + MONTHS[Month] + '-' + Date[4] + Date[5],
				   CENTERED_TEXT);
                END;  (* WITH *)
        END;  (* FOR *)

        WaitALittle;
END;	(*  show_HallOfFame  *)


(*  2 routines that make the radio-buttons work ...
    they take the old level/speed and return the new one *)
PROCEDURE	handle_level_gadgets(VAR  level : WORD);
VAR	gad : BYTE;
BEGIN
	FOR  gad := FIRSTLEVEL  TO  LASTLEVEL  DO
        BEGIN
        	IF  (gad <> level) AND (LEVEL_GAD[gad].handle_mouse_click)  THEN
                BEGIN
                        LEVEL_GAD[level].refresh(GAD_FLIP_STATE);
                	level := gad;
                END;  (* IF *)
        END;  (* FOR gad *)
END;	(*  handle_level_gadgets  *)

PROCEDURE	handle_speed_gadgets(VAR  speed : WORD);
VAR	gad : BYTE;
BEGIN
	FOR  gad := 1  TO  5  DO
        BEGIN
        	IF  (gad <> speed) AND (SPEED_GAD[gad].handle_mouse_click)  THEN
                BEGIN
                        SPEED_GAD[speed].refresh(GAD_FLIP_STATE);
                	speed := gad;
                END;  (* IF *)
        END;  (* FOR gad *)
END;	(*  handle_speed_gadgets  *)


PROCEDURE	show_title(VAR  newlevel, newspeed : WORD);
(* note, that the mouse must be hidden on entry *)
PROCEDURE	draw_titlescreen;
VAR	myFrame : FRAME_TYPE;
	g	: BYTE;
        y	: WORD;
BEGIN
	dim_palette(0, SLOW_DIM);

        (* now, generate title-tile size and graphics *)
        generate_tile(SCENE_ARRAY[SUCC(FIRSTLEVEL)], play_tile);

	(* and clear screen afterwards *)
        ClearDevice;

        IF  (Random(3) = 0)  THEN	(* every 3rd is blue *)
        	g := CLR_MARKED
        ELSE				(* the others are yellow/red *)
		g := CLR_VISIBLE1 + Random(5);

        FOR  y := 0  TO  (GetMaxY DIV 8)  DO
        BEGIN
	        SetFillStyle(SOLIDFILL, g);
                Bar(0, y * 8, GetMaxX, y * 8 + 2 + Random(4));

                IF  ((y AND 2) = 0)  THEN
                	INC(g)
                ELSE
                	DEC(g);
	END;  (* FOR y *)

	myFrame.init(10, 8, 618, 162,
		     NORMWIDTH, GREY, DKGREY, WHITE,
		     GAD_NOT_PUSHED, FALSE);
	myFrame.show;

  	SetDrawColSize(WHITE, DKGREY, 2);
  	DrawTextAt(190, 43, 'Marc Palms''', LEFT_ALIGNED_TEXT);
  	SetDrawColSize(WHITE, DKGREY, 9);
	DrawTextAt(MIDDLE_X, 156, 'Mynes!', CENTERED_TEXT);

        (* this frame is for the LEVEL and SPEED gadgets *)
	myFrame.init(10, LEVEL_GAD_Y - 10, 618, 98,
		     NORMWIDTH, GREY, DKGREY, WHITE,
		     GAD_NOT_PUSHED, FALSE);
	myFrame.show;

  	SetDrawColSize(WHITE, DKGREY, 2);

        DrawTextAt(20, LEVEL_GAD_Y + 30, 'Level', LEFT_ALIGNED_TEXT);
	FOR  g := FIRSTLEVEL  TO  LASTLEVEL  DO
        BEGIN
        	LEVEL_GAD[g].show;
                draw_contents(play_tile, 90 + g * 60, LEVEL_GAD_Y,
			      CONTENTS_TYPE(ORD(VISIBLE0) + g), BY_CONTENTS);
        END;

        DrawTextAt(20, SPEED_GAD_Y + 21, 'Speed', LEFT_ALIGNED_TEXT);
	FOR  g := 1  TO  5  DO
        	SPEED_GAD[g].show;

        TITLE_QUIT_GADGET.show;
        TITLE_DEMO_GADGET.show;
        TITLE_START_GADGET.show;
        TITLE_MUSIC_GADGET.show;
        TITLE_LOOK_GADGET.show;
        TITLE_HOF_GADGET.show;

        (* this frame is for instructions *)
	myFrame.init(10, INSTRUCTIONS_Y, 618, 146,
		     NORMWIDTH, GREY, DKGREY, WHITE,
		     GAD_NOT_PUSHED, FALSE);
	myFrame.show;

        g := Random(7);
        DrawTextAt(MIDDLE_X, INSTRUCTIONS_Y + 34 * 1, 'Clear The Cyclic Mynefields!', CENTERED_TEXT);
        DrawTextAt(MIDDLE_X, INSTRUCTIONS_Y + 34 * 2, 'Left Button ... Reveal Tiles "  "', CENTERED_TEXT);
        DrawTextAt(MIDDLE_X, INSTRUCTIONS_Y + 34 * 3, 'Right Button ... Mark Mynes "  "', CENTERED_TEXT);
        DrawTextAt(MIDDLE_X, INSTRUCTIONS_Y + 34 * 4, 'The "  " Says: "' + CHR(ORD('2') + g) +
				  ' Mynes Around"', CENTERED_TEXT);
        draw_contents(play_tile, 569, INSTRUCTIONS_Y + 36,
		      CONTENTS_TYPE(ORD(VISIBLE2) + g), BY_CONTENTS);
        draw_contents(play_tile, 576, INSTRUCTIONS_Y + 73,
		      MARKED0, BY_CONTENTS);
        draw_contents(play_tile, 110, INSTRUCTIONS_Y + 105,
		      CONTENTS_TYPE(ORD(VISIBLE2) + g), BY_CONTENTS);

	dim_palette(100, FAST_DIM);
        ShowMouse;

	(* wait TITLE_WAIT secs or until mouse is touched *)
	PLAYTIMER.init(TITLE_WAIT);

        (* no matter what - if we see the title, we're in TITLE-mode  *)
        GameStatus := TITLE;

END;	(*  draw_titlescreen  *)


CONST   mouse_x   : WORD = 320;
	mouse_y	  : WORD = 240;

VAR	HOFs_before_Demo : BYTE;  (* how often HallOfFame before DEMO is started *)
	x, y	 	 : WORD;
        dummy		 : BYTE;

BEGIN	(*  show_title  *)

        SetMousePos(mouse_x, mouse_y);

	IF  HOFexists  THEN
	   HOFs_before_Demo := 2
        ELSE
           HOFs_before_Demo := 1;

        draw_titlescreen;	(* sets PLAYTIMER *)

        REPEAT
        	(* if player used mouse then reset timer *)
                IF  (MouseTouched)  THEN
                	PLAYTIMER.init(TITLE_WAIT);

                IF  (PLAYTIMER.read > 0)  THEN  (* check gagdets *)
                BEGIN
                	IF  (TITLE_QUIT_GADGET.handle_mouse_click  OR
			     ESC_pressed)  THEN
                        	GameStatus := QUIT
                        ELSE IF  (TITLE_DEMO_GADGET.handle_mouse_click)  THEN
                        	GameStatus := DEMO_START
                        ELSE IF  (TITLE_START_GADGET.handle_mouse_click)  THEN
                        	GameStatus := PLAY
                        ELSE IF  (TITLE_MUSIC_GADGET.handle_mouse_click)  THEN
                        	SoundIsON := NOT(SoundIsON)
                        ELSE IF  (TITLE_LOOK_GADGET.handle_mouse_click)  THEN
                        	LookIsPL  := NOT(LookIsPL)
                        ELSE IF  (TITLE_HOF_GADGET.handle_mouse_click)  THEN
                        BEGIN
	        	        show_HallOfFame;
        	                draw_titlescreen;
                        END  (* IF TITLE_HOF_GADGET *)

                        ELSE
                        BEGIN
                        	handle_speed_gadgets(newspeed);
                                handle_level_gadgets(newlevel);
	                END;  (* ELSE *)
                END
	        ELSE  (* it is a timeout *)
                (* show Hall Of Fame or start the DEMO *)
		IF  (HOFs_before_Demo = 0)  THEN
                BEGIN
			(* try to draw the mouse to the demo-gadget *)
                        TITLE_DEMO_GADGET.get_pos(x, y);

         	        IF  (DragMouse(x + 40, y + 10, SOFT_DRAG))  THEN
			BEGIN
                        	(* flip gadget *)
				computerclick(FALSE);
		                TITLE_DEMO_GADGET.refresh(GAD_FLIP_STATE);
                                MyDelay(100);
                                TITLE_DEMO_GADGET.refresh(GAD_FLIP_STATE);
                	        GameStatus := DEMO_START
                        END  (* IF *)
                        ELSE
                	        HOFs_before_Demo := 1
                END  (* IF HOFs_before_Demo *)
                ELSE
                BEGIN
                        DEC(HOFs_before_Demo);
        	        show_HallOfFame;
                        draw_titlescreen;
                END;
        UNTIL	(GameStatus <> TITLE);

        dummy := GetMousePos(mouse_x, mouse_y);
END;	(*  show_title  *)


PROCEDURE	game_end(level : BYTE);

CONST   CharSetLen 	= 39;
        BACKSPACEchar 	= 1;
	myCharSet : STRING[CharSetLen] = '#ABCDEFGH .IJKLMNOPQRSTUVWXYZ0123456789';
        newName		: STRING[HOF_NAME_LEN] = '';
        (* this is a constant to be able to initialize the name with the
	   name least recently used *)
VAR	CharGad : ARRAY [1..CharSetLen] OF GADGET_TYPE;
	myFrame 	: FRAME_TYPE;
        Score_str,
        txt1, txt2,
	WHOstr,				(* who played ? *)
	WHOSEstr	: STRING;	(* whose score is it ? *)

        FrameBottom,			(* frame's y-coordinates *)
        FrameHeight,
        FrameTop,
        mx, my, mbut,
	WORDdummy	: WORD;		(* mouse *)
	c            	: BYTE;
	IsNewHiScore,
        ok_pressed,
	BOOLdummy	: BOOLEAN;
        OK_GAD		: GADGET_TYPE;

PROCEDURE	draw_name;
BEGIN
	SetFillStyle(SOLIDFILL, GREY);
        Bar(60, FrameTop + 340, 570, FrameTop + 400);
	DrawTextAt(MIDDLE_X, FrameTop + 395, newName, CENTERED_TEXT);

        (*  draw a 'cursor' *)
        SetColor(CLR_VISIBLE_MINE);
        SetLineStyle(SOLIDLN, 0, THICKWIDTH);
        MoveRel(8, 5);  LineRel(0, -60);
        SetLineStyle(SOLIDLN, 0, NORMWIDTH);
END;	(*  draw_name  *)

PROCEDURE	get_name;
VAR	c, initial : BYTE;
BEGIN
        FOR  c := 1  TO  CharSetLen  DO
        BEGIN
                IF  (CharGad[c].handle_mouse_click)  THEN
                BEGIN
                        HideMouse;

                        IF  (c = BACKSPACEchar)  THEN
                        BEGIN
                        	IF  (LENGTH(newName) > 0)  THEN
                                BEGIN
                        		newName := COPY(newName, 1, PRED(LENGTH(newName)));
                                	draw_name;
                                END;  (* IF *)
                        END  (* IF c *)
                        ELSE
                        	IF  (LENGTH(newName) < HOF_NAME_LEN)  THEN
                                BEGIN
                        		newName := newName + myCharSet[c];
		                	draw_name;
                                END; (* IF *)
                        ShowMouse;
                END;  (* IF *)
        END;  (* FOR *)
END;	(*  get_name  *)

BEGIN
	MyDelay(1500);
        dim_palette(0, SLOW_DIM);

	IF  (ManPlayed)  THEN	(* else: do nothing at all *)
        BEGIN

		SetFillStyle(SolidFill, BLACK);	Bar(0, 0, GetMaxX, GetMaxY);

        	IsNewHiScore := FALSE;

                IF  (ComputerPlayed)  THEN
                BEGIN
                	WHOstr := 'We ';  WHOSEstr := 'Our ';
                END
                ELSE
                BEGIN
                	WHOstr := 'You '; WHOSEstr := 'Your ';
                	IsNewHiScore := (Score > HallOfFame[Level].HiScore);
		END;

                IF  (IsNewHiScore)  THEN
		BEGIN
		   FrameHeight := 476;
                   HOFexists := TRUE;	(* new HIGHSCORE ! -> HOF exists *)
        	END
                ELSE
		   FrameHeight := 285;

                FrameTop    := (GetMaxY - FrameHeight) DIV 2;
                FrameBottom := FrameTop + FrameHeight;

	 	myFrame.init(8, FrameTop, 624, FrameHeight,
		     	     NORMWIDTH, GREY, DKGREY, WHITE,
			     GAD_NOT_PUSHED, TRUE);
		myFrame.show;

                SetDrawColSize(WHITE, DKGREY, 3);

                txt1 := 'Well ... looks like';
        	CASE  (GameStatus)  OF
                   WON :     BEGIN
                   		txt1 := 'Congratulations,';
                   		txt2 := 'Made It !';
                   	     END;
                   BLASTED : BEGIN
		   		txt2 := 'Were Blown Up !';
                   	     END;
                   TIMEOUT : BEGIN
				txt2 := 'Ran Out Of Time.';
                   	     END;
                END;  (* CASE *)

                DrawTextAt(MIDDLE_X, FrameTop + 60, txt1, CENTERED_TEXT);
                DrawTextAt(MIDDLE_X, FrameTop + 120, WHOstr + txt2, CENTERED_TEXT);

                STR(Score, Score_str);
		DrawTextAt(MIDDLE_X, FrameTop + 200,
			   WHOSEstr + 'Score Is ' + Score_str + '.', CENTERED_TEXT);

                IF  (IsNewHiScore)  THEN
		BEGIN
	                SetDrawColSize(WHITE, DKGREY, 2);
                	DrawTextAt(MIDDLE_X, FrameTop + 260, 'Welcome, To The', CENTERED_TEXT);
	                SetDrawColSize(WHITE, DKGREY, 4);
                        DrawTextAt(MIDDLE_X, FrameTop + 324, 'Hall Of Fame !', CENTERED_TEXT);

                        (* the delete gadget is different from the others *)
                	init_gadget(CharGad[BACKSPACEchar],20, FrameBottom - 56, 46, 20,'DEL', 0, GAD_NO_KEEP);
			CharGad[BACKSPACEchar].show;

		        FOR  c := 2  TO  CharSetLen  DO
                        BEGIN
                        	(* set gadgets around ok field *)
                		init_gadget(CharGad[c],
					    20 + (c MOD 10) * 26 + (c DIV 20) * 344,
					    FrameBottom - 56 + ((c DIV 10) AND 1) * 26,
					    20, 20,
					    myCharSet[c], 0, GAD_NO_KEEP);
				CharGad[c].show;
                        END;  (* FOR c *)

			draw_name;
                END;  (* IF IsNewHiScore *)

		init_gadget(OK_GAD, (GetMaxX - 60) DIV 2, FrameBottom - 40, 60, 16, 'OKTHANKS!', 2, GAD_NO_KEEP);
		OK_GAD.show;

                ShowMouse;
	        dim_palette(100, FAST_DIM);

        	PLAYTIMER.init(15);	 (*  15 secs to press OK  *)
                OK_GAD.get_pos(mx, my);
                SetMousePos(mx + 30, my + 8);
                REPEAT
                        ok_pressed := OK_GAD.handle_mouse_click  OR
				      ESC_pressed;

                        IF  (MouseTouched)  THEN
                        	PLAYTIMER.init(15);

                        IF  (IsNewHiScore)  AND  NOT(ok_pressed)  THEN
				get_name;

                UNTIL  (ok_pressed)  OR  (PLAYTIMER.read <= 0);

                IF  NOT(ok_pressed)  THEN	 (* computer presses ok *)
                BEGIN
			OK_GAD.get_pos(mx, my);
			BOOLdummy := DragMouse(mx + 30, my + 8, HARD_DRAG);
			computerclick(FALSE);
		        OK_GAD.refresh(GAD_FLIP_STATE);
                        MyDelay(100);
                        OK_GAD.refresh(GAD_FLIP_STATE);
                END;  (* IF timeleft *)

                IF  (IsNewHiScore)  THEN
                BEGIN
			WITH  HallOfFame[Level]  DO
			(* HiScore, Day, Month, Year, Name *)
                        BEGIN
                		HiScore := Score;
                        	Name    := newName;
                        	GetDate(Year, Month, Day, WORDdummy);
	                END;  (* WITH *)
                        (* now, show the new Hall Of Fame *)
                        show_HallOfFame;
			(* mouse is hidden now *)
                END  (* IF *)
                ELSE
                	HideMouse;	(* hide mouse for show_title *)

	END;  (*  IF ManPlayed  *)
END;	(*  game_end  *)

