/*
    CGAEX: CGA video exerciser
    Copyright (C) 2003  John Elliott

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Colours (using the default VGA palette) */
#define VGA_BLACK     0
#define VGA_DBLUE     1
#define VGA_DGREEN    2
#define VGA_DCYAN     3
#define VGA_DRED      4
#define VGA_DMAGENTA  5
#define VGA_ORANGE    6
#define VGA_LGREY     7
#define VGA_DGREY     8
#define VGA_LBLUE     9
#define VGA_LGREEN   10
#define VGA_LCYAN    11
#define VGA_LRED     12
#define VGA_LMAGENTA 13
#define VGA_LYELLOW  14
#define VGA_WHITE    15
/* 16-31 are greyscales, 0-100% inclusive */
#define VGA_GREY0    16
#define VGA_GREY7    17
#define VGA_GREY13   18
#define VGA_GREY20   19
#define VGA_GREY27   20
#define VGA_GREY33   21
#define VGA_GREY40   22
#define VGA_GREY47   23
#define VGA_GREY53   24
#define VGA_GREY60   25
#define VGA_GREY67   26
#define VGA_GREY73   27
#define VGA_GREY80   28
#define VGA_GREY87   29
#define VGA_GREY93   30   
#define VGA_GREY100  31
/* 32-63 are intermediate colours; in particular, "pure" colours: */
#define VGA_ZBLUE    32
#define VGA_ZMAGENTA 36
#define VGA_ZRED     40
#define VGA_ZYELLOW  44
#define VGA_ZGREEN   48
#define VGA_ZCYAN    52

/* CGA colours */
#define CGA_WHITE   0xFF
#define CGA_MAGENTA 0xAA
#define CGA_CYAN    0x55
#define CGA_BLACK   0x00

typedef unsigned char gfx_byte;
typedef unsigned short gfx_word;

extern gfx_byte gfx_font[];
extern gfx_word gfx_x, gfx_y;
extern gfx_byte gfx_force_cga, gfx_force_mda;

typedef struct gfx_menuline
{
	char *vml_text;
	char vml_shortcut;
} GFX_MENULINE;

typedef struct gfx_menu
{
	gfx_word vm_count;
	gfx_word vm_active;
	char *vm_title;
	GFX_MENULINE *vm_entries;
	
} GFX_MENU;



void gfx_setmode(gfx_byte mode);
gfx_byte gfx_getmode(void);
gfx_byte gfx_gmode(void);	/* Switch to graphics mode */
void gfx_cls(void);
void gfx_putchar(gfx_word y, gfx_word x, char c);
void gfx_putstr(char *s);
char gfx_getch(void);
void gfx_stripe(gfx_word y, gfx_word x);
void gfx_hbar(gfx_word  y, gfx_word x, gfx_word w, char *s);
void gfx_bbar(char *s);
gfx_word gfx_menu_width(GFX_MENU *menu);
void gfx_menu_redrawline(GFX_MENU *menu, gfx_word opt);
void gfx_draw_menuline(gfx_word y, gfx_word x, gfx_word w, GFX_MENULINE *mline);
gfx_byte *gfx_backmenu(GFX_MENU *menu);
void gfx_restrmenu(GFX_MENU *menu, gfx_byte *backmem);
void gfx_drawmenu(GFX_MENU *menu);
gfx_word gfx_domenu(GFX_MENU *menu);
void gfx_setforeground(gfx_byte clr);
void gfx_setbackground(gfx_byte clr);
gfx_word gfx_getcursor();
void gfx_setcursor(gfx_word cursor);
