/*===================================*/
/*                                   */
/* Music Quest Programmer's ToolKit  */
/*                                   */
/* Tape sync features                */
/*                                   */
/* Copyright (c) 1988                */
/* By Music Quest, Inc.              */
/*                                   */
/*===================================*/
#include "dos.h"
#include "bios.h"
#include "\ptk\asm\mcc.h"

/*===================================*/
/*                                   */
/* Chase Lock - SPP display          */
/*                                   */
/*===================================*/
show_spp()
{
  int running;
  int spp_val;
  int rtcmd;

  puts("MCC/MQX-32 Programmer's ToolKit - Song Position Pointer\n");
  puts("Please start the tape or ESC to return");

  running=0;
  set_slih(coproc_slih);
  mcc_reset();                          /* return to coproc mode */
  mcc_command(DISABLE_ALL_THRU);        /* disable thru */
  mcc_command(DISABLE_THRU);
  mcc_command(ENABLE_SYSCOM_PC);        /* enable SPP msgs */
  mcc_command(ENABLE_RT_PC);            /* enable real time msgs */
  mcc_command(ACTIVE_TRACKS);           /* no tracks active */
  mcc_put(0);
  mcc_command(ENABLE_MIDI_CTRL);        /* enable external MIDI control */
  mcc_command(CLS_MODE);                /* enable CLS sync mode */
  mcc_command(MIDI_SYNCH);

  while (!_bios_keybrd(_KEYBRD_READY))  /* wait for exit key */
    {
      if (spp_efw(&spp_val))            /* if SPP received */
        {
          running=1;
          printf("SPP=%d (%04X) Measure(4/4)=%d Beat(4/4)=%d\n",
                  spp_val,spp_val,(spp_val/16)+1,((spp_val%16)/4)+1);
        }
      if ((rtcmd=realtime_efw()) != 0)
        {
          switch (rtcmd)
            {
              case 0xFA:                /* start */
                puts("MIDI Start");
                break;
              case 0xFB:                /* continue */
                puts("MIDI Continue");
                break;
              case 0xFC:                /* stop */
                puts("MIDI Stop\n");
                break;
              default:
                break;
            }
        }
    }

  mcc_reset();                          /* return to coproc mode */
  _bios_keybrd(_KEYBRD_READ);           /* clear exit key */
}

/*===================================*/
/*                                   */
/* SMPTE frame trace                 */
/*                                   */
/*===================================*/
show_smpte()
{
  int running;
  unsigned char smpte_addr[4];

  puts("MCC/MQX-32 Programmer's ToolKit - SMPTE Frame Trace\n");
  puts("Please start the tape or ESC to return\n\n");

  running=0;
  set_slih(coproc_slih);
  mcc_command(ENABLE_SMPTE_MSG);
  mcc_command(DISABLE_ALL_THRU);
  mcc_command(DISABLE_THRU);

  mcc_command(SMPTE_MODE);
  mcc_command(START_SMPTE_READ);

  while (!_bios_keybrd(_KEYBRD_READY))  /* wait for exit key */
    {
      if (smpte_efw(smpte_addr))        /* if a SMPTE frame address received */
        {
          running=1;
          printf("%02d:%02d:%02d:%02d\r",smpte_addr[0] & 0x1F,
                                        smpte_addr[1],
                                        smpte_addr[2],
                                        smpte_addr[3]);
        }
      if (strk_end_efw())               /* check for end of track */
        {
          puts("\n\nEnd of SMPTE Track");
        }
    }

  mcc_reset();                          /* return to coproc mode */
  _bios_keybrd(_KEYBRD_READ);           /* clear exit key */
}

/*===================================*/
/*                                   */
/* SMPTE cue point                   */
/*                                   */
/*===================================*/
cue_point()
{
  char hh, mm, ss, fr;
  int running;
  unsigned char smpte_addr[4];


  puts("MCC/MQX-32 Programmer's ToolKit - SMPTE Cue Point Example\n");
  puts("Enter cue point (hh mm ss fr): ");
  scanf("%d %d %d %d",&hh,&mm,&ss,&fr);
  printf("Cue point = %02d:%02d:%02d:%02d\n\n",hh,mm,ss,fr);

  hh=hh | 0x60;

  set_slih(coproc_slih);
  mcc_command(DISABLE_ALL_THRU);
  mcc_command(DISABLE_THRU);
  mcc_command(ENABLE_SMPTE_MSG);        /* enable SMPTE frame messages */
  mcc_command(SMPTE_CONTROL);           /* set up the cue point */
  mcc_put(SMPTE_CUE_POINT);
  mcc_put(hh);
  mcc_put(mm);
  mcc_put(ss);
  mcc_put(fr);

  mcc_command(SMPTE_MODE);
  mcc_command(START_SMPTE_READ);

  puts("Please start the tape or ESC to return\n");
  running=0;

  while (!_bios_keybrd(_KEYBRD_READY))  /* wait for exit key */
    {
      if (smpte_efw(smpte_addr))        /* if a SMPTE frame address received */
        {
          running=1;
          printf("%02d:%02d:%02d:%02d\r",smpte_addr[0] & 0x1F,
                                        smpte_addr[1],
                                        smpte_addr[2],
                                        smpte_addr[3]);
        }

      if (cuepoint_efw())
        {
          cputs("\n\nCUE POINT HIT!!\n");
        }
      if (strk_end_efw())               /* check for end of track */
        {
          puts("\n\nEnd of SMPTE Track");
        }
    }

  mcc_reset();                          /* return to coproc mode */
  _bios_keybrd(_KEYBRD_READ);           /* clear exit key */
}

/*===================================*/
/*                                   */
/* Write SMPTE track                 */
/*                                   */
/*===================================*/
write_smpte()
{
  int hh, mm;
  unsigned char smpte_addr[4];
  int ohh, omm, oss, ofr;
  int dur;
  int running;

  puts("\n\nMCC/MQX-32 Programmer's ToolKit - Write SMPTE Track");
  puts("\nEnter SMPTE origin (hh mm ss fr): ");
  scanf("%d %d %d %d",&ohh,&omm,&oss,&ofr);
  puts("\nHow many minutes of tape (1-60): ");
  scanf("%d%*c",&dur);

  ohh=ohh | 0x60;                       /* force 30 frame non-drop */
  mm=(omm+dur) % 60;                    /* calc cue point for end */
  hh=ohh+((omm+dur)/60);

  mcc_reset();                          /* put MQX-32 into known state */
  set_slih(coproc_slih);

  mcc_command(SMPTE_CONTROL);           /* set up the origin frame address */
  mcc_put(SMPTE_ORIGIN);
  mcc_put(ohh);
  mcc_put(omm);
  mcc_put(oss);
  mcc_put(ofr);
  mcc_command(SMPTE_CONTROL);           /* set up the cue point */
  mcc_put(SMPTE_CUE_POINT);
  mcc_put(hh);
  mcc_put(mm);
  mcc_put(oss);
  mcc_put(ofr);

  puts("\n\nStart the tape in record mode");
  puts("Press any key when tape is running\n");
  _bios_keybrd(_KEYBRD_READ);

  mcc_command(SMPTE_MODE);              /* put the MQX-32 into SMPTE mode */
  mcc_command(ENABLE_SMPTE_MSG);        /* enable SMPTE frame messages */
  mcc_command(START_RECSMPTE);          /* start writing */

  printf("Writing %d minutes of SMPTE track; press any key to stop\n\n\n",dur);

  /* spin until end of time or asked to quit */
  do
    {
      if (smpte_efw(smpte_addr))        /* if a SMPTE frame address received */
        {
          printf("%02d:%02d:%02d:%02d\r",smpte_addr[0] & 0x1F,
                                        smpte_addr[1],
                                        smpte_addr[2],
                                        smpte_addr[3]);
        }
    }
  while (!_bios_keybrd(_KEYBRD_READY) && (!cuepoint_efw())); /* wait for exit key */

  mcc_command(STOP_RECSMPTE);           /* stop writing */

  if (_bios_keybrd(_KEYBRD_READY))      /* if terminated from kbd */
    _bios_keybrd(_KEYBRD_READ);
  else
    {
      puts("\r\n\nSync track written; press any key to continue\r\n");
     _bios_keybrd(_KEYBRD_READ);
    }
  mcc_reset();                          /* return to default mode */
}
