{$F+}    {FAR calls}
{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

{*===================================*}
{*                                   *}
{* Music Quest Programmer's ToolKit  *}
{* Example utility program           *}
{*                                   *}
{*===================================*}
{*                                   *}
{* Copyright 1988, 1990              *}
{* Music Quest, Inc.                 *}
{*                                   *}
{*===================================*}

Program Tkxmpl;


Uses
  Crt, mcctksp, mcc, inttrace, mqxsync;

{$I mccconst.inc}

{*===================================*}
{*                                   *}
{* Convert to hex                    *}
{*                                   *}
{*===================================*}

type
  hex2 = string[2];

function tohex(b: integer): hex2;

const
  hextab:       array [0..15] of char = '0123456789ABCDEF';

begin
  tohex[1]:=hextab[(b and $F0) shr 4];
  tohex[2]:=hextab[b and $F];
  tohex[0]:=chr(2);
end;

{*===================================*}
{*                                   *}
{* Hex trace                         *}
{*                                   *}
{*===================================*}
procedure hex_trace;

var
  b:            integer;                {* received data byte *}
  flushchar:    char;
  hexdata:      hex2;                   {* translated data byte *}
  rc:           integer;                {* return code *}

begin
  writeln;
  writeln('Press any key to end trace');
  writeln;

  _mcc_set_receiveslih;                 {* establish interrupt handler *}
  rc:=_mcc_command(UART_MODE);          {* put MCC into pass-thru mode *}
  while not KeyPressed do               {* until some key is hit *}
    begin
      b:=_mcc_get;                      {* see if byte available *}
      if b >=0 then
        begin
          hexdata:=tohex(b);
          write(hexdata,'  ');          {* display receive byte *}
        end;
    end;

  _mcc_set_noslih;                      {* establish interrupt handler *}
  _mcc_reset;
  _mcc_flush;                           {* clear any residual data *}
  flushchar:=ReadKey;                   {* clear exit char *}
end;

{*===================================*}
{*                                   *}
{* Program change command            *}
{*                                   *}
{*===================================*}
procedure prog_change;

var
  prognum:      integer;                {* MIDI program number *}
  chan:         integer;                {* MIDI channel number *}
  i:            integer;                {* delay *}
  rc:           integer;                {* return code *}
begin
  rc:=_mcc_command(UART_MODE);          {* put MCC into pass-thru mode *}
  prognum:=0;
  chan:=0;
  write('Enter channel number (1-16) and program number (1-128) => ');
  read(chan,prognum);                   {* read user response *}
  if (prognum > 0) and (prognum <= 128) and {* validate response *}
      (chan > 0) and (chan <= 16) then
    begin
      _mcc_put($C0+(chan-1));           {* send program change status *}
      _mcc_put(prognum-1);              {* send program number *}
      for i:=1 to 10000 do;             {* give MCC time to send data before reset *}
    end
  else
    writeln('Invalid channel number or program number');
  _mcc_reset;
end;

{*===================================*}
{*                                   *}
{* MIDI Starter System ToolKit       *}
{* Example utility program           *}
{*                                   *}
{*===================================*}

var
  irq:          integer;                { IRQ for interface }
  contflag:     integer;                { continue/end flag }
  choice:       char;                   { menu selection }
  rc:           integer;                { return code }
  response:     char;                   { yes/no }

begin
  contflag:=1;                          {* assume all will go OK *}
  irq:=_mcc_irq($0330);                 {* find IRQ being used *}
  if irq=0 then
    begin
      writeln;
      writeln('Unable to determine IRQ level.');
      contflag:=0;
    end
  else
    if _mcc_open($0330,irq)=0 then      {* open interface for use *}
      begin
        writeln;
        writeln('Unable to open the MIDI interface.');
        contflag:=0;
      end;

  _mcc_set_noslih;                      {* establish interrupt handler *}
  while contflag=1 do
    begin
      ClrScr;
      writeln('Music Quest Programmer''s ToolKit Example Program - Turbo Pascal');
      writeln('Copyright 1988, 1990');
      writeln('Music Quest, Inc.'#10);
      {* Display utility menu *}
      writeln('ToolKit Utility Menu'#10);
      writeln('1  = Hex trace');
      writeln('2  = Send program change command');
      writeln('3  = Interpreted trace');
      writeln('4  = Record');
      writeln('5  = Play');
      writeln('6  = Chase Lock - Song Position Pointer trace');
      writeln('7  = SMPTE frame trace');
      writeln('8  = SMPTE Cue Point');
      writeln('9  = Write SMPTE sync track');
      writeln('x  = Exit');
      write('Type selection and press ENTER => ');

      choice:=ReadKey;                  {* get response *}
      ClrScr;

      case choice of
          '1':                          {* trace *}
            begin
              hex_trace;
            end;
          '2':                          {* program change *}
            begin;
              prog_change;
            end;
          '3':                          {* interpreted trace *}
            begin
              tk_itrace;
            end;
          '4':                          {* record *}
            begin
              record_track;
            end;
          '5':                          {* play *}
            begin
              play_track;
            end;
          '6':                          {* CLS - SPP *}
            begin
              show_spp;
            end;
          '7':                          {* SMPTE display *}
            begin
              show_smpte;
            end;
          '8':                          {* cue point *}
            begin
              cue_point;
            end;
          '9':                          {* write SMPTE track *}
            begin
              write_smpte;
            end;
          'X', 'x':                     {* exit *}
            begin
              writeln(#10'Resetting interface....');
              contflag:=0;
            end;
          else;
      end;
    end;
  _mcc_close;                            {* close MCC *}
end.
