/******************************************************************************
 SCI Template Game
 By Brian Provinciano
 ******************************************************************************
 gauge.sc
 Contains a dialog window which contains a custom gauge control. This is used 
 for things such as volume control and the game speed adjustment.
 ******************************************************************************/
(include "sci.sh")
(include "game.sh")
/******************************************************************************/
(script GAUGE_SCRIPT)
/******************************************************************************/
(use "main")
(use "controls")
(use "syswindow")
/******************************************************************************/
(local
  /*controls*/
  txtDescription = NULL
  btnHigher = NULL
  btnLower = NULL
  btnOK = NULL
  btnNormal = NULL
  btnCancel = NULL
)
/******************************************************************************/
(class Gauge of Dialog
	(properties
		elements 0
		size 0
		text 0
		window 0
		theItem 0
		nsTop 0
		nsLeft 0
		nsBottom 0
		nsRight 0
		time 0
		busy 0
		seconds 0
		lastSeconds 0
		description 0
		higher "up"
		lower "down"
		normal 7
		minimum 0
		maximum 15
	)
	(method (init gaugePos)
		(var ctlX, ctlY)
		= window SysWindow
		
		= btnLower (DButton:new())
		(send btnLower:
			text(lower)
			moveTo(4 4)
			setSize()
		)
		(self:
			add(btnLower)
			setSize()
		)
		= btnHigher (DButton:new())
		(send btnHigher:
			text(higher)
			moveTo( (+ (send btnLower:nsRight) 132) 4 )
			setSize()
		)
		(self:
			add(btnHigher)
			setSize()
		)
		= btnOK (DButton:new())
		= nsBottom (+ nsBottom 8)
		(send btnOK:
			text("OK")
			setSize()
			moveTo(4 nsBottom)
		)
		= btnNormal (DButton:new())
		(send btnNormal:
			text("Normal")
			setSize()
			moveTo((+ (send btnOK:nsRight) 4) nsBottom)
		)
		= btnCancel (DButton:new())
		(send btnCancel:
			text("Cancel")
			setSize()
			moveTo((+ (send btnNormal:nsRight) 4) nsBottom)
		)
		(self:
			add(btnOK btnNormal btnCancel)
			setSize()
		)	
		= ctlX (- (- nsRight (send btnCancel:nsRight) 4) )
		= txtDescription (DText:new())
		(send txtDescription:
			text(description)
			font(gSaveRestoreFont)
			setSize(- nsRight 8)
			moveTo(4 4)
		)
		= ctlY (+ (send txtDescription:nsBottom) 4)
		(self:add(txtDescription))
		
		(send btnHigher:move(0    ctlY))
		(send btnLower: move(0    ctlY))
		(send btnOK:    move(ctlX ctlY))
		(send btnNormal:move(ctlX ctlY))
		(send btnCancel:move(ctlX ctlY))
		
		(self:
			setSize()
			center()
			open(nwTITLE 15)
		)
	)
	(method (doit gaugePos)
		(var btnPressed, newGaugePos)
		(self:init(gaugePos))
		= newGaugePos gaugePos
		(while(1)
  			(self:update(newGaugePos))
  			= btnPressed (super:doit(btnOK))
			(if(== btnPressed btnHigher)
				(if(< newGaugePos maximum)
					++newGaugePos
				)
		    )(else
		    	(if(== btnPressed btnLower)
		    		(if(> newGaugePos minimum)
		    			--newGaugePos
		    		)
				)
				(if(== btnPressed btnOK)
					(self:dispose())
					return(newGaugePos)
		    	)(else
		    		(if(== btnPressed btnNormal)
		    			= newGaugePos normal
		    		)(else
		    			(if(== btnPressed 0 or == btnPressed btnCancel)
							(self:dispose())
							return(gaugePos)
		    			)
		    		)
		    	)
			)
		)
	)
	(method (handleEvent pEvent)
		(switch( (send pEvent:type) )
			(case evKEYBOARD
				(switch( (send pEvent:message) )
					(case KEY_LEFT
						(send pEvent:claimed(TRUE))
						return(btnLower)
					)
					(case KEY_RIGHT
						(send pEvent:claimed(TRUE))
						return(btnHigher)
		    		)
				)
  			)
  			(case evJOYSTICK
  				(switch( (send pEvent:message) ) 
  					(case JOY_LEFT
						(send pEvent:claimed(TRUE))
						return(btnLower)
					)
					(case JOY_RIGHT
						(send pEvent:claimed(TRUE))
						return(btnHigher)
					)
		    	)
			)
		)
		(super:handleEvent(pEvent))
	)
	(method (update gaugePos) // Draws the gauge
		(var i, strLen,x,y)
		= strLen (- maximum minimum)
		= i 0
        = x (+ (send btnLower:nsRight) 6)
        = y (send btnLower:nsTop)
        (if(== 1 gaugePos)
            DrawCel(902 0 3 x y -1)
            = i 1
            = x + x 8
        )
  		(while(< i strLen)
			(if(< i gaugePos)
                DrawCel(
                    902 0
                    ((if(== 0 i)
                        1
                    )(else
                        (if(== i - gaugePos 1)
                            2
                        )(else
                            0
                        )
                    ))
                    x y -1
                )
			)(else
                DrawCel(
                    902 0
                    ((if(== 0 i)
                        5
                    )(else
                        (if(== i - strLen 1)
                            6
                        )(else
                            4
                        )
                    ))
                    x y -1
                )
			)
            = x + x 8
		    ++i
		)
	)
)
/******************************************************************************/
