#ifndef	__vga_h
	#define __vga_h
#include<string.h>
#include<strstrea.h>
/*	CHIPS header file				v0.86	12/22/95
 *
 *	Some major changes since v0.84...
 *	I removed most <stdio.h> functions (sprintf, fprintf, etc.), and
 *	(finally) replaced them with the more appropriate C++ stream methods.
 *	.............
 *	This header contains the necessary class structure VGA for my MCLK
 *	program to manipulate.  Chipset specific classes (S3, Cirrus, etc.)
 *	are defined in other header files, and are not necessary for MCLK.CPP
 *
 *	(If you wish to recompile the chips.lib file, you must compile
 *	 chips.cpp with chips.h.)
 */

#define INITMSG(x) ostrstream msgout( x, sizeof( x ) )
	// macro to quickly setup "msgout" method, printing-to-string

#define 	TRUE		1
#define 	FALSE	0

#define	_CRindex	0x3D4	//	CRindex port-io address, color
#define	_CRIO	0x3D5	//	CRIO port-io address, color
#define	_SRindex	0x3C4	//	SRindex port-io address, color
#define	_SRIO	0x3C5	//	SRIO port-io address, color
#define	_GRindex	0x3CE	//	GRindex port-io address, color
#define	_GRIO	0x3CF	//	GRIO port-io address, color
#define	_DACmask	0x3C6	//	RAMDAC register MASK port-io address
#define _DACindexR	0x3C7	//	RAMDAC read-index
#define _DACindexW	0x3C8	//	RAMDAC write-index register
#define	_DACIO	0x3C9	//	address for read/write of data RAMDAc
#define	_OSC		14.31818	//	Reference oscillator frequency

#define _MAXOPTIONS	5
	//	Maximum # of user-selectable choices


#ifndef uchar
typedef unsigned char uchar;
#endif

//	A structure for exchanging information about video hardware
//	between the program and the underlying data structures
typedef struct {
	char make[ 80 ];		//	Examples... S3, Cirrus Logic, etc.
	char chipset[ 80 ];		//	Examples... Trio64, GD-5428, etc.
	char revision[ 80 ];	//	Examples... 01, 0A, etc.
} vga_info;

#define _TEXTLENGTH 512

typedef struct	{
	char text[ _TEXTLENGTH ];
	char temp[ _TEXTLENGTH ];	//temporary work space
}	message;


#define _SET		1
#define _GET		2
#define _HELP		3
#define _QUERY		4
	//	Query will cause xxx::_fxnX( _QUERY ) to put a text-line
	//	describing its operation (eg. "2 IO RDY wait state control")
	//	into msg.text

class vga		{
protected:
	int parse_param( int index, uchar *parsed ); // Acquire 1 parameter
	uchar shift( uchar in );	//	remaps shift(2) -> 3, and shift(3) -> 2
	vga_info id;			// Video chipset identification
	virtual void _mclk( int cmd );	//	Allow MCLK reprogramming
	virtual void _fxn1( int cmd );
	virtual void _fxn2( int cmd );	//	cmd = _GET, _SET, _HELP
	virtual void _fxn3( int cmd );
	virtual void _fxn4( int cmd );
	virtual void _fxn5( int cmd );
	char * bitstat( uchar bit );	//	Returns "ENABLE or DISABLE"

	/* Quick function for printing hex-numbers in "XX" format */
	void hexout( ostrstream &deststr, int value );

public:
	int num_param;		//	Number of parameters in input list
	char **param;		//	List of parameters

	virtual message _info( void );	//	return SVGA information
	vga( vga_info info );	// Constructor prototype,
		//	set-up identification "info" structure -> vga_info id;
	virtual ~vga() { ; } ;	// Destructor
	message get_settings( void );	//	List user-changeable settings
	vga_info get_info( void )	//	Inquire information of video chipset
		{	return( id );	};
		//	Returns information, like VGA name, chipset, revision
	message get_vgahelp( void );	//	Returns general help message
	message msg;		//	Text-buffer for return messages

	int status;		//	EXIT_FAILURE or EXIT_SUCCESS
	void go( int fxn, int cmd );	//	Execute command,
		//	where cmd == _SET, _GET, _HELP
	char * version( void )	//	Returns software_revision in text-string
		{	return "v091 07/31/96" ;	};

	uchar read_SR( uchar index ); // Reads VGA _SR register index,
	void write_SR ( uchar index, uchar data );	// Writes VGA _SR register
	uchar read_CR( uchar index );	// Reads VGA _CR register index
	void write_CR ( uchar index, uchar data );	// Writes VGA _CR register
	uchar read_bit ( int port, uchar index, uchar bit );
		// Read single bit, bit = #bits from RIGHT -> 7654 3210
	void write_bit( int port, uchar index, uchar bit, uchar data );
		// Write single bit, bit = #bits from RIGHT -> 7654 3210
};

//	Force auto-detection to check only these graphics controllers
#define _AUTO		-1
#define _FCIRRUS	1
#define _FS3		2
#define _FW32P		3
#define _FTRIDENT	4
	//	for forcing auto-detection of _W32P...

class detect	{
protected:
	vga_info id;
	vga *hardware;
	message msg;	//	char buffer for returning messages to caller
public:
	detect( void )
		{ hardware = NULL;	};		//	Constructor
	message _help( int mode = _AUTO );	//	Help menu lists chipsets
	vga * _find( int chipset = _AUTO, int family = _AUTO );
		//	Detection routine, default is auto-detection
	vga * _debug( int mode = _AUTO );	//	DEBUGGING purposes only!
	vga * detect_cirrus( int mode = _AUTO );
	vga * detect_s3( int mode = _AUTO );
	vga * detect_w32p( int mode = _AUTO );		//	NO SUPPORT YET
	vga * detect_trident( int mode = _AUTO );	//	UNTESTED
};

#endif