/*	w32p.cpp
 *
 *	Tseng ET4000/W32p class declarations
 */

#include "w32p.h"

#include<dos.h>
#include<string.h>
#include<stdio.h>
#include<stdlib.h>


_w32p::_w32p( vga_info info ) : vga( info )
{
	outportb( 0x3BF, 0x03 );	//	Unlock W32P "key"
	outportb( 0x3D8, 0xA0 );	//	Unlock W32P "key"
}


void
_w32p::_fxn1( int cmd )	//	PCI burst mode enable
{	//	bit4 of _CR34
	if ( cmd == _QUERY )	{
		strcpy( msg.text, "1  W32P PCI burst mode (PCI only)\n");
		return;
	}

	uchar _CR34 = read_bit( _CRindex, 0x34, 4 );
	uchar new_CR34= 0x0;

	if ( param[ 0 ] != NULL )
		new_CR34 = (uchar)atoi( param[ 0 ] );

	sprintf( msg.text, "PCI Burst mode = %sd", bitstat( _CR34 ) );

	switch ( cmd )	{
		case _SET:
			write_bit( _CRindex, 0x34, 4, new_CR34 );
			sprintf( msg.temp,"\n...now %sd",
				bitstat( read_bit( _CRindex, 0x34, 4 ) ) );
			strcat( msg.text, msg.temp );
			break;
		case _HELP:	case _GET:
			sprintf( msg.temp, "\nPCI Burst mode (PCI only) \n\t%s",
				"DISable = 0d\n\tENable  = 1d");
			strcat( msg.text, msg.temp );
			break;
		default:
			sprintf( msg.text, "_w32p::_fxn1(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}


void
_w32p::_fxn2( int cmd )	//	memory interleaving
{	//	bit7 of _CR32
	if ( cmd == _QUERY )	{
		strcpy( msg.text, "2  W32P memory interleaving (2mb only)\n");
		return;
	}

	uchar _CR32 = read_bit( _CRindex, 0x32, 7 );
	uchar new_CR32= 0x0;

	if ( param[ 0 ] != NULL )
		new_CR32 = (uchar)atoi( param[ 0 ] );

	sprintf(msg.text,"DRAM memory interleaving = %sd", bitstat( _CR32 ) );

	switch ( cmd )	{
		case _SET:
			write_bit( _CRindex, 0x32, 7, new_CR32 );
			sprintf( msg.temp,"\n...now %sd", bitstat( new_CR32 ) );
			strcat( msg.text, msg.temp );
			break;
		case _HELP:	case _GET:	sprintf( msg.temp,
			"\nDRAM Memory interleaving ( requires 2mb DRAM )%s",
				"\n\tDISable = 0d\n\tENable  = 1d");
			strcat( msg.text, msg.temp );
			break;
		default:
			sprintf( msg.text, "_w32p::_fxn2(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}


void
_w32p::_fxn3( int cmd )	//	FIFO threshold control
{	//	bit7,bit5 of _CR37
	if ( cmd == _QUERY )	{
		strcpy( msg.text, "3  W32P FIFO threshold control (2 items)\n");
		return;
	}

	uchar low = read_bit( _CRindex, 0x37, 7 ),
		high = read_bit( _CRindex, 0x37, 5 );

	sprintf( msg.text, "FIFO low threshold = %u,  FIFO high threshold = %u",
		low, high );

	if ( num_param < 2 && cmd == _SET )	{
		strcat( msg.text, "\nError!  TWO parameters required!");
		cmd = _HELP; }
	else	if ( num_param >= 2 ) {
		low = ( (uchar)atoi( param[ 0 ] ) ) & 0x01;
		high = ( (uchar)atoi( param[ 1 ] ) ) & 0x01;
	}

	switch ( cmd )	{
		case _SET:	write_bit( _CRindex, 0x37, 7, low );
			write_bit( _CRindex, 0x37, 5, high );
			sprintf( msg.temp, "\n...low = %u,  high = %u ", low, high );
			strcat( msg.text, msg.temp );
			break;
		case _HELP:	case _GET:	sprintf( msg.temp,
			"\nLow threshold ... 0=normal,  1=increased%s%s%s",
				"\nHigh threshold ... higher priority for ",
				"\n\t0 = W32p (accelerator uses more bandwidth)",
				"\n\t1 = CPU  (host accesses get higher priority)");
			strcat( msg.text, msg.temp );
			break;
		default:
			sprintf( msg.text, "_w32p::_fxn3(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}


void
_w32pb::_fxn4( int cmd )	//	Fast read/write control
{	//	bits5-4 of TS Register6
	if ( cmd == _QUERY )	{
		strcpy( msg.text,
		 "4  W32P fast read/write control (2 items, W32p RevB +)\n");
		return;
	}

	uchar read = read_bit( _SRindex, 0x6, 5 ),
		write = read_bit( _SRindex, 0x6, 4 );

	sprintf( msg.text, "Fast read control = %sd,  Fast write control = %sd",
		bitstat( read ), bitstat( write ) );

	if ( num_param < 2 && cmd == _SET )	{
		strcat( msg.text, "\nError!  TWO parameters required!");
		cmd = _HELP; }
	else	if ( num_param >= 2 ) {
		read = ( (uchar)atoi( param[ 0 ] ) ) & 0x01;
		write = ( (uchar)atoi( param[ 1 ] ) ) & 0x01;
	}

	switch ( cmd )	{
		case _SET:	write_bit( _SRindex, 0x6, 5, read );
			write_bit( _SRindex, 0x6, 4, write );
			sprintf( msg.temp, "\n...fast read = %s,  fast write = %s ",
				bitstat( read ), bitstat( write ) );
			strcat( msg.text, msg.temp );
			break;
		case _HELP:	case _GET:	sprintf( msg.temp,
			"\nRequires W32p RevB or better\n2 parameters %s",
			" ... 1=ENABLE,  0=DISABLE" );
			strcat( msg.text, msg.temp );
			break;
		default:
			sprintf( msg.text, "_w32pb::_fxn4(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}


void
_w32pb::_fxn5( int cmd )	//	PCI burst mode enable
{	//	bit6 of _SR06
	if ( cmd == _QUERY )	{
		strcpy( msg.text, "5  W32P 0 wait-state control (W32p RevB + )\n");
		return;
	}

	uchar _SR06 = read_bit( _SRindex, 0x06, 6 );
	sprintf( msg.text, "Zero read/write wait-state = %sd",
		bitstat( !_SR06 ) );

	if ( param[ 0 ] != NULL )
		_SR06 = ( (uchar)atoi( param[ 0 ] ) ) & 0x01 ;

	switch ( cmd )	{
		case _SET:
			write_bit( _SRindex, 0x06, 6, _SR06 );
			sprintf( msg.temp,"\n...now %sd", bitstat( !_SR06 ) );
			strcat( msg.text, msg.temp );
			break;
		case _HELP:	case _GET:
			sprintf( msg.temp, "\nZero wait-state (W32p RevB + )\n\t%s",
				"DISable = 1d\n\tENable  = 0d");
			strcat( msg.text, msg.temp );
			break;
		default:
			sprintf( msg.text, "_w32pb::_fxn5(cmd)  UNRECOGNIZED cmd.");
			status = EXIT_FAILURE;
	}
}