//	Trident header file trident.h
//
//	Contains class definitions for Trident 9440/96xx video boards
//
//

//	The following line denies outside code access to certain
//	member functions of class vga.
#define __trident_h
#include "vga.h"
#include<dos.h>

#define _NEW	1
#define _OLD	0


class _TR9440 : public vga	{		// Trident 9440AGi chipset
protected:
	uchar old_SR0E;	//	preserve previous _SR0E
	double get_mclkfreq( void );
		//	Get MCLK frequency from port IO register 0x43C6
	int read_mclk( void );
		//	Read mclk-register into integer value
public:
	message _info( void );		//	Return chipID ( 0x3C4, index 0B )
	void _mclk( int cmd );		//	MCLK programming function
	_TR9440( vga_info info ) : vga( info )
		{	old_SR0E = read_SR( 0x0E );
			write_SR( 0x0E, 0xC2 );	// Unlock Trident SVGA
		};

	~_TR9440()
		{	write_SR ( 0x0E, old_SR0E );	// Restore register
		};
};