
program S3Test;

{ S3Test  Version 3.00  09.09.1995  Dietmar Meschede }
{                                                    }
{ Copyright (c) 1993,1995 Dietmar Meschede           }
{                                                    }
{ Use at OWN risk!                                   }

{ Demonstrates the usage of the unit S3. }

{$DEFINE PROTECTED}   { The program runs only in protected mode. }
{$I STDPROG.OPT}

uses
  Crt, NewFrontier, S3;

procedure Wait;
begin
  Write(^G);
  if ReadKey = #0 then ReadKey;
end; { Wait }

procedure PutPixel512(X, Y: Integer; Color: Byte);
begin
  WriteMem32B(Ptr48(S3Video, (Longint(Y) * 512) + Longint(X)), Color);
end; { PutPixel512 }

procedure PutPixel1024(X, Y: Integer; Color: Byte);
begin
  WriteMem32B(Ptr48(S3Video, (Longint(Y) * 1024) + Longint(X)), Color);
end; { PutPixel512 }

var
  i: Byte; j: Integer;

begin
  S3Init320x240;
  Wait;
  for i := 0 to 239 do begin
    PutPixel512(40 + i, i, i);
    PutPixel512(280 - i, i, i);
  end; { for }
  Wait;
  for i := 0 to 191 do FillChar32(Ptr48(S3Video, 0), 512 * 240, i);
  Wait;
  S3Init640x480;
  Wait;
  for j := 0 to 479 do begin
    PutPixel1024(80 + j, j, Byte(j));
    PutPixel1024(560 - j, j, Byte(j));
  end; { for }
  Wait;
  for i := 0 to 47 do FillChar32(Ptr48(S3Video, 0), 1024 * 480, i);
  Wait;
  TextMode(LastMode);
end. { S3Test }
