
Model DCHS-34450                                IBM Hard Disk Drive
_____________________________________________________________________
Update June 6, l996


IBM has introduced a range of disk drives intended for advanced
storage applications which demand fast access to large amounts of
data. The drives spin at 7200 RPM, has an EPRML channel embedded
sector servo and S.M.A.R.T.


Product description
-------------------

Models

SCSI 2 Fast (50 pin single-ended)
SCSI 2 Fast (68 pin single-ended and differential)
SCSI 3 Fast 20 (68 pin single-ended and differential)
SCSI 3 Fast 20 (80 pin single-ended SCA-2)


Applications

Technical/commercial workstations
Network servers
Mass storage arrays
High end personal computers
Large scale imaging and graphics
Video servers
Video editing


Features

* 4550 and 9111 MB formatted capacity
  (512 byte/sector)
* Industry standard interface
  -50 pin ANSI SCSI-2
  -68 pin ANSI SCSI-2
  -68 pin ANSI SCSI-3
  -80 pin ANSI SCSI-3
* 10.3/16.4 MB/s media data rate
* Rotational speed 7200 rpm
* Average seek time 7.5 ms (4.55 GB)
  8.5 ms (9.10 GB)
* Latency 4.17 ms
* 512 KB multi-segmented dual port data buffer
* Spindle synchronization
* Low command overhead * Read ahead caching
* ECC on the fly (EOF)
* Industry standard mounting
* Predictive failure analysis (S.M.A.R.T. compliant)


Electrical interface specifications
-----------------------------------

Connectors

The electrical connectors are located as shown.


        ĿͿ
                                             
                                          Ĵ
                                  Ĵ  
                                    Ĵ  
        ¿
        ::::::::::::::::::::::::::::::::::
        
            
            Pin 1


  Electrical connectors (rear view) 80 pin SCA models



               Aux. Connector Pin 1Ŀ   Power Pin 1
              SCSI Pin 1Ŀ               
        ͳͳͿ
                                         
                                         
        Ĵ
        ſſͳ 
        ::::::::::::::::::::::::o o o o 
        ͼ 
        
                                 Pin 2
                         Pin 35

  Electrical Connectors (rear view) 68 pin models



                                 Pin 1     Pin 1


                                            
                                            
        ͳͳͿ
                                          
                                          
        Ĵ
        ſ ͳ 
        ::::::::::::.:::::::::::: o o o o 
         ͼ 
        
           SCSI I/F                
           Connector               
                                   


  Electrical connectors (rear view) 50 pin models


        ĿͿ
                                             
                                          Ĵ
                                  Ĵ  
                                    Ĵ  
        Ϳ
         :::.:::::::::::                   
        
              (15x)2mm       2.54 mm
        ---><---       ---><--------


  Jumper pin locations (front view) all models

Note: No termination power on 80 pin SCA

The DC power connector is designed to mate with AMP part 1-48024
(using AMP pins P/N 350078-4).  Equivalent connectors may be used.
Pin assignments are shown below, as viewed from the end of the drive.


      Pin # 4 3 2 1
           ͻ  Pin # 1  - +12V
           O O O O       2,3 - GND
           ͼ        4  - +5V


Hot plug/unplug support
-----------------------

The drives do support hot plug/unplug (excepting the 80 pin SCA).
Refer to the Ultrastar 2XP hardware/functional specification for
more details.

Hot plugging the SCSI bus may cause glitches on the bus.  To minimize
the chance of glitching, it is recommended to plug in the SCSI bus
before the power is applied.

During hot plugging, the supplies must not go over the upper voltage
limits.  This means that proper ESD protection must be used during the
plugging event.


50 pin SCSI signal connector

50 pin models use an AMP PN 84160-1 connector.  The connector is
compatible with the ANSI SCSI 'A' connector specifications.  It is
limited to 8 bit data transfers only.


68 pin SCSI signal connector

68 pin models use an AMP connector (PN 786963-1) that is compatible
with the ANSI SCSI 'P' connector specifications.  It can transfer
data in both 8 bit (narrow) and 16 bit (wide) modes.  Both single-
ended and differential versions are supported.  The differential
68 pin models are electrically compatible with differential 50 pin
models and other 50 pin differential SCSI products and therefore can
coexist on the same bus.  In order to do so, the differences in
connector types would need to be accounted for in the cable.
Connecting 68 and 50 pin single-ended models to the same bus can also
coexist.  Differential and single-ended models do not work connected
to the same bus.


80 pin (single connector attachment)

The 80 pin SCA-2 models use an AMP connector (PN 5-917593-9) that is
compatible with the specification of: 'Single connector attachment for
small SCSI disk drives' SFF-8046.  It can transfer data in both 8 bit
(narrow) and 16 bit (wide) modes.

Note: The SCA-2 connector is not mechanically compatible with
      the 50 pin 'A' connector or the 68 pin 'P' connector as defined
      in the ANSI SCSI standard.  This connector is intended for
      direct backplane attachment and is not intended to be cable
      attached to the bus.


SCSI bus cable

Single-ended models permit cable lenths of up to 6 meters (19.68 feet).
It should be noted however that users who plan to use 'fast' data
transfers with single-ended models should follow all of the ANSI SCSI
guidelines for single-ended 'fast' operations.  This may include a
cable length of less than 6 meters.

SCSI 3 fast 20 models can be cable connected to a 3 meter (9.8 feet)
cable when a maximum of 4 devices are attached, and a 1.5 meter
(4.9 feet) cable with up to 8 devices attached.

SCA-2 connector models are not designed for direct cable attachment
due to the combination of power and SCSI bus signals.  Fast & fast
20 data transfers with SCA models should follow all of the ANSI SCSI
guidelines.

Differential models permit cable lengths of up to 25 meters
(82.02 feet). Cables must meet the requirements for differential
cables as set forth in the ANSI SCSI standard under "cable
requirements- differential cable".

The ANSI SCSI standard states that any stub from main cable must
not exceed 0.1 meters for single-ended cables and 0.2 meters for
differential cables. Ultrastar 2XP has a maximum internal stub
length of 0.05 meters on all "single-ended" SCSI signals, and 0.1
meters on all "differential" SCSI signals.  To remain compliant with
the standard the SCSI bus cable must not add more than 0.05 meters
additional stub length to any of the single-ended SCSI signals or
0.1 meters to any differential SCSI signals.


SCSI bus terminators (optional)
-------------------------------

For those drives having the active termination feature, this function
can be enabled by installing a jumper between pins 13 and 14 of the
front option jumper block or connecting pins 9 and 11 of the auxiliary
connector on 68 pin SCSI models.  The using system is responsible
for making sure that all required signals are terminated at both ends
of the cable.

80 pin SCA models do not have internal SCSI bus terminators.

Some external terminator possibilities for single-ended cabled systems
are listed below:

50 pin model           68 pin model
terminators            terminators
------------           ------------
 Data Mate              Data Mate
DM2000-02-R            DM2050-02-68S
DM500-06-R             DM2050-02-68R


Single-ended SCSI terminators

Differential models do not have internal SCSI bus terminators.  Some
terminator possibilities are shown below:

50 pin model           68 pin model
terminators            terminators
------------           ------------
 Data Mate              Data Mate
DM550-05-0            DM2050-01-68D
DM1050-02-0


Differential SCSI terminators

Note: A Meritec model 940900-4 or a DataMate DM5000-5068-11
      can be used to connect a 68 pin connector to a 50 pin
      connector.  The drive will perform 8 bit transfers.


SCSI bus termination power

Termination power is optionally provided for systems that desire to
use it.  In order to use the termination power, the user needs to
install a jumper between pins 1 and 2 of the termpower block.
The jumper should only be installed on one device, which should be
the last device on the SCSI bus.  68 pin models can source up to 2.0
Amps of current at 5.0 Volts (+/-5%) for termination power.  50 pin
models can source up to 15 Amps of current at 5.0 Volts (+/-5%) for
termination power.


SCSI bus termination power short circuit protection

The ANSI SCSI specification recommends for devices that optionally
supply termpwr, to include current limited protection for accidental
short circuits.  It also recommends that the maximum current available
for termpwr should not exceed 2 Amps.  UL has a different requirement
that they call the 8 Amp rule.  This rule states that when a power
source leaves an enclosure (like SCSI termpwr in the SCSI cable) it
must trip 8 Amps of current within 1 minute.

The drive limits current to 5.0 Amps through the use of a permanent
fuse mounted on the electronic card.  Systems may also provide short
circuit protection for drive supplied termpwr by limiting the current
of the 5V power it supplies to the drive.


Jumper settings
---------------

Jumper position and function are as shown below.  Pin pitch is 2 mm.
Termination power enable 2.54 mm pitch.


        External activity LED  Write protect
                              
               Master sync      Auto start delay
                               
                 Ground          Option block mode
                                
          Auto start              Disable sync negotiations
                                 
           Blank                   Disable SCSI parity
                                  
   SCSI address                     Disable unit attention
       2  1  0                        Customize
                                   
    1  3  5  7   11 13 15 17 19 21 23 25 27 29 31
   
 Ĵo  o  o  o     o  o  o  o  o  o  o  o  o  o  o    0 0 
 Ĵo  o  o  o  o  o  o  o  o  o  o  o  o  o  o  o   
       
   2  4  6  8    12 14 16 18 20 22 24 26 28 30 32      Ĵ
                                          
                        
    Gound     Ground            Ground            Termination
                                                  power enable
 Blank pins           +5V
   on 50 pin models     
                        Slave sync
Enable active termination



                         Option block mode
                         
                           Alternate mode bit (reserved)
                           3  2  1  0
                        23 25 27 29 31
                       
                        o o  o  o  o    0 0 
                        o o  o  o  o   
                           1 2
                        24 26 28 30 32
                                 
                         
                            Ground

50 pin single ended front option jumper block and termpower block



        External activity LED  Write protect
                              
               Master sync      Auto start delay
                               
                 Ground          Option block mode
                                
          Auto start              Disable sync negotiations
                                 
           Blank                   Disable SCSI parity
                                  
   SCSI address                     Disable unit attention
    3  2  1  0                        Customize
                                  
    1  3  5  7   11 13 15 17 19 21 23 25 27 29 31
   
   o  o  o  o     o  o  o  o  o  o  o  o  o  o  o    0 0 
   o  o  o  o  o  o  o  o  o  o  o  o  o  o  o  o   
        
    2  4  6  8    12 14 16 18 20 22 24 26 28 30 32      Ĵ
                                           
                         
     Gound     Ground            Ground            Termination*
                                                   power enable
                        +5V
                        
                        Slave sync
Enable active termination
**Enable narrow mode


                         Option block mode
                         
                           Alternate mode bit (reserved)
                           3  2  1  0
                        23 25 27 29 31
                       
                        o o  o  o  o    0 0 
                        o o  o  o  o   
                           1 2
                        24 26 28 30 32
                                 
                         
                            Ground


68 pin single ended front option jumper block and termpower block.
68 pin differential & 80 pin SCA front option jumper block

*Not available on 80 pin SCA
**68 pin differential & 80 pin SCA


                  68 pin auxiliary connector
                                   
        ͳͿ
                                              
                                              
                                              
        Ŀſͻ  
        ::::::::::::::::::::::::o o o o  
        ͼ



                            Enable SCSI terminator
                            
                               SCSI ID
                       +5V    3  2  1  0
                                   
                Pin #   11  9  7  5  3  1
                       Ŀ
                        o  o  o  o  o  o 
                        o  o  o  o  o  o 
                       
                        12 10  8  6  4  2
                                   
             Write protect          Unused
                                  
                       Ground      Auto spin up
                                 
           External activity LED  Slave sync


SCSI ID (address) pins

Note: In the address determination tables, "off" means jumper
      is not in place and "on" means jumper is in place.

Address determination of 68 and 80 pin models

 Bit 3   Bit 2   Bit 1   Bit 0     Address
 -----   -----   -----   -----     -------
  off     off     off     off        0
  off     off     off     on         1
  off     off     on      off        2
  off     off     on      on         3
  off     on      off     off        4
  off     on      off     on         5
  off     on      on      off        6
  off     on      on      on         7
  on      off     off     off        8
  on      off     off     on         9
  on      off     on      off       10
  on      off     on      on        11
  on      on      off     off       12
  on      on      off     on        13
  on      on      on      off       14
  on      on      on      on        15


Address determination of 50 pin models

 Bit 2   Bit 1   Bit 0    Address
 -----   -----   -----    -------
  off     off     off       0
  off     off     on        1
  off     on      off       2
  off     on      on        3
  on      off     off       4
  on      off     on        5
  on      on      off       6
  on      on      on        7


Auto start and delay pins

The auto start and auto start delay pins control when and how the
drive can spin up and come ready.

When configured for auto-startup, the motor spins up after power is
applied without the need of a SCSI start unit command.  For no auto-
start, a SCSI start unit command is required to maek the drive spin
and be ready for media access operations.  When in auto-star mode,
the drive will delay its start time by a period of time multiplied
by its own SCSI address.


Auto startup modes selectable by auto-start/delay pin combinations

Pins (50 and 68                                      Drive
interface pin models)                               behavior
---------------------                              ---------
Auto start/           Auto start     Auto start    Delay(sec)
       delay                                          multiplier
     off                 off            No               N/A
     off                 on             Yes               0
     on                  off            Yes              10
     on                  on             Yes               4

Pins (80 interface                                   Drive
pin models)                                         behavior
------------------                                  --------
Auto start/           Auto start     Auto start    Delay(sec)
       delay                                          multiplier
     off                 off            Yes               0
     off                 on             No               N/A
     on                  off            Yes              10
     on                  on             No               N/A


External activity (LED) pins

The LED pins can be used to drive an external light emitting diode.
Please refer to the LED pin section of the Ultrastar 2XP interface
specification for a detailed functional description of this pin,
which is controlled by mode select (page 0).

Up to 33 mA (+/-5%) of TTL level LED drive capability is provided.
Current limiting for the LED is provided on the electronics card.
The LED andode may be tied to the +5V source provded on pin 18 of
the front option jumper block, pin 11 of the auxiliary connector on
the 68 pin unitized connector or the 5V power source on the 80 pin
SCA model.  The LED cathode is then connected to the external
activity pin to complete the circuit.

Note: 68 pin and 80 pin SCA SCSI models have two sets of pins,
      a set on the front and a set on the back, that are connected
      to the same LED driver circuit.  The combined drive capability
      is stated above.


Write protect pin

If the write protect pin is jumpered to ground, the drive will
prohibit SCSI commands that alter the customer data area portion
of the media from being performed.  The state of this pin is monitored
on a per command basis.  See the Ultrastar 2XP interface specification
for functional details.


Option block mode pin

The option block mode pin is used to modify the function of the front
option jumper block.  When the option block mode pin is not grounded
the pin function of the front option jumper block will be as defined
by the upper portion of the referenced figures.  When the option block
mode pin is grounded the pins (25, 27, 29, 31) will be redefined to
control what is referred to as 'alternate mode'.  Alternate mode is
reserved for future use.


Disable T.I. sync. negotiation pin

If a disable target initiated synchronous negotiation pin is grounded
then an initiator is required to start a negotiation handshake if
synchronous and/or wide (double byte) SCSI transfers are desired.
Please refer to the Ultrastar 2XP interface specifications for more
details on this feature.


Disable SCSI parity pin

Grounding this pin will disable SCSI parity checking.


Disable unit attention pin

Grounding this pin will disable the drive from building unit attention
sense information for commands immediately following a power on reset
(POR) or SCSI bus reset.  Any pending unit attention conditions will
also be cleared at POR or SCSI reset times.


Customizing pin

The customizing pin is currently reserved for future use.


Enable narrow mode

Jumpering pin 14 to 14 will cause the 68 pin differential or the 80
pin SCA-2 to operate in a single byte mode.  The drive will not
negotiate for "wide" (double byte) operation.  Teh drive will
terminate the unused upper byte and upper byte parity on the SCSI bus.


Enable active termination

Single ended 50 and 68 pin models are available with on card SCSI bus
active terminators.  The active termination feature can be enabled by
installing a jumper between pins 13 and 14 of the front option jumper
block or connecting pins 9 and 11 of the auxiliary connector on 68 pin
SCSI models.  SCA-2 80 pin and 68 pin differential have no termination.


Data organization
-----------------

DCHS-34550

Disks                         5
User data heads               9
Seek times
  Single cylinder    (read)   0.5 msec
                     (write)  2.0 msec
  Average (weighted) (read)   7.5 msec
                     (write)  9.5 msec
  Full stroke        (read)  14.5 msec
                     (write) 16.5 msec

User capacity for several block lengths

User bytes/           formatted             logical blocks/
logical block         capacity (bytes)      drive
   512                  8,888,543             17,796,077
   514                  8,871,650             17,762,201
   520                  8,639,864             17,298,449
   522                  8,612,171             17,242,973
   524                  8,555,471             17,129,573
   528                  8,493,749             17,005,796
   536                  8,400,149             16,818,569
   688                  6,696,665             13,408,181
   740                  6,263,171             12,540,473

User bytes/logical blocks 512 to 5920


Mode select options
-------------------

Certain parameters are alterable using the SCSI mode slect command.
This allows certain drive characteristics to be modified to optimise
performance on the paticular system. Refer to the Ultrastar 2XP
interface specifications for a detailed definition of mode select
parameters.

The changeable parameters are:

Page 0 - Vendor unique parameters
QPE    - Qualify posted errors
DWD    - Disable write disconnect
ASDPE  - Additional save data pointer enable
CMDAC  - LED active
RPFAE  - Report predictive failure analysis
         Error bit
DOTF   - Disable ECC on the fly
RRNDE  - Report recovered non data errors
CPE    - Concurrent processing enable bit
DLRO   - Disable latency reduction optimization
TCC    - Track  compensation
DSN    - Disable target initiated synchronous
         negotiation
FRDD   - Format and reassign degraded disable
DPSDP  - Data phase save data pointer
CAEN   - Command age
LITF   - Idle time function
ADC    - Adaptive cache enable
QEMC   - Queue error management control
DRD    - Disable read disconnect
LED    - LED control
DRRT   - Disable read reassign target
DUASS  - Disable unit attention on spindle sync
RARRED - Report automatic/recommend rewrite/
         reallocate disabled
FFMT   - Fast format enable
VMC    - Video mode configure
RTP    - Reassign target padd
RRC    - Read retry count
FCERT  - Format certification
RCPF   - Report component PFAGEM failures
DRPDV  - Disable reassign blocks post move verify
DSF    - Discard surface analysis results

Page 1 - Error recovery parameters
AWRE   - Automatic write reallocation enable
ARRE   - Automatic eead reallocation enable
TB     - Transfer block
RC     - Read continuous
PER    - Post error
DTE    - Disable transfer on error
DCR    - Disable correction
Read retry count
Correction span
Head offset count
Data strobe offset count
Write retry count
Recovery time limit

Page 2 - Disconnect/reconnect parameters
Read buffer full ratio
Write buffer empty ratio
Bus inactivity limit
Disconnect time limit
Connect time limit
Maximum burst size
DTDC   - Data transfer disconnect control
DIMM   - Disconnect immediate

Page 4h - Rigid disk drive geometry parameters
RPL     - Rotational position locking
Rotational offset

Page 7h - Error recovery parameters for verify
PER
DCR
Verify correction span
Verify retry count
Verify recovery time limit

Page 8h - Caching parameters
WCE     - Write cache enable
MF      - Multiplication factor
RCD     - Read cache disable
Demand read retention priority
Write retention priority
Disable pre-fetch transfer length
Minimum pre-fetch
Maximum pre-fetch
Maximum pre-fetch ceiling
Number of cache segments

Page 0Ah - Control mode parameters
RLEC     - Report log exception condition
Queue algorithm modifier
QErr     - Queue error management
DQue     - Disable queuing
EECA     - Enable extended contingent allegiance

Page 0Ch - Notch parameters
Active notch


Models
------

The DCHS-34450 comes in a variety of models as follows:

 SCSI 2 Fast (50 pin single-ended)
 SCSI 2 Fast (68 pin single-ended and differential)
 SCSI 3 Fast 20 (68 pin single-ended and differential)
 SCSI 3 Fast 20 (80 pin single-ended SCA-2)


DCHS Model No.      SCSI pins/connector type     SCSI signal type
--------------      ------------------------     ----------------
    04F                      50                      SEF
    04W                      68                      SEFW
    04E                      68                      DFW
    04S                    80 SCA-2                  SEFW
    04U                      68                     SEF20W
    04X                      68                     DEF20W
    04Y                    80 SCA-2                 SEF20W

Notes:
*SEF stands for single ended fast
*SEFW stands for single ended fast wide
*DFW stands for differential fast wide
*SEF20W stands for single ended fast 20 wide
*DEF20W stands for differential fast 20 wide
*50 pin SCSI connector models offer an 8
 bit SCSI bus using the SCSI 'A' connector.
*68 pin SCSI connector models offer an 8/16
 bit SCSI bus using the SCSI 'P' connector
 which supports wide data transfers
*80 pin SCSI connector models offer an 8/16
 bit SCSI bus using the SCA connector.
*All models support fast SCSI data transfers
 and the U, X and Y models also support
 SCSI-3 fast 20 data transfer.


Spindle synchronization
-----------------------

Spindle synchronization overview

There are four modes of spindle synchronization.  See below for
a list of how the -MASTER SYNC and -SLAVE SYNC pins on the option
jumper block are used for the different modes.  The following
paragraphs give a short description of each spindle synchronization
mode:

1)The slave drive (Slave Sync mode) receives the index from the
  master drive on the -SLAVE SYNC line and synchronizes its INDEX
  (Slave index) to it.
2)Should the drive be the master drive, (master sync mode), it
  outputs its INDEX on the -MASTER SYNC and the -SLAVE SYNC lines.
  The master drive does not synchronize its index to any other
  device.  It simply outputs its INDEX.
3)In the master sync control mode, a drive will synchronize
  its spindle to the signal it receives on the -SLAVE SYNC input.
  It outputs to -MASTER SYNC a pulse that has the same period as the
  drive INDEX, but is not synchronized to the drive INDEX generated
  from the disk.
4)In the non-sync mode, the drive will receive the -SLAVE SYNC
  signal, but it is not used by the drive.

Spindle synchronization control lines

  --------------------------------------------------------------
  | -MASTER SYNC   |   -SLAVE SYNC    |    Functional Mode     |
  |----------------|------------------|------------------------|
  | released       |   receive        |    Slave sync          |
  | drive          |   drive          |    Master sync         |
  | drive          |   receive        |    Master sync control |
  | released       |   receive        |    non sync            |
  --------------------------------------------------------------

Spindle synchronization functional modes

Drive synchronization with offset

The drive electronics receives the master index and creates the
delayed slave index from the drive INDEX.  The delay is determined
by using the SCSI mode select command, rigid disk drive geometry
parameters.  A rotational offset of 0/256 of a revolution up
to 255/256 of a revolution may be selected in increments 1/256 of
a revolution.  Reference the Ultrastar 2XP interface specification
for further information on the rotational offset of synchronized
spindles.


     Power up                        Start-up sequence
    <><><><><><>
    Reset init                                          Complete 
    and test of   Spin-up  Init serve Upload code BATS2 reassign 
    controller                                                   
                                                                 
                                                                 
    Enable SCSI                                                  
     bus                                                         
    
                                                                     
                                                                     
    Power on     Auto start function enabled or                        
                 start unit command issued at this time.               
                                                                       
                                                                       
                              File ready to accept read & write commands



Synchronization time

The SCSI mode select command is used to select the spindle sync
mode.  It could take up to 5.0 seconds (2.5 sec nominally) to
synchronize the slave drive to the master drive.  While the slave
drive is synchronizing to the master, it will not be able to
read and write data.  Once synchronized, the drive will maintain
plus/minus 20 usec synchronization tolerance.


Spindle synchronization bus

The spindle synchronization bus consists of the two signal lines,
-MASTER SYNC and -SLAVE SYNC. which show the location of these signal
lines on the option jumper block.  One potential configuration of this
bus for drives that are to be used in a synchronized mode is shown
in the following figure.  This example required the -SLAVE SYNC
lines to be daisy chained together.


Termination

Bus termination of the -MASTER SYNC and -SLAVE SYNC signals is
internal to the drive.  These two signals each have a 5 K ohm
pullup to the +5 volt supply.  A maximum of 30 drives can have
their -MASTER SYNC or -SLAVE SYNC lines daisy chained together.
Violating this could damage the master drive line driver on
the -MASTER SYNC and/or -SLAVE SYNC line.

It is the using system's responsibility to provide the cable to
connect to the -SLAVE SYNC lines, and the -MASTER SYNC lines where
needed, of the synchronized drives.


Bus characteristics

1)maximum bus length = 6 meters
2)2 micro-second negative active pulse (when sourced by drive)
3)minimum of 1 micro-second negative active pulse when
  externally sourced
4)0.8 volts = max valid low input
5)2.2 volts = min valid high input
6)0.4 volts = low output
7)Vcc volts = high output
8)60 milli-amps = maximum output low level sink current

The driver used for these two signal lines is a tri-state buffer.

-SLAVE SYNC input timing requirements

If the input to -SLAVE SYNC is supplied by an external source other
than a Ultrastar 2XP drive, the period of input signal must be 8.333
msec with a tolerance of +/-.025%.


Mechanical specifications
-------------------------

Weight

Approximately 1.0 pounds (0.46 kilograms)

Dimensions    Inches    S.I. Metric
----------    ------    -----------
Height        1.00 in   25.4 mm
Width         4.00 in   101.6 mm
Depth         5.75 in   146.5 mm


Clearances

For proper cooling it is suggested that a clearance of 7 mm be
provided under the drive and on top of the drive.


Mounting

Refer to Ultrastar 2XP hardware/functional specification 'drive
mounting guidelines' for more details on how to mount the drive.

The drive can be mounted with any surface facing down.  The drive
has both side and bottom mounting holes.  Refer to the diagrams below
for the location of these mounting holes for each configuration.

The maximum allowable penetration of the mounting screws is 3.8 mm.
Screws longer than 3.8 mm may cause permanent damage to the drive.

The recommended torque to be applied to the mounting screws is 0.8
Newton meters +/-0.2 Newton meters.

Grounding requirements of the disk enclosure

The disk enclosure is at power supply ground potential.  It is
allowable for the user mounting scheme to common the disk enclosure
to frame ground potential or to leave it isolated from frame ground.

The drives mounting frame must be within +/-150 millivolts of the
drives power supply ground.  At no time should more than 35 milliamps
of current (0 to 100 Mhz) be injected into the disk enclosure.


Temperature measurements

The following is a list of measurement points and their temperature
(maximum and reliability).  Maximum temperature must not be exceeded
at the worst case drive and system operating conditions with the drive
randomly seeking, reading, and writing.  Reliability temperatures must
not be exceeded at the nominal drive and system operating conditions
with the drive randomly seeking, reading and writing.


Maximum and reliable operating temperature limits

                             Maximum           Optimum
Disk enclosure top           149 F (65 C)      122 F (50 C)
Disk enclosure bottom        149 F (65 C)      122 F (50 C)
Channel module (1)           194 F (90 C)      176 F (80 C)
SCSI module                  176 F (80 C)      140 F (60 C)
Microprocessor module        203 F (95 C)      167 F (75 C)
Controller module            212 F (100 C)     167 F (75 C)
Spindle motor
 driver module               194 F (90 C)      176 F (80 C)
Voice call driver            221 F (105 C)     176 F (80 C)

Note: Operating the file above the maximum temperatures may cause
      permanent damage.  For continuous read applications the channel
      module will run at higher temperatures and will require
      additional coolling.

Note: The diagrams below define where measurements should be made.
      Showing where the modules are located on the bottom side of the
      card and the measurement locations on the bottom or top of the
      casing. There must be sufficient air flow through the drive so
      that the casing and module temperature limits defined above are
      not exceeded.


Module temperature measurement notes:

 Center on the top surface of the module
 If copper tape is used to attache temperature sensors, it should be
 no larger than 6 mm square.


                                                   Bezel (optional)
                             (6x) 6-32 UNC-2B          
                                                      
      ¿
                                                 Ĵ  25.2 +/-0.5
    Ĵ                                                    .
            o        o                    o    
     6.35 +/-0.5
                     .........60 +/-0.2.........16
                                                +/-
             .............101.6 +/-0.2..........0.4
                                                     
    ..................146 +/-0.5.....................
                                                      4.83


Location of side mounting holes


                        44.45 +/-0.2 ---60.33 +/-0.4--- 3.18 
                                                       +/-0.3
       ¿
      .   Ŀ         o                 o                .
      .       Ŀ   Ŀ Ŀ      ڿ      Ŀ   .    .
      .                      Ŀ             .    .
      .           Ŀ                     .    .
      .    Ŀ                   Ŀ               .    .
      .                                     .  104.14
      .      Ŀ        Ŀ    .    .
   101.6              Ŀ                  o   .    .
    +/-                                           95.24 +/-0.2
    0.5                                            .    .
      .                                      .    .
      .                                      Bezel.
      .    Ŀ                                .    .
      .             o                    o            .
       
                                                         ||-4.83




           Ŀ
                      o                   o  ĴĴ 
                                              ĴĴ 
                                               \Ĵ
                                                        
                                                        
                                                        
           Ĵ
           Ĵ----
                                                        .
                                                        .
                                                       41.86
                                                        .
                                                        .
                      o                   o            .
           ----
                                Disk Enclosure|Top        |
                                              |...58.53...|



                        Spindle motor driver module
                          
                             ..........89.7.............
           
          Ŀ         o           Ŀo Ŀ                 .
              Ŀ   Ŀ Ŀ       Ŀ        .
                         Ŀ  Ŀ       ó      38.5
                  Ŀ                 ó        .
           Ŀ                    Ŀ      ó        .
                              Control       ó        .
             Ŀ         module     ٳ        .
                     ͳ 
                     ͳͳ             VCD
                     ͳ        module
                  Ŀ           Ŀ  
                                               Channel
           Ŀ               Ŀ        module
                   o          o   
           ͳͳͳ
                       Disk Enclosure Bottom   
                                               
            SCSI module                         Microprocessor

