@echo off
rem
rem ZAP1024: Patch DOS files to support more than 1024 cylinders
rem
echo.
echo ***********************************************************
echo WARNING: Do NOT use this procedure unless you have read and
echo fully understood both "GT1024.DOC" and "READ1024.ME". The
echo author cannot guarantee that this procedure will work on
echo any particular system!
echo ***********************************************************
echo.
echo You must have a formatted system diskette in drive "A".
echo Press Ctrl-Break if you wish to terminate. Otherwise,
pause
if not exist A:FDISK.EXE goto :nofdisk

rem ---------------------------------------------------------------------
rem			Step 1: Make IO.SYS "visible"
rem ---------------------------------------------------------------------

echo.
echo Step 1: Making IO.SYS "visible" ...
echo.
attrib -s -h -r A:IO.SYS
if not exist A:IO.SYS goto :noiosys

rem ---------------------------------------------------------------------
rem	     Step 2: Verify the contents of IO.SYS and FDISK.EXE
rem ---------------------------------------------------------------------

echo.
echo Step 2: Verify the contents of IO.SYS and FDISK.EXE ...
echo.
verifile A:IO.SYS /Q <IOSYS.VER
if errorlevel 1 goto :vererr1
verifile A:FDISK.EXE /Q <FDISK.VER
if errorlevel 1 goto :vererr1

rem ---------------------------------------------------------------------
rem		    Step 3: Modify IO.SYS and FDISK.EXE
rem ---------------------------------------------------------------------

echo.
echo Step 3: Modify IO.SYS and FDISK.EXE
echo.
echo debug a:IO.SYS
debug A:IO.SYS <IOSYS.DBG
rename A:FDISK.EXE *.XXX
echo debug a:FDISK.EXE
debug A:FDISK.XXX <FDISK.DBG
rename A:FDISK.XXX *.EXE

rem ---------------------------------------------------------------------
rem	  Step 4: Verify that the modifications were made properly
rem ---------------------------------------------------------------------

echo.
echo Step 4: Verify that the modifications were made properly
echo.
verifile A:IO.SYS /Q <IOSYS.CHK
if errorlevel 1 goto :zaperr1
verifile A:FDISK.EXE /Q <FDISK.CHK
if errorlevel 1 goto :zaperr1

rem ---------------------------------------------------------------------
rem			 Step 5: Hide IO.SYS again
rem ---------------------------------------------------------------------

echo.
echo Step 5: Hide IO.SYS again
echo.
attrib +s +h +r A:IO.SYS

echo.
echo **************************************************************
echo Files A:IO.SYS and A:FDISK.EXE have been updated successfully!
echo **************************************************************
goto :end

rem
rem Come here if error verifying
rem
:vererr1
echo.
echo *************************************************************
echo Files A:IO.SYS and A:FDISK.EXE do not match what is expected!
echo Your system cannot be patched!
echo *************************************************************
goto :end

rem
rem Come here if unable to update
rem
:zaperr1
echo.
echo *****************************************
echo Unable to DEBUG A:IO.SYS and A:FDISK.EXE!
echo Check your files and retry!
echo *****************************************
goto :end

rem
rem Come here if unable to find IO.SYS
rem
:noiosys
echo.
echo *********************************
echo Unable to find or modify A:IO.SYS
echo *********************************
goto :end

rem
rem Come here if unable to find FDISK.EXE
rem
:nofdisk
echo.
echo **************************
echo Unable to find A:FDISK.EXE
echo **************************

:end
