; this file has some fast asmbly routines in it
; the routines use the C calling method for a small model
;
;

.286c					    ; 80286 AT code
DOSSEG					    ; use dos segments
.MODEL LARGE
.CODE

; _WR_BLOCK	 WILL WRITE ONE 512 BLOCK OF DATA EVERY TIME A DRQ IS THERE
;    INPUT :	 [BP+4]   POINTER TO START OF BUFFER
;    OUTPUT:	  NONE



	    PUBLIC   _WR_BLOCK
_WR_BLOCK   PROC     FAR
	    ENTER    2,0
	    PUSHA
	    PUSH     DS

	    MOV      BX,[BP+6]		    ; POINTER TO BUFFER offset
	    MOV      AX,[BP+8]		    ;POINTER SEGMENT
	    MOV      DS,AX
	    MOV      DX,1F7H		    ;COMMAND REG
	    MOV      AL,30H
	    OUT      DX,AL		    ;SEND WRITE COMMAND

wrb_10:     NOP 			    ;DELAY
	    JMP      SHORT $+2
	    NOP 			    ;DELAY
	    JMP      SHORT $+2
	    NOP 			    ;DELAY
	    JMP      SHORT $+2
	    NOP 			    ;DELAY
	    JMP      SHORT $+2
	    NOP 			    ;DELAY
	    JMP      SHORT $+2
	    NOP 			    ;DELAY
	    JMP      SHORT $+2
	    NOP 			    ;DELAY

BUSY_LP:
	    IN	     AL,DX		    ;GET STATUS
	    JMP      SHORT $+2
	    NOP
	    AND      AL,80H		    ;MASK ALL BUT BUSY
	    JNZ      BUSY_LP

	    IN	     AL,DX		    ;CHECK FOR DRQ
	    AND      AL,8
	    JZ	     ALL_DONE		    ;SKIP, IF NO DRQ

	    MOV      DX,01F0H		    ;DATA BUFFER PORT
	    MOV      CX,256		    ;1 SECTOR
	    CLD

	    MOV      SI,BX		    ;SERVICE CONTROLLER BUFFER
	    REP      OUTSW		    ;ELSE, WRITE COMMAND
	    MOV      DX,1F7H		    ;POINT TO STATUS REG
	    JMP      wrb_10


ALL_DONE:
	    IN	     AL,DX		    ;CHECK FOR ERROR
	    AND      AL,05H		    ; CHECK FOR ERROR OR ECC
	    JNZ      DISK_ERR		    ;JMP, IF ERROR

	    CLC
	    POP      DS
	    POPA
	    LEAVE
	    RET

DISK_ERR:
	    STC
	    POP      DS
	    POPA
	    LEAVE
	    RET
_WR_BLOCK   ENDP



	    END

