#include "scancode.h"
#include "defs.h"
#include <dos.h>

extern int redirection;
extern union REGS inregs, outregs;
unsigned char get_input();

/*********************************************/
/*					     */
/* get_dec(row,col,max_didit,defalt)	     */
/*					     */
/*  input:				     */
/*    row	: vetical location	     */
/*    col	: left	most digit location  */
/*    max_digit : max number of digits	     */
/*    defalt	: default value if only <CR> */
/*					     */
/*  out put:				     */
/*    integer vlue of input		     */
/*					     */
/*********************************************/

int get_dec(row,col,max_digit,defalt)

int row,col,max_digit,defalt;

{					    /* start of get_dec */
   unsigned char in_char;
   unsigned char in_arry[6];
   int	power,first_time,done,i,in_val,arry_ptr,t_col,t_defalt;

   t_defalt = defalt;
   power=10;
   for(i=0;i<=max_digit;++i)		    /* setup arry wit defalt */
   {
     in_arry[i] = t_defalt % power;
     t_defalt = t_defalt / power;
   }
   supress_zero(row,col,max_digit,in_arry); /* print arry */
   t_col = col+max_digit;
   arry_ptr =0;
   first_time = TRUE;
   done = FALSE;
   while(!done)
   {					    /* start of while */
     curs(row,t_col);
     in_char = (unsigned char)get_input(redirection);		     /* get input from stand input */
     if(('0' <= in_char) AND (in_char <= '9'))
     {					    /* if valid input */
       if(first_time)
       {
	  for(i=0;i<=max_digit;++i) in_arry[i] = 0; /* clear arry */
       }
       for(i=max_digit;i>=arry_ptr;--i)
	 in_arry[i+1]=in_arry[i];
       in_arry[arry_ptr] = in_char - 0x30;  /* get dec value */
       first_time = FALSE;
       supress_zero(row,col,max_digit,in_arry); /* print arry */
     }
     else				    /* if not a number */
      { 				    /* start of else not a number*/
       switch(in_char)
	{				    /* start of switch */
	   case BK_SP	:		    /* if back space */
			  if(arry_ptr<max_digit)
			  {
			     for(i=0;i<=max_digit;++i)	    /* shift arry by 1*/
				in_arry[i]=in_arry[i+1];
			     in_arry[max_digit]= 0;
			     supress_zero(row,col,max_digit,in_arry); /* print arry */
			  }
			  break;
	   case CURLF	:		     /* if left arrow */
			  if(arry_ptr<max_digit)
			  {
			     ++arry_ptr;
			     --t_col;
			  }
			  break;
	   case CURRT	:		     /* if right arrow */
			  if(arry_ptr>0)   /* if valid position */
			  {
			     --arry_ptr;
			     ++t_col;
			  }
			  break;
	   case INSERT	:		     /* if insert key */
			  break;
	   case DELETE	:		     /* if delete key */
			  if(arry_ptr<max_digit)
			  {
			     for(i=arry_ptr;i<=max_digit;++i)	   /* shift arry by 1*/
				in_arry[i]=in_arry[i+1];
			     in_arry[max_digit]= 0;
			     supress_zero(row,col,max_digit,in_arry); /* print arry */
			  }
			  break;
	   case CRG_RTN :		     /* if <CR> key */
			  done = TRUE;
			  break;
	   default	:
			  BELL;
	}				    /* end of switch */
      } 				    /* end of else not a number*/
   }					    /* end of while */
   if(first_time) in_val = defalt;	    /* if no input */
   else 				    /* if valid input */
   {					    /* change array into int */
     in_val= 0;
     power = 1;
     for(i=0;i<=max_digit-1;++i)
     {
       in_val += in_arry[i] * power;
       power  *= 10;
     }
   }					    /* end of if else */
 return in_val;
 }					    /* end of get_dec */

/*********************************************/
/*					     */
/* get_dec2(row,col,max_didit,answ,special)  */
/*					     */
/*  input:				     */
/*    row	: vetical location	     */
/*    col	: left	most digit location  */
/*    max_digit : max number of digits	     */
/*    answ	: address of the answer      */
/*    special	: special char to check for  */
/*					     */
/*  out put:				     */
/*     0	: special char not found     */
/*     1	: <CR> with no in put	     */
/*     2	: special char found	     */
/*********************************************/

int get_dec2(row,col,max_digit,in_val,special)

int row,col,max_digit;
int *in_val;
unsigned char special;

{
				      /* start of get_dec */
   unsigned char in_char;
   unsigned char in_arry[6];
   int	power,first_time,done,i,arry_ptr,t_col,is_special;

   for(i=0;i<=max_digit;++i)
   {
      in_arry[i] = 0;			    /* clear arry */
      curs(row,col+i);printf(" ");          /* clear space */
   }
   is_special = 0;
   arry_ptr   = 0;
   first_time = TRUE;
   t_col      = col + max_digit;
   done       = FALSE;
   while(!done)
   {					    /* start of while */
     curs(row,t_col);
     in_char = (unsigned char)get_input(redirection);  /* get input from stand input */
     if(('0' <= in_char) AND (in_char <= '9'))
     {					    /* if valid input */
       for(i=max_digit;i>=arry_ptr;--i)
	 in_arry[i+1]=in_arry[i];
       in_arry[arry_ptr] = in_char - 0x30;  /* get dec value */
       first_time = FALSE;
       supress_zero(row,col,max_digit,in_arry); /* print arry */
     }
     else				    /* if not a number */
      { 				    /* start of else not a number*/
       switch(in_char)
	{				    /* start of switch */
	   case BK_SP	:		    /* if back space */
			  if((arry_ptr<max_digit) AND (!first_time))
			  {
			     for(i=0;i<=max_digit;++i)	    /* shift arry by 1*/
				in_arry[i]=in_arry[i+1];
			     in_arry[max_digit]= 0;
			     supress_zero(row,col,max_digit,in_arry); /* print arry */
			  }
			  break;
	   case CURLF	:		     /* if left arrow */
			  if((arry_ptr<max_digit) AND (!first_time))
			  {
			     ++arry_ptr;
			     --t_col;
			  }
			  break;
	   case CURRT	:		     /* if right arrow */
			  if((arry_ptr>0) AND (!first_time))   /* if valid position */
			  {
			     --arry_ptr;
			     ++t_col;
			  }
			  break;
	   case INSERT	:		     /* if insert key */
			  break;
	   case DELETE	:		     /* if delete key */
			  if((arry_ptr<max_digit) AND (!first_time))
			  {
			     for(i=arry_ptr;i<=max_digit;++i)	   /* shift arry by 1*/
				in_arry[i]=in_arry[i+1];
			     supress_zero(row,col,max_digit,in_arry); /* print arry */
			  }
			  break;
	   case CRG_RTN :		     /* if <CR> key */
			  done = TRUE;
			  break;
	   default	:
			  if(in_char EQL special)
			  {
			     is_special = 2;
			     done = TRUE;
			  }
			  else BELL;
	}				    /* end of switch */
      } 				    /* end of else not a number*/
   }					    /* end of while */
   *in_val= 0;
   if(first_time AND special)
     is_special = 1;			    /* if no input */
   else 				    /* if valid input */
   {					    /* change array into int */
     power = 1;
     for(i=0;i<=max_digit-1;++i)
     {
       *in_val += in_arry[i] * power;
       power  *= 10;
     }
   }					    /* end of if else */
 return is_special;
 }					    /* end of get_dec */

/*********************************************/
/*					     */
/* suppress_zero(row,col,max_didit,in_arry)  */
/*					     */
/*  input:				     */
/*    row	: vetical location	     */
/*    col	: left	most digit location  */
/*    max_digit : max number of digits	     */
/*    in_arry	: arry to be printed	     */
/*					     */
/*  print in_arry supressing leading zeros   */
/*					     */
/*********************************************/


supress_zero(row,col,max_digit,in_arry)
unsigned char in_arry[];
int row,col,max_digit;



{					    /* start of supress_zero */
   int i,none_zero;

   none_zero = FALSE;
   for(i=max_digit-1;i>=0;--i)		    /* print arry */
   {
      if((in_arry[i] != 0) OR none_zero)    /* check if zero */
      {
	 none_zero = TRUE;
	 curs(row,col-i+max_digit);
	 printf("%d",in_arry[i]);
      } 				   /* end if not zero or none_zero */
      else
      {
	 curs(row,col-i+max_digit);
	 printf(" ");
      }
      if(i EQL 0)
      {
	 curs(row,col-i+max_digit);
	 printf("%d",in_arry[i]);
      } 				   /* end if not zero or none_zero */
   }					    /* end for i */
}					    /* end suppress_zero */


/*****************************************************/
/*						     */
/* get_input(redirection)			     */
/*						     */
/*  input:					     */
/*     redirection :  0 = get input from key board   */
/*		      1 = get input from file	     */
/*						     */
/*						     */
/*  output: input from key board or file	     */
/*						     */
/*****************************************************/

unsigned char get_input(redirection)

int redirection;

{

if (redirection)			    /* where to get data ? */
{					    /* get data from file */
  return 0;
}

else					    /* get data from keyboard */
{
    inregs.h.ah = 0x08; 		    /* set up interupt regs */
    intdos(&inregs,&outregs);		    /* do a dos intr #0x21 */
    if(outregs.h.al EQL 0)
    {					    /* if extended key board */
       inregs.h.ah = 0x08;		    /* set up interupt regs */
       intdos(&inregs,&outregs);	    /* do a dos intr #0x21 */
       return(unsigned char)(outregs.h.al + 0x80);
    }
    return  (unsigned char)outregs.h.al;    /* return Ax low byte */
}
}


/*****************************************************/
/*						     */
/*  getyn(redirection)				     */
/*						     */
/*  input  :					     */
/*     redirection :  0 = get input from key board   */
/*		      1 = get input from file	     */
/*						     */
/*						     */
/*  output:	       0 = n,N			     */
/*		       1 = y,Y			     */
/*						     */
/* this routine will get  y/n responce from input    */
/*						     */
/*****************************************************/

getyn(redirection)

int redirection;

{					    /* start of getyn */
   int valid;
   unsigned char temp;

   while(TRUE)
   {					    /* start of while */
      temp = get_input(redirection);
      temp = toupper(temp);
      switch(temp)
      { 				    /* start of switch */
	 case 'Y' : return(TRUE);
	 case 'N' : return(FALSE);
	 defalt   : BELL;
      } 				    /* end of switch */
   }					    /* end of while */
}					    /* end of getyn */

