screen_base	= 0x0B0000	// Display Adapter RAM Base Address
screen_offs	= 160 - 8	// Screen Offset for upper right hand corner

delay_count	= 2000000	// Delay before moving *

iobase=	  0xC2000000		// Base address for i860 I/O Space

FLUSH_P=        0xFFFE0000-32

	.atmp r31
	.text

ld$start::
	mov		iobase,		r15
	mov		0x01,		r16
	st.b		r16,		0x80(r15)	// Store 1 to port 80

	// initialize control reg
	// leave all ints disable

	st.c    	r0,		psr
	st.c    	r0,		fsr
	ld.c    	fir,		r0

	mov		0x02,		r16
	st.b		r16,		0x80(r15)	// Store 2 to port 80

	// clear pipeline

	pfadd.ss        f0,	f0,	f0
	pfadd.ss        f0,	f0,	f0
	pfadd.ss        f0,	f0,	f0
	pfadd.ss        f0,	f0,	f0
	pfadd.ss        f0,	f0,	f0
	pfadd.ss        f0,	f0,	f0

	mov		0x03,		r16
	st.b		r16,		0x80(r15)	// Store 3 to port 80

	call		flush_cache		// make sure we get a miss
	nop

	mov		0x04,		r16
	st.b		r16,		0x80(r15)	// Store 4 to port 80

	mov		r0,		r2
	mov		screen_base,	r18

	mov		0x05,		r16
	st.b		r16,		0x80(r15)	// Store 5 to port 80

loop:
	call		delay
	nop

	mov		0x072A,		r16
	st.b		r16,		0x80(r15)	// Store 2A to port 80
	st.s		r16,		screen_offs(r18)
	mov		0x0720,		r16
	st.s		r16,		screen_offs+2(r18)

	call		delay
	nop

	mov		0x0720,		r16
	st.b		r16,		0x80(r15)	// Store 20 to port 80
	st.s		r16,		screen_offs(r18)
	mov		0x072A,		r16
	st.s		r16,		screen_offs+2(r18)

	br		loop

	nop


delay::
	mov		-1,		r5
	mov		delay_count,	r6
	bla		r5,	r6,	delay_loop
	nop

delay_loop:
	bla		r5,	r6,	delay_loop
	nop

	bri		r1
	nop


//The following cache flush procedure is from the 860TM programmer's reference
//manual.  Please reference the manual for additional information.
	
flush_cache::
	mov		r1,	r2
	
//	rw=r24,	rx=r25,	ry=r26,	rz=r27

	ld.c    	dirbase,	r27
	or      	0x800,	r27,	r27
	adds    	-1,	r0,	r25
	call    	D_FLUSH
	st.c    	r27,	dirbase
	or      	0x900,	r27,	r27
	call    	D_FLUSH
	st.c    	r27,	dirbase
	xor     	0x900,	r27,	r27

	mov		r2,		r1
	bri     	r1
	st.c    	r27,		dirbase

D_FLUSH::
	or      	l%FLUSH_P,	r0,	r24
	orh     	h%FLUSH_P,	r24,	r24
	or      	127,	r0,	r26
	ld.l    	32(r24),	r31
	shl		0,	r31,	r31
	bla     	r25,	r26,	D_FLUSH_LOOP
	nop

	.align      32

D_FLUSH_LOOP::
	ixfr		r0,	f0
	bla     	r25,	r26,	D_FLUSH_LOOP
	flush   	32(r24)++
	ixfr		r0,	f0

	bri		r1
	ld.l		-512(r24),	r0

	nop
	nop
	nop
	nop
	nop
	nop

.end

	call    	D_FLUSH
	st.c    	r27,	dirbase
	xor     	0x900,	r27,	r27

	mov		r2,		r