/*****************************************************************************
* Project:	Server Utilization Histogram Program.
* File:		CPU-UTIL.C
* Author:       Ian Schets, CBS, Netherlands.
* Date:         25-10-91

* This program has been derived from TOTAL.C
* Author:	Matt Hagen, Novell, Inc.
* Date:		91-05-22
*****************************************************************************/

#include <nwtypes.h>
#include <stdio.h>
#include <ss.h>
#include <conio.h>
#include <process.h>
#include <nwenvrn.h>

#define COL_FIRST 0
#define ROW_FIRST 0
#define ROW_COUNT 25
#define COL_COUNT 77
#define UPDATE_INTERVAL 2000
/*****************************************************************************
* main
*****************************************************************************/

main()
{
	int c,x,y;
	int count;
	WORD length;
        long util1,util2,maxUtil,utilPct;
	struct StatStructure *cStat;
	struct StatStructure *tStat;
        char servername[48];
        int  util [COL_COUNT];


	HideInputCursor();

	cStat=GetStatList();
	count=GetStatCount();
/*	length=GetStatLength(); */

	for(c=0 ; c < COL_COUNT; util[c++]=0);

        GetFileServerName ( 0 , servername );

	printf("%s %s",&servername, &cStat->description);

        length=wherex();


        gotoxy ( 1,24 );printf("___");
        gotoxy ( 1,23 );printf(" 20");
        gotoxy ( 1,21 );printf(" 40");
        gotoxy ( 1,19 );printf(" 60");
        gotoxy ( 1,17 );printf(" 80");
        gotoxy ( 1,15 );printf("100");

        gotoxy ( 77,24 );printf("___");
        gotoxy ( 77,23 );printf(" 20");
        gotoxy ( 77,21 );printf(" 40");
        gotoxy ( 77,19 );printf(" 60");
        gotoxy ( 77,17 );printf(" 80");
        gotoxy ( 77,15 );printf("100");

        gotoxy ( 35,24 );printf("initializing");

        /* initialize utilization variables */
        maxUtil=1;
        util2=cStat->loTotal;
	delay( UPDATE_INTERVAL );

	while(TRUE)
	{

          /* Utilization calculation from Novell app. note: */
          /* "Netware v3.x Operating System Statistics Exposed" */

                tStat=cStat;  /* util. is first in link */


                util1=util2;
                util2=tStat->loTotal;

                if ( maxUtil< (util2-util1) )
                         maxUtil=util2-util1;

                utilPct=100-(100*(util2-util1)/maxUtil);

		gotoxy(COL_FIRST,ROW_FIRST);
		gotoxy(4+length,wherey());
		printf("%10u\n",utilPct);

           /* scroll the util values array */

	        for (c=0 ; c < (COL_COUNT-1) ; util[c]=util [c+1],c++ );

          /*  add the new value */
                util [COL_COUNT-1]= (int)( (utilPct+5) / 10) ;

                /* display the bar graph */

                for (x=4 ; x < COL_COUNT; x++ )

                {

                   for(y=1 ; y <= util[x] ; y++ )
                   {
                     gotoxy (x,ROW_COUNT-y);
                     putch ('');
                   }

                   for( y= (util [x]+1) ; y <= util[x-1] ; y++ )
                   {
                     gotoxy (x,ROW_COUNT-y);
                     putch (' ');
                   }

                   if ( util [x]==0 )
                   {
                        gotoxy(x,ROW_COUNT-1);
                        putch('_');
                   }

                }

		delay( UPDATE_INTERVAL );

	}
}

/****************************************************************************/
/****************************************************************************/
