/************************************************************************
 *                                                                      *
 * showpass.c  - Shows PASSWORD.NDS info extracted by EXTRACT.EXE       *
 *                                                                      *
 * Programmer - Simple Nomad - Nomad Mobile Research Centre             *
 *                                                                      *
 *----------------------------------------------------------------------*
 *                                                                      *
 * 6/27/97     - Initial Revision                                       *
 *                                                                      *
 ************************************************************************/

/*
 * Send bugs to pandora@nmrc.org.
 *
 */

/*
 * Includes
 */
#include <stdio.h>
#include <stdlib.h>

/*
 * Typedefs for program
 */
typedef unsigned long uint32;
typedef unsigned int  uint16;
typedef unsigned char uint8;
typedef unsigned int  unicode;

/*
 * Global constants
 */
#define TRUE 1
#define FALSE 0

/*
 * Global variables
 */
FILE *fPassword;

/*
 * struct for PASSWORD
 */
typedef struct password
{
	uint32          selfOffset;	/* Offset in PASSWORD.NDS. If this is
					   the first record, it is 0x00000000
					   followed by 0x0000014e for the
					   second record, etc. */
	uint32		id;		/* Object ID from ENTRY */
	uint32		parentID;	/* Parent ID */
	uint32		objectID;	/* Object ID from Private Key */
	uint32		pwlen;		/* Password length of user account */
	uint8		hash[16];	/* One-way hash */
	uint8           userOU[40];     /* OU of User */
	uint8		userCN[258];    /* User common name */
} PASSWORD; /* size=334 */

PASSWORD pPassword;

/*
 * Dump unicode to screen. I dislike unicode a lot, but this routine
 * skips the 0x00's and only prints the parts that matter.
 */
void printUnicodeName(char *name, int j)
{
   int i;
   for (i=0;i<j;i++)
   {
     if (name[i]!=0) putchar(name[i]);
   }
}

/*
 * This routine counts the number of PASSWORD.NDS records and returns the
 * value. Return j-1 to adjust for extra zero count record.
 */
int countPasswordRecords(void)
{
   int j;
   uint32 k;
   ldiv_t calc;
   fseek(fPassword,334,SEEK_END);
   k=ftell(fPassword);
   calc=ldiv(k,334);
   j=calc.quot;
   return(j-1);
}

/*
 * This routine looks for a particular user. It is passed the total number
 * of users to look through and who to look for. If found, it is printed.
 * TRUE is returned if the user was found, FALSE if not found.
 */
int findEntryInPasswordFile(int j, char *account)
{
   int FOUND,i,k;
   FOUND=FALSE;

   rewind(fPassword);
   while(j!=0)
   {
     fread(&pPassword,334,1,fPassword);
     FOUND=TRUE;
     for (i=0;i<strlen(account);i++)
     {
       k=i*2+6;
       if (account[i]!=pPassword.userCN[k]) FOUND=FALSE;
     }
     if (FOUND==TRUE)
     {
       printUnicodeName(pPassword.userCN,258);
       printf(" ");
       printUnicodeName(pPassword.userOU,40);
       printf(" %08lx %d ",pPassword.objectID,pPassword.pwlen);
       for (i=0;i<16;i++) printf("%02x",pPassword.hash[i]);
       printf("\n");
       break;
     }
     j--;
   }
   fclose(fPassword);
   return(FOUND);
}

/*
 * Print some usage if needed....
 */
void printHelp(int j)
{
   printf("USAGE: showpass <options>\n\n");
   printf("  -h            This HELP screen\n");
   printf("  -u <username> Show the USER specified.\n");
   printf("                If no options given, all user accounts\n");
   printf("                will be shown.\n\n");
   printf("EXAMPLES:\n");
   printf("   showpass\n");
   printf("   showpass -u Admin\n\n");
   exit(j);
}



/*
 * Main prog...
 */
void main(int argc, char **argv)
{
   PASSWORD pPassword;
   int i,j,FOUND,SEARCH;
   char *account;
   ldiv_t calc;

   /* Hello... */
   printf("SHOWPASS - shows PASSWORD.NDS extracted using EXTRACT.EXE\n\n");
   printf("Simple Nomad - thegnome@nmrc.org\n");
   printf("http://www.nmrc.org\n");
   printf("1997 (c) Nomad Mobile Research Centre\n\n");

   /* process the command line */
   for (i=1 ; i<argc ; i++)
   {
      if (argv[i][0]=='-')
	 switch(argv[i][1])
	 {
	    case 'u':
	    case 'U':
	       if ((i+1>argc) || argv[i+1][0]=='-')
	       {
		  printf("No argument given for option -u\n");
		  exit(1);
	       }
	       sprintf(account,"%s",argv[i+1]);
	       SEARCH=TRUE;
	       break;
	    case 'h':
	    case 'H':
	    case '?':
	       printHelp(0);
	    default:
	       printf("Invalid option: %s\n", argv[i]);
	       printHelp(1);
	 }
   }

   /* Open password target file */
   fPassword=fopen("PASSWORD.NDS","rb");
   if (fPassword==NULL)
   {
      printf("Unable to open PASSWORD.NDS\n");
      exit(1);
   }

   j=countPasswordRecords();
   rewind(fPassword);

   /* if the -u option was not given, show all users */
   if (SEARCH!=TRUE)
   while (j!=0)
   {
     fread(&pPassword,334,1,fPassword);
     printUnicodeName(pPassword.userCN,258);
     printf(" ");
     printUnicodeName(pPassword.userOU,40);
     printf(" %08lx %d ",pPassword.objectID,pPassword.pwlen);
     for (i=0;i<16;i++) printf("%02x",pPassword.hash[i]);
     printf("\n");
     j--;
   }
   else /* otherwise show the user requested */
   {
     i=findEntryInPasswordFile(j,account);
     if (i==FALSE) printf("%s not found in password file.\n");
   }
   printf("\n");
   exit(0);
}



