/*
#include <stdio.h>
#include <stdlib.h>
*/
#include <mdl.h>
#include <msdefs.h>
#include <pltstrct.h>

/* MAXVDMINT = 2 ^22 - 1 */

#define MAXVDMINT 4194303
#define XORIG 
#define YORIG 28500

Private void ToVdmInteger
(
	long int        VdmInt,
	char            *VdmIntStr
)
{
	long int                c1,c2,c3,c4,i;

	i = 0 ;

	if ( VdmInt > MAXVDMINT ) VdmInt=MAXVDMINT;
	if ( VdmInt < -MAXVDMINT ) VdmInt=-MAXVDMINT;

	c1 = abs(VdmInt) >> 16;
	c2 = ( abs(VdmInt) >> 10 ) & 0x003f;
	c3 = ( abs(VdmInt)  >> 4 ) & 0x003f;
	c4 = abs(VdmInt) & 0x000f;

	if ( c1 ) {
	   VdmIntStr[i++] = c1 | 0x40 ;
	}

	if ( c1 || c2 ) {
	   VdmIntStr[i++] = c2 | 0x40 ;
	}
	if ( c1 || c2 || c3 ) {
	   VdmIntStr[i++] = c3 | 0x40 ;
	}

	if ( VdmInt < 0 ) {
	   VdmIntStr[i++] = c4 | 0x20 ;
	} else {
	   VdmIntStr[i++] = c4 | 0x30 ;
	}

	VdmIntStr[i] = 0x00 ;

}

Private void CANON_initialize
(
	void
)
{
	char    PlotString[100];

	plotStat->penPosition.x = 0L;
	plotStat->penPosition.y = 0L;
	plotStat->penIsDown     = FALSE;

/*      To ISO mode                                     */

	PlotString[0]   = 0x1b ;
	PlotString[1]   = '%';
	PlotString[2]   = '@';
	PlotString[3]   = 0x00;
	mdlPlot_writeCommand(PlotString, strlen(PlotString));



/*      To ISO mode                                     */

	PlotString[0]   = 0x1b ;
	PlotString[1]   = ';';

/*      Job start                                       */

	PlotString[2]   = 0x1b ;
	PlotString[3]   = 0x50 ;
	PlotString[4]   = '4' ;
	PlotString[5]   = '0' ;
	PlotString[6]   = 'J' ;
	PlotString[7]   = 'M' ;
	PlotString[8]   = 'S' ;
	PlotString[9]   = 0x1b ;
	PlotString[10]   = 0x5c ;

/*      Color mode                                       */

	PlotString[11]   = 0x1b ;
	PlotString[12]   = 0x5b ;
	PlotString[13]   = '1' ;
	PlotString[14]   = 0x22 ;
	PlotString[15]   = 0x70 ;

/*      Soft Reset                                       */

	PlotString[16]   = 0x1b ;
	PlotString[17]   = '<' ;

/*      Full paint memory mode                          */

	PlotString[18]   = 0x1b ;
	PlotString[19]   = 0x5b ;
	PlotString[20]   = '2' ;
	PlotString[21]   = '&' ;
	PlotString[22]   = 'z' ;


/*      Enter Vector Mode                               */

	PlotString[23]   = 0x1b ;
	PlotString[24]   = 0x5b ;
	PlotString[25]   = '0' ;
	PlotString[26]  = '&' ;
	PlotString[27]  = '}' ;

/*      Begin picture                                   */

	PlotString[28]  = 0x23 ;
	PlotString[29]  = 0x1e ;


/*      Color selection mode                            */

	PlotString[30]   = 0x21;
	PlotString[31]   = 0x31;
	PlotString[32]   = 0x30;
	PlotString[33]   = 0x1e;

/*      Scaling mode   1/100 mm scale factor 1          */

	PlotString[34]  = '!';
	PlotString[35]  = '0';
	PlotString[36]  = 0x22;
	PlotString[37]  = 0x00;

	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	ToVdmInteger( 1L, PlotString);

	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	PlotString[0]   = 0x1e;
	PlotString[1]   = 0x00;

	mdlPlot_writeCommand(PlotString, strlen(PlotString));

/*      Begin picture Body                      */

	PlotString[0]   = 0x24;
	PlotString[1]   = 0x1e;
	PlotString[2]   = 0x00;

	mdlPlot_writeCommand(PlotString, strlen(PlotString));

/*      User Origin transfer                            */

	PlotString[0]   = 0x7d;
	PlotString[1]   = 0x22;
	PlotString[2]   = 0x00;

	mdlPlot_writeCommand(PlotString, strlen(PlotString));
	
	ToVdmInteger( plotStat->plotSpec.user_off.h, PlotString);       
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	ToVdmInteger( plotStat->plotSpec.user_off.v, PlotString);       
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	PlotString[0]   = 0x1e;
	PlotString[1]   = 0x00;

	mdlPlot_writeCommand(PlotString, strlen(PlotString));
	
	CANON_pen_width( 1 );
	CANON_select_pen( 1 );


}

Private void CANON_finishup
(
	void
)
{

	char    PlotString[100];

/*      End Picture                                     */

	PlotString[0]   = 0x25;
	PlotString[1]   = 0x1e;
	PlotString[2]   = 0x00;

	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	PlotString[0]   = 0x7d;
	PlotString[1]   = 0x70;
	PlotString[2]   = 0x1e;

/*      Job end                                        */

	PlotString[3]   = 0x1b;
	PlotString[4]   = 0x50;
	PlotString[5]   = '0';
	PlotString[6]   = 'J';
	PlotString[7]   = 0x1b;
	PlotString[8]   = 0x5c;
	PlotString[9]   = 0x00;
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

/*      Form Feed                                       */

/*      PlotString[0]   = 0x0c;                         */
	
/*      Reset printer                                   */

/*
	PlotString[1]   = 0x1b;
	PlotString[2]   = 'c';

	PlotString[3]   = 0x00;
*/
	
	PlotString[1]   = 0x00;
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

}

Private void CANON_move
(
Point2d         *pnt
)
{
	plotStat->penPosition.x = pnt->x;
	plotStat->penPosition.y = pnt->y;
	plotStat->penIsDown     = FALSE;
}

Private void CANON_draw
(
PlotDrawParam   *param
)
{
	char            PlotString[100];
	int             i;
	long int        x0,y0;
	Point2d         *points;

/*      Begin polyline                                  */

	mdlPlot_writeCommand("1",1);

/*      First point                                     */

	points = param->pts;

	x0 = param->pts->x;

	ToVdmInteger(param->pts->x,PlotString);
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	y0 = param->pts->y;

	ToVdmInteger( YORIG - param->pts->y ,PlotString);
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	points++;

	for ( i = 0 ; i < ( param->numPts - 1 ) ; points++, i++ ) {
	


		ToVdmInteger(points->x - x0,PlotString);
		mdlPlot_writeCommand(PlotString, strlen(PlotString));

		ToVdmInteger(y0 - points->y ,PlotString);
		mdlPlot_writeCommand(PlotString, strlen(PlotString));

		x0 = points->x;
		y0 = points->y;
				

	}
	
		PlotString[0]   = 0x1f;
		PlotString[1]   = 0x00;

		mdlPlot_writeCommand(PlotString, strlen(PlotString));

		PlotString[0]   = 0x1e;
		PlotString[1]   = 0x00;

		mdlPlot_writeCommand(PlotString, strlen(PlotString));

		plotStat->penPosition.x = points->x;
		plotStat->penPosition.y = points->y;


}

Private void CANON_raise
(
)
{
	plotStat->penIsDown = FALSE;
}

Private void CANON_pen_width
(
int     pen_width
)
{
	char    PlotString[100];
	
	PlotString[0] = 0x46;
	PlotString[1] = 0x31;

	PlotString[2] = 0x21;

	switch ( pen_width ) {
		case 1: PlotString[2] = 0x21;
		break;
		case 2: PlotString[2] = 0x22;
		break;
		case 3: PlotString[2] = 0x23;
		break;
		case 4: PlotString[2] = 0x24;
		break;
	}       
	
	PlotString[3] = 0x1e;
	PlotString[4] = 0x00;
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	plotStat->penIsDown = FALSE;
}

Private void CANON_select_pen
(
int     pen_num
)
{
	char    PlotString[100];
	
	PlotString[0] = 0x47;

	switch ( pen_num ) {
		case 1: PlotString[1] = '0';
		break;
		case 2: PlotString[1] = '1';
		break;
		case 3: PlotString[1] = '2';
		break;
		case 4: PlotString[1] = '3';
		break;
		case 5: PlotString[1] = '4';
		break;
		case 6: PlotString[1] = '5';
		break;
		case 7: PlotString[1] = '6';
		break;
		case 8: PlotString[1] = '7';
		break;
	}       
	PlotString[2] = 0x1E;
	PlotString[3] = 0x00;
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	plotStat->penChart.using_pen = pen_num;

	plotStat->penIsDown = FALSE;
}

/*
Private void CANON_select_pen
(
int     pen_num
)
{
	char    PlotString[100];
	
	PlotString[0] = 0x1b;
	PlotString[1] = 0x5b;

	PlotString[2] = '0';
	PlotString[3] = ';';

	switch ( pen_num ) {
		case 1: PlotString[4] = '0';
		break;
		case 2: PlotString[4] = '1';
		break;
		case 3: PlotString[4] = '2';
		break;
		case 4: PlotString[4] = '3';
		break;
		case 5: PlotString[4] = '4';
		break;
		case 6: PlotString[4] = '5';
		break;
		case 7: PlotString[4] = '6';
		break;
		case 8: PlotString[4] = '7';
		break;
	}       
	PlotString[5] = 0x25;
	PlotString[6] = 0x70;
	PlotString[7] = 0x00;
	mdlPlot_writeCommand(PlotString, strlen(PlotString));

	plotStat->penChart.using_pen = pen_num;

	plotStat->penIsDown = FALSE;
}

*/
Plot_functions CANON_functions =
	{
	CANON_initialize,       /* plotter initialization       */
	CANON_finishup,         /* plotting completion routine  */
	NULL,                   /* text function                */
	NULL,                   /* border text                  */
	CANON_select_pen,       /* select pen                   */
	NULL,                   /* select line type             */
	CANON_move,             /* pen up move                  */
	CANON_draw,             /* pen down draw                */
	CANON_raise,            /* raise pen                    */
	CANON_pen_width,        /* set pen width                */
	NULL,                   /* arc / ellipse                */
	NULL,                   /* raster start element         */
	NULL,                   /* raster finish element        */
	NULL,                   /* raster scan line             */
	NULL,                   /* set clip                     */
	NULL                    /* plot filled shapes           */
	};



#if defined (mdl)

Public int main

(
int             argc,
char            **argv
)
{

	plotStat->plotFuncs = CANON_functions;
	mdlSystem_userAbortEnable (FALSE);

}
#endif
