/*
   File:         lj4disp.c   
   Description:  Send display message to HP4 Printer.
   Author:       Larry Tanner
   Date Written: 2/21/94

   rev 2.0  09/26/94
    revision by:    Jeff Steinmetz of Urge Productions
                    jeffsteinm@aol.com

    Added printer error routine.  Now if printer error occurs,
    it will abort the program, instead of asking Abort, Retry, Fail.
    This will allow you to put it in your autoexec.bat file,
    and it will not pause if your printer is turned off.
    Of course it will not program your HPL4 if this is the case,
    but at least your AUTOEXEC.BAT will continue unattended.

*/

#include <stdio.h>               /* standard i/o routines        */
#include <conio.h>               /* clrscr function              */  
#include <dos.h>				 /* error handling */

/* prototypes */
void print_display( char *line );
void _far harderr_handler(
            unsigned deverror,
            unsigned errcode,
            unsigned _far *devhdr);

/* constaints */
#define maxline 18               /* set max input string length */

void main( int argc, char *argv[] )
{
   char line[maxline];           /* line used in message prompt */
   char command_parm[80];        /* command line parm           */
   int nctr;                     /* counter for command parm    */

    printf ("Hewlett Packard LasterJet 4 Display Message Editor\n");
    _harderr(harderr_handler);

    if ( argc > 1 )
      {
         command_parm[0] = '\0'; /* initialize the command parm */
         for ( nctr = 1; nctr < argc; nctr++ )
            {
               strcat( command_parm, argv[nctr] );
               strcat( command_parm, " " );
            }
         command_parm[17] = '\0'; /* cut line down to 16 characters */
         print_display( command_parm );
      }
   else
      {
         printf( "\n" );                   /* print a blank line    */
	      printf( "Enter message to display on the HP4 (up to 16 characters).\n" );
	      printf( "If you do not enter any value, the printer will be reset\n" );
	      printf( "to the default '00 READY'.\n" );
         printf( "________________\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b" );
	      fgets( line, maxline, stdin );   /* read input line from screen */
	      line[strlen( line ) - 1] = '\0'; /* remove LF that fgets put in */
         print_display( line );
      }
}

void print_display( char *line )                 /* send info to printer   */
{
   fprintf( stdprn, "\033%%-12345X@PJL \n" );    /* init printer for input */
	if ( strlen( line ) == 1 )                    /*      if no info passed */
		fprintf( stdprn, "@PJL RDYMSG DISPLAY = \"\" \n" ); /* clear message */
	else                                              /* if info to process */
		fprintf( stdprn, "@PJL RDYMSG DISPLAY = \"%s\" \n", line ); /* do it */
	fprintf( stdprn, "@PJL ENTER LANGUAGE = PCL \n" );  /* set language PCL */
	fprintf( stdprn, "\033%%-12345X@PJL \n" );          /* reset printer    */

   printf( "\nThis program is a courtesy of Grover Technology Inc.\n" );
   printf( "Revision 2.0 by Jeff Steinmetz, Urge Productions.\n");

}
void _far harderr_handler(
            unsigned deverror,
            unsigned errcode,
            unsigned _far *devhdr) {

    /* shut the compiler up */
    errcode=errcode;
    devhdr = devhdr;

    if(!(deverror & 0x8000)) {
        printf ( "A disk error has occurred.  Please re-check the disk system.\n");
    } else {
        printf ( "A printer error has occurred.  Please re-check the printer.\n");
    }

    _hardresume(_HARDERR_ABORT);
}
