   DATE:  July 1, 1994
PRODUCT:  WordPerfect 6.0 for Windows  (05/20/94  SU)
SUBJECT:  How To Add New Fields To Personal Information/Address
          Book Fields

FYI:
Question:
In WordPerfect for Windows 6.0a dated 04/20/94, can users add new
fields to the personal information and the address book fields to
fill in custom templates?

Answer:
Yes.

DISCLAIMER: 
This type of request falls into the realm of consulting.  It is not
something that WP employees should offer to users as standard
customer support.  If a user needs this type of assistance, WPCorp
employees should explain to the user that this falls into the realm
of consulting.  The employee may wish to use information below to
assist the user (if the user desires to pay consulting fees).  This
request is considered consulting because filling these requests
involves creating custom templates, a custom PROMPTS.WCM macro, a
custom _AUTOFIL.WCM macro, and a custom ADRSBOOK.WCM macro.

A.   Customize a new AUTOFILL macro.
     1.   Copy the _AUTOFIL.WCM macro which ships with WPWin 6.0
          and call it _NAUTOFL.WCM.
     2.   Edit _NAUTOFL.WCM and in the OpenAddressBook@ routine,
          modify the line which specifies the macro name to read:
          MacroName:="newadrss.wcm"
     3.   Save and compile the macro.

B.   Obtain a new template.  The user may copy one of the existing
     templates (e.g., MEMO4.WPT).  After obtaining the new
     template, the user should:
     1.   Select File|Template|highlight the custom
          template|Options|Edit 
     2.   "Copy/Remove Objects" and copy the "custom" AUTOFILL
          macro         (_NAUTOFL.WCM) to the template.
     3.   "Associate", click the Triggers radio button, and change
          the POST NEW template trigger to use the modified
          AUTOFILL macro (_NAUTOFL.WCM).
     4.   "Exit Template" and save the changes.

C.   Create the custom Address Book macro (which is called from the
     _NAUTOFL.WCM macro.
     1.   Copy the ADRSBOOK.WCM macro which ships with WordPerfect
          and call it NEWADRSS.WCM.
     2.   Edit NEWADRSS.WCM and make the following changes...

          // the next line gives one additional address book field
          (was 9 before) 
          MaxFld[1]:=10 
          // the next line gives one additional personal info field
          (was 7 before)
          MaxFld[2]:=8

          // Add references to the two new fields
          // Birthday is for the Address Book and PBirthday is for
          the Personal info
          FldName[1; 10]:="Birthday"
          FldName[2; 8]:="PBirthday"

          //In the InfoEditDlg@ Routine... change the size of the
          dialog (182) to 210 //as on the following line.

          DialogDefine("InfoEditDlg"; 50; 50; 230; 210; 19;
          InfoTypeStr[InfoType])

          // In the InfoEditDlg@ routine add the new information
          for the new field as // listed below.

          DialogAddText("InfoEditDlg"; "T10"; 8; 150 ; 68; 10; 1;
          "&Birthday:")
          DialogAddEditBox("InfoEditDlg"; "E10"; 65; 150; 150; 13;
          32; FldVar[InfoType; 10]; 80)

          // Modify the next dialog size (for personal info)--
          changing 147 to 180 as // listed below.

          DialogDefine("InfoEditDlg"; 50; 50; 230; 180; 19;
          InfoTypeStr[InfoType])

          // Add the new Personal info to the dialog as follows:

          DialogAddText("InfoEditDlg"; "T8"; 8; 111; 49; 10; 1;
          "P&Birthday:")
          DialogAddEditBox("InfoEditDlg"; "E8"; 65; 111; 150; 13;
          32; FldVar[InfoType; 8]; 80)

          // Change the location of the "Save As Default"
          pushbutton on the dialog by // changing 112 to 145 as
          listed below.

          DialogAddPushButton("InfoEditDlg";"PB1";8;112145;68;13;
          0;"&Save as Default")

          //In the CombineInformation routine, add the new address
          field:

          If(FldVar[InfoType; 10]<>"")
          CombinedInformation:=CombinedInformation+"Birthday: 
          "+FldVar[InfoType; 10]+HRTStr
          EndIf   DATE:  November 16, 1993  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows 
SUBJECT:  "GPF In Module DDEML.DLL" - Copy Original MS Windows
          DDEML.DLL File

The following problems relate to the DDEML.DLL file:
1.   The error "WPWin Has Caused A GPF In Module DDEML.DLL"
     displays when users start WPWin
2.   The error "Not Enough Global Memory To Perform The Requested
     Operation" displays.
3.   A user could load the Speller once, but after the Speller was
     closed, all of the Writing Tools were grayed out (dimmed) on
     the menu.  If the user closed the current document, the
     Writing Tools would be available again on the menu.  
4.   A user could not get the Tutorial to run at all.
5.   The error "The Application Could Not Be Executed - The File
     WPWIN.EXE Or One Of Its Components Could Not Be Found"
     occurred after a user updated from WPWin 6.0 to 6.0a.  (Answer
     7 corrected this problem.)

Answer:
Troubleshooting ideas for these problems are listed below:
1.   Copy the original Microsoft Windows DDEML.DLL file (dated
     03/13/92) to the computer.  Some companies have licensed the
     DDEML.DLL file to ship it with their own products and may have
     changed the date stamp of the file.  WPCorp ships the file,
     for example, with WPWin 5.x.  WPCorp changed the date stamp of
     the file to correspond to the Shared Code date (e.g., 11/04/91
     for English-US WPWin 5.1).

|common||prgm files/startup/go to dos|"GPF In Module DDEML.DLL"
- Copy Original MS Windows DDEML.DLL File  31376R
2.   One customer was able to resolve the problem by expanding the
     DDEML.DLL from the Windows installation disks.  To expand the
     DDEML.DLL, take the following steps:

     1.   At a DOS prompt, change to the WINDOWS directory.
     2.   Insert the Windows install disk #4 (or the disk that
          contains the DDEML.DL_ file) into the A: drive.
     3.   Type EXPAND A:\DDEML.DL_ and press Enter.
     4.   When prompted, type C:\WINDOWS\SYSTEM\DDEML.DLL.

3.   Another customer had a copy of the DDEML.DLL file in both the
     WINDOWS and the WINDOWS\SYSTEM directories.  Deleting the copy
     found in the WINDOWS directory corrected the problem.

4.   One user found a DDEML.DLL file on the network dated 11/25/91. 
     Once the user renamed this file, the problems no longer
     occurred.  The path accessed the DDEML.DLL file in a different
     directory than the DDEML.DLL file (dated 10/06/93) that
     resided in the WINDOWS/SYSTEM directory.  There seemed to be
     a conflict between the two files.

|common||prgm files/startup/go to dos|"GPF In Module DDEML.DLL"
- Copy Original MS Windows DDEML.DLL File  31376R
5.   The DDEML.DLL file in the customer's WINDOWS\SYSTEM directory
     was dated 11/04/91.  That is the date of the Windows 3.0
     DDEML.DLL file.  The customer renamed the DDEML.DLL file and
     then expanded the DDEML.DL_ file from the Windows 3.1 Disk 4
     dated 03/13/92.  (If customers are using 5.25" disks, the file
     is on Disk 5.)

     This is similar to the WPWin 5.2 problems with DDEML.DLL file
     not being found.  However, WPWin 6.0 does not ship with the
     DDEML.DLL file because the WPWIN.EXE file and DDEML.DLL files
     do not need to have the same date and time stamp.

6.   One user corrected the GPF error by adding DDEML.DLL to the
     WPC20 directory.

7.   Copying the DDEML.DLL file to the WINDOWS\SYSTEM directory
     corrected the problem for the user in Problem 5.

8.   Customers running Windows For Workgroups 3.11 (WFW) and
     receiving a GPF in DDEML.DLL should verify that they are using
     the DLL that ships with WFW dated 11/01/93.  One customer
     using WFW found an outdated copy of DDEML.DLL in a WINX/SYSTEM
     directory.  Updating this file corrected the problem.

   DATE:  April 18, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (10/01/93)
SUBJECT:  Error - "Cannot Read From Drive <drive:>" Installing
          WPWin

Problem:
The system error "Cannot Read From Drive <drive:>" displays when a
user installs WPWin to a DEC Pathworks Disk Service, an optical
drive, or a Bernoulli drive.

Answer:
This problem only occurs when Windows resides on the Disk Service
or drive to which WPWin 6.0 is being installed.  As a workaround,
run Windows from a drive other than the one where you want to
install WPWin.

Other than a Disk Service, this problem only appears to occur on
removable storage devices, such as an optical drive or a Bernoulli
cartridge.  One customer with an optical drive was able to
configure the system to boot from the drive.  This allowed the
customer to fool the system into thinking the drive was a fixed
disk and allowed WPWin to install without error.  See memo 11290T
in the WPWIN60 infobase for additional information on Bernoulli
drives.

Status:   Development has been made aware of this issue and has
          placed it on a list of proposed changes.  Developers work
          on changes according to their assigned priority. 
          Priorities are established by the number of users
          affected and/or by the severity of the problem.  WPCorp
          does not have additional information at this time.

          Notification of product releases, which may address this
          issue, will be sent to registered users in the quarterly
          WordPerfect Reports.  When you have received notification
          that a new product release is available, you may call the
          Customer Support phone numbers listed in your product
          documentation and provide your incident number to receive
          the status of this issue.
   DATE:  May 10, 1994  (Revised: July 5, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (04/20/94  6.0a)
SUBJECT:  Errors "Cannot Find SHWIN20.DLL" And "The Shared Code
          DLLs..."

Problem:
On startup of WPWin 6.0a (04/20/94), the errors "Cannot Find
SHWIN20.DLL," "Cannot Find SHWINX20.DLL," and "The Shared Code DLLs
Could Not Be Loaded" occur.

Answer:
The errors above will occur if the WPSH20.REG file is not
registered with the Windows Database (REG.DAT).

Check the REG.DAT file for a SHWIN2x section in REGEDIT.  Below
that section, there should be two lines: 1) Preferred= and 2)
WPWIN60=.  If these sections are missing, then you should remerge
the WPSH20.REG file within REGEDIT.  
1.   Choose File|Run from Program Manager.
2.   Run REGEDIT.EXE /V from the WINDOWS directory.
3.   Search for SHWIN2X.  If not found, select File|Merge
     Registration file, and select WPSH20.REG.

See Folio memo 30522H in the WPWIN60 infobase for additional
information.

Note:  One user found that the WPWin 6.0 icon group created during
the installation did not appear on PCTools desktop.  Bringing the
icon group into PCTools desktop through File|Import|Defaults To
Windows and clicking on the WPWIN60.GRP file allowed the customer
to enter WPWin 6.0 without the above errors.

   DATE:  May 11, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (10/01/93)
SUBJECT:  GPF Adding/Deleting Words From Supplemental Dictionary On
          Network

Problem:
When a customer adds or deletes words from a supplemental
dictionary that resides on a network drive and then tries to exit
the Speller, a General Protection Fault error occurs.  The exact
error message is "SPWIN20 Caused a GPF in Module SHWIN20.DLL at
0008:079C."

Answer:
To work around the problem, customers using a stand-alone version
should create the supplemental dictionary on the local drive.  The
path for the supplemental dictionary must be changed in the private
.BIF file:
1.   Open the private .BIF file
2.   Select WPSpeller|US|Supplementary Dictionaries in Search Order
3.   Change this path to reflect the path on the local drive (e.g.,
     C:\WINDOWS\WPSPELUS.SUP)

Network administrators cannot correct this problem in every user's
private .BIF file by editing the WPCNET.BIF file.  This is due to
a problem in overriding the existing path information.  This
limitation of overriding the Default path for supplementary
dictionaries in private .BIF files has been logged with
Development.

Users can also work around this problem in WordPerfect (without
editing the .BIF file) by following the steps below:
1.   Copy the .SUP file from the network drive to the desired local
     location.  
2.   Select Tools|Speller|Dictionaries|Supplementary|highlight the
     WPSPELUS.SUP file (verify that it is pointing to the network)
     and choose Delete and answer Yes to the Remove Dictionary from
     Chain prompt.
3.   Choose Add and find the WPSPELUS.SUP on the local drive (in
     the desired location), then choose OK to add the dictionary.

NOTE: After making these changes, the user can Close the
Supplementary Dictionaries dialog box and make sure that the Add To
item on the Speller dialog box refers to the WPSPELUS.SUP item.

FYI:
The user receives the error "WPWIN60.EXE Caused A GPF In Module
SHWIN20.DLL At 0008:079C" when closing the Speller in WPWin 6.0a. 
The user renamed the .SUP dictionary file on the network and
allowed the program to create a new one.  This step corrected the
problem.

Status:   Development has been made aware of this issue and has
          placed it on a list of proposed changes.  Developers work
          on changes according to their assigned priority. 
          Priorities are established by the number of users
          affected and/or by the severity of the problem.  WPCorp
          does not have additional information at this time.

          Notification of product releases, which may address this
          issue, will be sent to registered users in the quarterly
          WordPerfect Reports.  When you have received notification
          that a new product release is available, you may call the
          Customer Support phone numbers listed in your product
          documentation and provide your incident number to receive
          the status of this issue.
   DATE:  May 16, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (10/01/93)
SUBJECT:  Merge Places One Label Per Page If Labels Have Margin
          Code

Problem:
If a labels form file contains a margin code, the merge will place
only one label per page.

Answer:
Users can work around the problem by placing the label code and the
margin code in the Document Initial Codes style.

Status:   Development has been made aware of this issue and has
          placed it on a list of proposed changes.  Developers work
          on changes according to their assigned priority. 
          Priorities are established by the number of users
          affected and/or by the severity of the problem.  WPCorp
          does not have additional information at this time.

          Notification of product releases, which may address this
          issue, will be sent to registered users in the quarterly
          WordPerfect Reports.  When you have received notification
          that a new product release is available, you may call the
          Customer Support phone numbers listed in your product
          documentation and provide your incident number to receive
          the status of this issue.
   DATE:  May 23, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (10/01/93)
SUBJECT:  Macros - NUMSTR On 100+ Numbers Results In Scientific
          Notation

Problem:
When a customer uses the NUMSTR macro command on numbers larger
than 100, the results are in exponential or scientific notation.

Status:   Development has been made aware of this issue and has
          placed it on a list of proposed changes.  Developers work
          on changes according to their assigned priority. 
          Priorities are established by the number of users
          affected and/or by the severity of the problem.  WPCorp
          does not have additional information at this time.

          Notification of product releases, which may address this
          issue, will be sent to registered users in the quarterly
          WordPerfect Reports.  When you have received notification
          that a new product release is available, you may call the
          Customer Support phone numbers listed in your product
          documentation and provide your incident number to receive
          the status of this issue.
   DATE:  May 27, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (04/20/94  6.0a)
SUBJECT:  GPF In Module WPWIN60.EXE At 0001:08D3 - Disable External
          Cache

FYI:
Problem:
When a customer starts WPWin, the message "Shared Code DLLs Could
Not Be Loaded" or "WPWIN60 Caused A General Protection Fault Error
in Module WPWIN60.EXE at 0001:08D3" displays.  (The GPF may also
occur at address 0001:08D8 and 0001:08B3.)

Another user received the message "WPWIN60 Had An 'Exceed Segment
Bounds (RMW)' Fault At WPWIN60 1:08D3" when running WPWin 6.0 on an
OS/2 workstation.

Other customers have seen Parity errors under the same situation.

Answer:
To correct the problem, the customer disabled External Cache in the
computer's Setup (CMOS).  The customer was using an IBM 486 DX2/66
Value Point computer.  Please note that there is not a permanent
way to disable the External Cache on the IBM Value Point through
the CMOS.  IBM is aware of the problem and working toward a
solution.  Customers may want to contact IBM for additional
information regarding this problem.

Status:   Development has been made aware of this issue and has
          placed it on a list of proposed changes.  Developers work
          on changes according to their assigned priority. 
          Priorities are established by the number of users
          affected and/or by the severity of the problem.  WPCorp
          does not have additional information at this time.

          Notification of product releases, which may address this
          issue, will be sent to registered users in the quarterly
          WordPerfect Reports.  When you have received notification
          that a new product release is available, you may call the
          Customer Support phone numbers listed in your product
          documentation and provide your incident number to receive
          the status of this issue.
   DATE:  May 31, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (10/01/93)
SUBJECT:  6.0a Startup Errors - MFWIN20 Caused GPF, WPWIN60 Caused
          GPF

FYI:
Problem:
After installing 6.0a, users get the startup error "MFWIN20 Caused
A General Protection Fault In SHWIN20.DLL at 000C:0F68" followed by
"WPWIN60 Caused A General Protection Fault In SHWIN20.DLL At
000C:0F68." 

Answer:
Try running CHKDSK or Scandisk to look for errors on the disk and
any WordPerfect files that may be truncated.  Correcting the errors
and recreating the WPCSET.BIF may solve the problem.

   DATE:  June 2, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (10/01/93)
SUBJECT:  Display Problems Occur After Installing WPWin 6.0a

Problem:
The customer has noticed some display problems after installing the
WPWin 6.0a (04/20/94) interim update.  Some of the problems noted
are:
1.   Increased difficulty viewing fonts below 10pt in size.
2.   Letter spacing between some character combinations has
     increased or decreased.

Answer:
Several changes were made in WPWin 6.0a to make it a truer WYSIWYG
application.  One benefit from the changes include a closer match
with the Status Bar and the Ruler Bar.  "Side effects" of these
changes include the display differences listed above.  The display
differences are more noticeable using the VGA display driver.  At
higher resolutions, the differences are lessened or nonexistent. 
This is probably due to the ability higher resolution display
drivers have of showing more font detail.

Status:   Development has been made aware of this issue and has
          placed it on a list of proposed changes.  Developers work
          on changes according to their assigned priority. 
          Priorities are established by the number of users
          affected and/or by the severity of the problem.  WPCorp
          does not have additional information at this time.

          Notification of product releases, which may address this
          issue, will be sent to registered users in the quarterly
          WordPerfect Reports.  When you have received notification
          that a new product release is available, you may call the
          Customer Support phone numbers listed in your product
          documentation and provide your incident number to receive
          the status of this issue.
   DATE:  June 20, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (04/20/94  6.0a  CE)
SUBJECT:  Installing CE Version - User Not Prompted For Eighth Disk

Problem:
A customer installing the English-Canada (CE) update of WPWin 6.0
(eight disks) is prompted for disks 1-7, but is not prompted for
disk 8.  Why isn't the user prompted for disk 8 and/or why is it
needed?

Answer:
Only those customers who have the Borland Office package will be
prompted for disk 8.  The disk contains such things as the Desktop
Application Director (DAD).

   DATE:  June 22, 1994  (Revised: July 11, 1994)
PRODUCT:  WordPerfect 6.0 for Windows  (10/01/93  CE)
SUBJECT:  Installing CE Update - No Path For TrueType Fonts

Problem:
A user found that the system did not show a path for TrueType fonts
when doing a Custom install of the English-Canada (CE) 8-disk
update.  Whatever directory is keyed in will return the error
"TrueType Font Files From The Previous WPWin 6.0 Installation Were
Not Found In directory <directory path>.  Please Specify The
Directory Where These Files Are Located."  

Answer:
Leaving the TrueType font file line blank will allow the
installation to proceed.

Status:   Development has been made aware of this issue and has
          placed it on a list of proposed changes.  Developers work
          on changes according to their assigned priority. 
          Priorities are established by the number of users
          affected and/or by the severity of the problem.  WPCorp
          does not have additional information at this time.

          Notification of product releases, which may address this
          issue, will be sent to registered users in the quarterly
          WordPerfect Reports.  When you have received notification
          that a new product release is available, you may call the
          Customer Support phone numbers listed in your product
          documentation and provide your incident number to receive
          the status of this issue.   DATE:  June 28, 1994
PRODUCT:  WordPerfect 6.0 for Windows  (04/20/94  6.0a)
SUBJECT:  Merge Codes Not Pasting Into Envelope Dialog Box

Problem:
Merge codes do not paste into the Envelope dialog box when a user
preforms a merge.

Answer:
When selecting the Envelopes button under Tools|Merge|Merge, users
must tell WPWin which fields from the data file to merge into the
envelope by clicking on the Field button at the bottom of the
Envelope dialog box.

How/Why:
To correctly set up WPWin to merge to envelopes as well as the
selected form file, do the following:
1.   Select Tools|Merge|Merge
2.   Specify the Form filename
3.   Specify the Data filename
4.   Select the Envelopes button
5.   Place the insertion point into the Mailing Address window
6.   Select the Field button
7.   Highlight the first field name or number to be inserted into
     the envelope and select Insert
8.   Repeat steps 5-7 until the desired fields are entered into the
     Mailing Address window (make sure users place the fields in
     the exact locations and order that they want the data to
     merge)
9.   Make sure the Return Address window is completed correctly
10.  Select OK to return to the Perform Merge dialog box
11.  Select OK to perform the merge

The envelopes will be located at the bottom of the merged form
file.   DATE:  July 8, 1994
PRODUCT:  WordPerfect 6.0 for Windows  (04/20/94  6.0a)
SUBJECT:  Computer Locks If You Remove Floppy From Drive After
          Opening File

Problem:
In WPWin 6.0, if you open a file that is on a floppy disk, remove
the disk from the drive, insert a different disk into the drive,
and then try to save the file, the computer will lock.

Answer:
WPWin 6.0 was not designed to work this way.  When you open a file
from a floppy diskette, you must not remove the disk from the
floppy drive until the file is saved to another drive or is closed.

How/Why:
WPWin 6.0 is a disk-based word processor.  It keeps the original
source file open on the diskette and expects to find a valid file
handle.  When the diskette is removed from the drive, the file
handle is no longer valid.  
In WPWin 5.1/5.2, WPWin copied the file to a temporary file and
kept it open there, thus allowing files to be more easily copied
using this method.  This is no longer possible because as features
in Windows applications increase, the necessity of locking the file
open also increases.  WPWin must now keep the original file open.

Users may find that certain small files will copy using this method
of swapping diskettes, but the results will be unpredictable.  In
summary, customers should not open files from floppy diskettes and
then remove the diskette from the drive.  They can save the file to
the hard drive and then save it to a new floppy diskette, or they
can copy the file to the hard drive and then copy it to a new
floppy diskette using File|Open|File Options|Copy.  If they do not
want the file on the hard drive, they can delete it afterward using
File|Open|File Options|Delete.   DATE:  July 11, 1994
PRODUCT:  WordPerfect 6.0 for Windows
SUBJECT:  Steps For Merging Envelopes Only

Question: 
How do I merge to Envelopes only?  The customer has already merged
a letter and now wants to merge only the envelopes.

Answer:
The steps to merge only envelopes are as follows:
1.   From a blank document window, choose Tools|Merge|Form.
2.   Choose Layout|Envelope.
3.   Place the insertion point inside the Mailing Address text box.
4.   Use the Field button to insert each of the fields to be
     merged.
5.   If you want a PostNet barcode printed on the envelope, insert
     the ZIP code field into the PostNet Bar Code text box.
5.   Click on the Append to Doc button.  This places an envelope
     form on the current document window.
6.   Now, merge as normal by selecting Tools|Merge|Perform Merge.
7.   The files to merge should be as follows:
          Form File:     <Current Doc>
          Data File:     Customer's Data file
          Output File:   <New Document>
8.   Click on OK.

Also, see page 479 in the WordPerfect 6.0 Reference manual or page
574 of the WordPerfect 6.0a User's Guide for additional
information.