;*************************************************************************
;*	Quelques routines graphiques pour travailler en mode texte  80*25
;*	 en 16 couleurs
;* Programm par Sbastien Granjoux
;* Commenc le 26/12/93
;* Dernire modification le 26/12/93

IDEAL

P386N
MODEL	SMALL

PUBLIC	SetMode3
PUBLIC	ResetMode
PUBLIC	SetPage
PUBLIC	UseCpkBlk
PUBLIC	UpdCpkBlk
PUBLIC	PutVu

VIDEO_MOD	EQU	3
LEN_LINE	EQU	160
NB_LINE		EQU	25
VIDEO_SEG	EQU	0b800h
CRT_INDEX	EQU	3D4h
GREEN		EQU	10
YELLOW		EQU	14
GRAY		EQU	8
RED		EQU	12

PAGE0		EQU	0

DATASEG

OldMode	DB ?

CODESEG

;*************************************************************************
;*	Initialise le mode texte 3
;*
;* Sortie:
;*	ES	segment de la RAM video

PROC    SetMode3

	mov     ah,0fh          ; sauve l'ancien mode
	int     10h
	mov     [ds:OldMode],al

	mov     ax,VIDEO_MOD	; passe en mode 3
	int     10h

	mov	ax,VIDEO_SEG
	mov	es,ax

	mov	dx,CRT_INDEX	; efface le curseur
	mov	ax,1f0ah
	out	dx,ax

	ret

ENDP

;***************************************************************************
;*      Reprend le mode d'avant le dernier setmode

PROC    ResetMode

	movzx   ax,[byte ptr ds:OFFSET OldMode]
	int     10h

	ret

ENDP

;*************************************************************************
;*	Change de page ecran
;*
;* Entre:
;*	BX	adresse de la nouvelle page ecran
;*
;* Sortie:
;*	ES	segment de la nouvelle page

PROC	SetPage

	mov	dx,CRT_INDEX	; Change l'adresse de la RAM video
	mov	ah,bl
	mov	al,0Dh
	out	dx,ax
	mov	ah,bh
	dec	al
	out	dx,ax

	shr	bx,4
	add	bx,VIDEO_SEG
	mov	es,bx

	ret
ENDP

;*************************************************************************
;*	Affiche une barre en jouant uniquement sur les attributs
;*	La barre en verte (10) puis jaune (4) puis rouge (2) sinon gris
;*
;* Entre:
;*	CL	longeur de la barre
;*	CH	longeur totale de la barre
;*	DL	position en X de la barre  l'ecran
;*	DH	position en Y de la barre  l'ecran

PROC	PutVu

	mov	di,dx
	shr	di,8
	lea	di,[edi*4+edi]
	shl	di,4
	and	dx,00ffh
	add	di,dx
	add	di,di
	inc	di

	or	cl,cl
	je	@@gray_part
	mov	ah,ch
	shr	ah,1
@@green_part:
	mov	al,GREEN
@@next_green:
	stosb
	inc	di
	dec	cl
	je	@@gray_part
	dec	ch
	cmp	ch,ah
	jne	@@next_green

	mov	al,YELLOW
	shr	ah,1
@@next_yellow:
	stosb
	inc	di
	dec	cl
	je	@@gray_part
	dec	ch
	cmp	ch,ah
	jne	@@next_yellow

	mov	al,RED
@@next_red:
	stosb
	inc	di
	dec	cl
	je	@@gray_part
	dec	ch
	jne	@@next_red

	ret

@@gray_part:
	mov	al,GRAY
@@next_gray:
	stosb
	inc	di
	dec	ch
	jne	@@next_gray
	ret

ENDP

;***************************************************************************
;*	Affiche un bloc de texte compact et sort le tableau contenant
;*	les positions des diffrentes cases (un mot sur chaque case de la
;*	forme Y*256+X) termin par 0
;*
;*	La routine de compression reconnait les codes suivants
;*	00	fin de l'image
;*	01-08	nouvelle couleur du fond +1
;*	09	bascule du clignotement
;*	10	nouvelle ligne
;*	11 N	affiche N espace
;*	12 N X  affiche N caractre X
;*	13 N	reserve N octet pour un chiffre
;*	14 N	reserve N octet pour une chaine
;*	15 X 	caractre de controle
;*	16-31	nouvelle couleur des caractres + 16
;*
;*
;* Entre:
;*	DL	X de l'image
;*	DH	Y de l'image
;*	ES	segment de l'image a l'ecran
;*	DS:SI	position de l'image en mmoire
;*	DS:BX	table contenat toutes les positions

PROC	UseCpkBlk

	mov	di,dx
	shr	di,8
	lea	di,[edi*4+edi]
	shl	di,4
	and	dx,00ffh
	add	di,dx
	add	di,di

	xor	ch,ch
	mov	ah,7
	mov	dx,di
@@next_car:
	lodsb
	cmp	al,31
	jbe	@@control
	stosw
	jmp	@@next_car

@@control:
	dec	al
	js	@@exit

	cmp	al,8
	ja	@@no_back
	je	@@blink

	shl	al,4
	and	ah,8Fh
	or	ah,al
	jmp	@@next_car

@@blink:
	xor	ah,80h
	jmp	@@next_car

@@no_back:
	sub	al,15
	jb	@@no_fore

	and	ah,0F0h
	or	ah,al
	jmp	@@next_car

@@no_fore:
	cmp	al,-5
	jb	@@new_line
	cmp	al,-4
	jbe	@@same_car
	cmp	al,-1
	je	@@esc_car
	mov	[ds:bx+2],di
	and	al,3
	mov	[ds:bx],al
	lodsb
	mov	[ds:bx+1],al
	add	bx,4
	mov	cl,al
	mov	al,' '
	jmp	@@tabulation
@@same_car:
	lodsb
	mov	cl,al
	mov	al,' '
	jne	@@tabulation
	lodsb
@@tabulation:

	rep	stosw
	jmp	@@next_car

@@esc_car:
	lodsb
	stosw
	jmp	@@next_car

@@new_line:
	add	dx,LEN_LINE
	mov	di,dx
	jmp	@@next_car

@@exit:
	mov	[word ptr ds:bx],0
	mov	[word ptr ds:bx+2],0

	ret

ENDP

;***************************************************************************
;*	Rafraichie un affichage commenc avec UseCpkBlk
;*
;* Entre:
;*	DS:SI	objet  afficher (mot ou pointeur sur chaine)
;*	DS:BX	table contenant la position des objet termin par 00000000h
;*		de la forme: position(16 bits) taille(8 bits) type (2 bits)
;*		type=3 chiffre et 2 chaine
;*	ES	segment de la RAM video

PROC	UpdCpkBlk

@@next_obj:
	mov	ax,[ds:bx]
	add	bx,4
	or	al,al
	je	@@no_obj
	mov	di,[ds:bx-2]
	test	al,1
	jnz	@@no_str

	push	si
	mov	si,[ds:si]
@@next_car:
	lodsb
	or	al,al
	je	@@no_car
	stosb
	inc	di
	dec	ah
	jne	@@next_car
@@no_car:

	pop	si
	add	si,2
	jmp	@@next_obj

@@no_str:
	push	bx
	mov	bx,10
	mov	cl,ah
	xor	ch,ch
	add	di,cx
	add	di,cx
	sub	di,2
	mov     ax,[ds:si]
	add	si,2

	xor	dx,dx
	div	bx
	add	dl,'0'
	mov	[es:di],dl
	sub	di,2
	dec     cl
	je	@@end_number
@@next_digit:
	xor	dx,dx
	div	bx
	or	dl,dl
	jne     @@no_space
	cmp	cl,1
	jne	@@no_space
	mov	dl,' '-'0'
@@no_space:
	add	dl,'0'
	mov	[es:di],dl
	sub	di,2
	dec	cl
	jne	@@next_digit
@@end_number:
	pop	bx

	jmp	@@next_obj

@@no_obj:
	ret

ENDP

END