; These routines use the screen dimensions specified in the chtil.inc file

; WARNING! Some of this assembler code is highly interleaved to get the max
; from 486 and Pentium processors while running quite fast on good ol' 386.
; To better understand this code remember:
;           REGISTERS are used as variables whenever possible, so follow
;           what happens to every register.
;           Usually i interleave TWO sequences into one, skip one instruction
;           and you get the usual sequence everyone can understand.
;           I don't optimize sequences that clash with bottlenecks OUTSIDE
;           the processor (i.e. memory access), my main target is
;           to keep the most accessed stuff into registers
;           and process things at 32bit.

       .386P
code32 segment para public use32
       assume cs:code32,ds:code32
       
include 386power.inc       
include 386video.inc
include 386keyb.inc
include 386file.inc
include chtil.inc

; MODULO Per I/O Character oriented
;
        align dword
        ; pointer to current character font bitmaps
        public _CHRPAL,_CHRFNT,_CHRMENU1,_CHRMENU2
_CHRPAL   dd 0
_CHRFNT   dd 0
_CHRMENU1 dd 0
_CHRMENU2 dd 0
        align byte

        public _LoadCharSet
_LoadCharSet: ; in: in: esi= pointer to character bitmap file name
              ; out: CARRY SET IF ERROR
        pushad
        ; allocate space for TWO character sets plus palette entries
        ; load character font file
        mov eax,_LoMemBase
        mov _CHRPAL,eax
        add eax,(12*3)
        mov _CHRFNT,eax
        mov _CHRMENU1,eax
        add eax,CHARSIZE*128
        mov _CHRMENU2,eax
        call _LoFLoad
        jc short LBye
        cmp eax,((12*3)+(CHARSIZE*128))
        jne short LBye
        add _LoMemBase,eax        ; update memory base
        mov ecx,(CHARSIZE*128)
        mov esi,_CHRMENU1
        mov edi,_CHRMENU2
        add _LoMemBase,ecx       ; add space for the input character set
transcol:
        lodsb
        cmp al,BRIGHT1_TEXT
        jb nobri
        cmp al,BRIGHT6_TEXT
        jnbe nobri
        add al,(DARK1_TEXT-BRIGHT1_TEXT)
        jmp short guu
nobri:  cmp al,DARK1_TEXT
        jb guu
        cmp al,DARK6_TEXT
        jnbe guu
        add al,(BRIGHT1_TEXT-DARK1_TEXT)
guu:    stosb
        dec ecx
        jne transcol
        ; now change palette

        mov esi,_CHRPAL ; get pointer to character's private palette entries

        ; bright
        mov al,BRIGHT1_TEXT
palettb:
        mov edx,[esi]
        add esi,3
        and edx,00FFFFFFh
        call _Set1Pal
        inc al
        cmp al,BRIGHT6_TEXT
        jbe palettb

        ; dark
        mov al,DARK1_TEXT
palettd:
        mov edx,[esi]
        add esi,3
        and edx,00FFFFFFh
        call _Set1Pal
        inc al
        cmp al,DARK6_TEXT
        jbe palettd
        popad
        clc
        ret
LBye:   popad
        stc
        ret

SPUTS macro
        movsd
        movsd
        add edi,((RXWIDTH+XBORDER)-8)
        endm

        public _PutString

_PutString:
         ; edi = screen base
         ; eax = x in pixels
         ; edx = y in pixels
         ; ebx = string
         
         pushad
         add edi,eax
         mov ebp,_CHRFNT
         add edi,[edx*4+_RowStart]
         jmp @czero
@bliit:  inc ebx
         shl esi,CHARSHIFT
         add esi,ebp
LUPPALO:         
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         movsd
         movsd
         sub edi,((RXWIDTH+XBORDER)*7)
@czero:         
         movsx esi,byte ptr [ebx]
         cmp esi,0
         jne @bliit
         
         popad
	 ret



        public _PutHex

_PutHex: ; scrive il numero esadecimale ( oppure bcd) a 32 bit
         ; contenuto in ebx
         ; edi = screen dest
         ; eax = x in pixels
         ; edx = y in pixels
         ; ecx = digits to use
         ; ebx = number to write
         pushad
         add edi,eax
         shl ecx,3
         add edi,[edx*4+_RowStart]
         add edi,ecx
         mov esi,ebx
         shr ecx,3
         mov ebp,_CHRFNT
         sub edi,8
@ngnchar:
         and esi,0Fh
         shr ebx,4
         cmp esi,10
         jb  @isdec
         add esi,(65-48-10) ; 'A' - '0' - 10
@isdec:   
         add esi,48 ; '0' == 48
         shl esi,CHARSHIFT
         add esi,ebp
SLUPPALO:         
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         movsd
         movsd
         sub edi,((RXWIDTH+XBORDER)*7)+8+8
         mov esi,ebx
         dec ecx
         jnz @ngnchar
         popad
	 ret


        public _PutInt

_PutInt: ; scrive l' integer a 32 bit contenuto in ebx
         ; edi = screen dest
         ; eax = x in pixels
         ; edx = y in pixels
         ; ecx = digits to use
         ; ebx = number to write
         pushad
         cmp ebx,0
         jge think_positive
         push offset put_dash
         neg ebx
         dec ecx   ; one position is for the '-' sign
         add eax,8 ; one character position forward
         jmp short think_this

put_dash:
         mov esi,('-' shl CHARSHIFT)
         mov edx,7
         add esi,ebp
dashloop:
         SPUTS
         dec edx
         jne dashloop
         movsd
         movsd
         sub edi,((RXWIDTH+XBORDER)*7)+8+8
         or ecx,ecx
         jnz zappzero
         popad
         ret

        public _PutUnsigned

_PutUnsigned: ; scrive il numero positivo a 32 bit contenuto in ebx
         ; edi = screen dest
         ; eax = x in pixels
         ; edx = y in pixels
         ; ecx = digits to use
         ; ebx = number to write
         pushad
think_positive:
         push offset no_minus
think_this:
         add edi,eax
         shl ecx,3 ; ecx*8
         add edi,[edx*4+_RowStart]
         add edi,ecx ; move to last digit
         mov eax,ebx
         shr ecx,3
         mov ebp,_CHRFNT
         sub edi,8
         mov ebx,10
@ungnchar:
         xor edx,edx
         div ebx
         add edx,'0' ; '0' == 48
         shl edx,CHARSHIFT
         lea esi,[edx+ebp]
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         SPUTS
         movsd
         movsd
         sub edi,((RXWIDTH+XBORDER)*7)+8+8
         or  eax,eax
         jz  goon
         dec ecx
         jnz @ungnchar
         ret
goon:    dec ecx
         ret
zappzero:
         add ebp,(' ' shl CHARSHIFT)
tzappzero:
         mov edx,7
         mov esi,ebp
spcloop:
         SPUTS
         dec edx
         jnz spcloop
         movsd
         movsd
         sub edi,((RXWIDTH+XBORDER)*7)+8+8
         dec ecx
         jnz tzappzero
         popad
         ret

no_minus:
         test ecx,ecx
         jnz zappzero
         popad
         ret
         
         public _GetString
_GetString:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; ecx= max. string size excluding terminal NUL
        ; ebx= string
        pushad
        mov checksign,0
        mov min_ch,1   ; the NUL symbol is not supported
        mov max_ch,126 ; the "cursor"  symbol is not supported
        call stringy
        popad
        ret

stgzero db 'CHARIO: Attempt to read chars on a zero lenght string',CR,LF,'$'
chvai:
        mov _386Return,offset stgzero
        jmp _Exit

stringy:
        call _KeybAsciiMode
        mov ebp,0
        or ecx,ecx
        jz chvai
        pushad                 ; fill stringz with space characters
        mov al,32 ; space      ;
        mov edi,ebx            ;
        ; ecx already loaded   ;
        rep stosb              ;
        mov byte ptr [edi],0   ;
        popad                  ;
        
        mov byte ptr [ebx],127 ; put cursor char
        call _PutString
        call _PageFlip0
showit:        
        push eax
retry:        
        call _ReadAscii
        cmp al,8 ;BACKSPACE?
        jne nodel
        cmp ebp,ecx
        jae no_xspc
        mov byte ptr [ebx+ebp],32
no_xspc:
        cmp ebp,0
        je zerobuf
        dec ebp
zerobuf:        
        mov byte ptr [ebx+ebp],127 ; new cursor position
        jmp short nukey
nodel:  cmp al,13 ;ENTER?
        je gotstring
        cmp ebp,ecx
        jae retry
        cmp checksign,0
        je nosign
        or ebp,ebp ; you can put a '-' as first char
        jnz nosign
        cmp al,'-'
        je gudkey
nosign:
        cmp al,min_ch
        jb retry
        cmp al,max_ch
        ja retry
gudkey:
        mov [ebx+ebp],al
        inc ebp
        cmp ebp,ecx
        jae nukey
        mov byte ptr [ebx+ebp],127 ; put cursor char
nukey:
        pop eax
        call _PutString
        pushad
        mov ecx,ebp
        sub eax,_VDispX
        inc ecx
        sub edx,_VDispY
        mov ebx,8
        shl ecx,1   ; get nudget count
        call _TouchBlock
        call _PageFlip1
        popad
        jmp short showit
gotstring:
        pop eax
        mov byte ptr [ebx+ebp],0
        call _KeybRawMode
        ret

unstring  db 12 dup(0)
checksign db 0
max_ch    db 0
min_ch    db 0
align dword
got_this  dd 0
align byte

        public _GetInt
_GetInt:
        ; in:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; ecx= max. digits (there is a practical limit of 10 digits)
        ; out:
        ; ebx= returned value
        pushad
        mov checksign,1
        mov min_ch,'0'
        mov max_ch,'9'
        cmp ecx,11
        jb  utype_it
        mov ecx,11
        jmp short utype_it

        public _GetUnsigned
_GetUnsigned:
        ; in:
        ; edi= scr dest
        ; eax= x in pixels
        ; edx= y in pixels
        ; ecx= max. digits (there is a practical limit of 10 digits)
        ; out:
        ; ebx= returned value
        pushad
        mov checksign,0
        mov min_ch,'0'
        mov max_ch,'9'
        cmp ecx,10
        jb  utype_it
        mov ecx,10
utype_it:
        mov ebx,offset unstring
        call stringy

        ; now execute conversion
        cmp checksign,0
        jnz siign

        ; unsigned dword
        cmp ebp,10
        jb small_enough
        cmp byte ptr [ebx],'4' ; no more than 3999999999
        jb small_enough
        jmp short utype_it

        ; signed dword
siign:  cmp ebp,11
        jb  maybe_small
        cmp byte ptr [ebx],'-'
        jne utype_it  ; heck! 11 chars and no sign, it can't fit!!!
        ; maybe it can fit
        cmp byte ptr [ebx+1],'2'
        jnb utype_it  ; no more than +/-1999999999
        jmp short dash_ahead

maybe_small:
        cmp byte ptr [ebx],'-'
        je dash_ahead  ; max. 10 chars and sign, it can fit
        ; 10 chars with no sign, check head digit
        mov checksign,0 ; sign was not present
        cmp ebp,10
        jb small_enough
        cmp byte ptr [ebx+1],'2'
        jnb utype_it  ; no more than +/-1999999999
        jmp short small_enough
dash_ahead:
        inc ebx  ;
        dec ebp  ; cut out sign
small_enough:
        xor eax,eax
        or ebp,ebp  ; zero digits ?
        je udid     ;
accumulate:
        mov edx,10
        movzx edi,byte ptr [ebx]
        inc ebx
        or edi,edi ; reached the final NUL ?
        je udid  ;
        sub edi,'0'
        mul edx
        add eax,edi
        jmp short accumulate
udid:   mov got_this,eax
        popad
        mov ebx,got_this
        cmp checksign,0
        je no_neg
        neg ebx
no_neg:
        ret

code32 ends

 END

