; 370.asm
;
; this program demonstrates the use of routines which translate IBM 370
; to Intel floating point.
;
; written on Tue  09-10-1996  by Ed Beroset
;   and donated to the public domain by the author
;

        .MODEL small
        .STACK 400h
        .DATA
pi370   db      041h, 032h, 043h, 0F6h, 0A8h, 088h, 05Ah, 031h
piIEEE  dq      ?

EBIAS_370     =    64    ; exponent bias for 370 floating point (all types)

EBITS_IEEESGL =     7
EBITS_IEEEDBL =    10
EBITS_IEEEEXT =    15

EBIAS_IEEESGL =   127
EBIAS_IEEEDBL =  1023
EBIAS_IEEEEXT = 16383

        .CODE
        .386
Main proc
        .STARTUP
        push    ds
        pop     es
        mov     si,offset pi370
        mov     di,offset piIEEE
        call    fp370toIEEE
; piIEEE now contains the IEEE floating point equivalent of the number
; passed in via pi370
        .EXIT
endp

fp370toIEEE proc
        ; first, we store the sign bit off to stack
        cld                             ;
        lodsb                           ;
        mov     ah,80h                  ;
        and     ah,al                   ;
        push    ax                      ; save sign to stack in AH
        ; now we adjust and convert the exponent
        and     ax,07Fh                 ; mask off sign bit
        sub     ax,EBIAS_370            ; convert to unbiased exponent
        shl     ax,2                    ; multiply by four
        add     ax,EBIAS_IEEEDBL        ; re-bias exponent
        mov     bx,ax                   ; save biased exponent in BX
        ; now read the data bytes (and reverse 'em)
        xor     ah,ah                   ; clear high part of data
        mov     cx,7                    ; seven bytes total
more_data:                              ;
        lodsb                           ; pull in a byte of data
        shld    edx,eax,8               ; shift it into place
        shl     eax,8                   ;
        loop    more_data               ; keep going until we're done
                                        ;
normalize:                              ; now data is in EDX:EAX
        dec     bx                      ; adjust exponent
        shl     eax,1                   ; shift low half
        rcl     edx,1                   ; shift high half
        jnc     normalize               ; loop if data isn't normalized yet
        shrd    eax,edx,EBITS_IEEEDBL+2 ; carry bit + 10 bit biased exponent
        shr     edx,EBITS_IEEEDBL+2     ; adjust the top half too
        stosd                           ; save low half
        mov     ax,bx                   ; recall exponent
        shl     ax,15-EBITS_IEEEDBL-1   ; shift into place
        pop     bx                      ; recall sign bit
        or      ah,bh                   ; mask sign bit into place
        shl     eax,16                  ; move the lot of it into place
        or      eax,edx                 ; combine sign, exp, and characteristic
        stosd                           ; save that
        ret                             ; we're done
endp

        END Main
