; From Hugh Noland - An e spigot
;
;The following program, which uses only 16-bit code, will print out
;6550+ digits of e.  I do not have handy a reference giving more than
;the first 10 digits, so I am hoping someone who has a more extensive
;reference will check the output further.  On a Pentium, 75 mhz, 6550
;digits are output to the screen in about 30 seconds.
;
;---------------------------------------------------------------------------
;E.ASM
;This program prints out the first n digits of e, where n is input by
;the user.  It is based on an algorithm described in the article "A
;Spigot Algorithm for the Digits of PI", by Stanley Rabinowitz and Stan Wagon,
;American Mathematical Monthly, March, 1995, p.195 ff.  If n is so large
;as to cause a multiplication overflow the program will terminate with
;an error message.  This will only occur if n is somewhat more than 6550.
;All output is via Dos, so may be re-directed.  Re-direction, however, will
;suppress the prompt message; and also the echo, so the user's response
;will not be output to the screen.  For example, if the user enters
;         e > e.dat
;the computer, although waiting for input, will appear to be hanging.
;If the user then types "12", followed by "Enter", the "12" will not be
;echoed to the screen; but a file "e.dat" will be created and the
;first 12 digits of e will be output to it.
;
;-------------Hugh Noland--August 20, 1996----------------------------------
 
cseg   segment    word
assume cs:cseg, ds:cseg
org 100h
 
begin: jmp main
 
msg       db     10,13,"Number of digits: $"
err_msg   db     10,13,"Multiplication overflow...$"
two       db     "2 $"
crlf__    db     10,13,"  $"
crlf      db     10,13,"$"
col       db     2
space_ind db     5
ten       dw     10
q         dw     0
i         dw     ?
n         dw     ?
 
main:
   cld                           ;
   mov dx,offset msg             ;
   mov ah,9                      ;
   int 21h                       ;
                                 ;
   mov ah,0ah                    ;call for input from user
   mov dx,offset buf             ;buf located at end of code
   int 21h                       ;
 
   mov dx,offset crlf
   mov ah,9
   int 21h
 
;---------------------------------------------------------------------------
;convert string to decimal, add 2, and store in n
 
   mov si,offset buf
   inc si                        ;si==>length of string
   mov cl,[si]                   ;get string length in cx
   mov ch,0
   jcxz jmp_exit
   jmp c0
jmp_exit:
   jmp exit
c0:
   inc si                        ;si==>first digit of string
   xor ax,ax
   mov bh,0
c1:
   mul ten
   mov bl,[si]
   sub bl,30h
   add ax,bx
   inc si
   loop c1
 
   add ax,2
   mov n,ax
 
   mov dx,offset two             ;
   mov ah,9                      ;
   int 21h                       ;print first digit (= 2), followed by space
 
   cmp n,3                       ;if one digit was asked for, having
   je jmp_exit                   ;printed it, exit
 
   mov ax,1                      ;
   mov cx,n                      ;
   dec cx                        ;
   mov di,offset a               ;array a is at end of code
   repnz stosw                   ;fill array with 1's
 
   sub di,2
   mov cx,n                      ;will calculate n-3 digits
   sub cx,3                      ;
   std                           ;read array from right to left
 
m1:
   push cx
   mov cx,n
   mov i,cx
   dec cx
   mov si,di                     ;si==>last entry of array
m2:
   lodsw                         ;ax = a[i]
   mul ten                       ;ax = 10*a[i]
jc error_                        ;if overflow, exit with msg
   add ax,q                      ;ax = 10*a[i]+q
jc error_                        ;if overflow, exit with msg
   xor dx,dx
   div i
   mov q,ax                      ;q = (10*a[i]+q)/i
   mov [si+2],dx                 ;a[i] = (10*a[i]+q) mod i
   dec i
   loop m2
 
   mov dx,q                      ;last q computed = next digit of e
   add dl,30h
   mov ah,2                      ;------FORMATTED OUTPUT-----------;
   int 21h                       ;                                 ;
   inc col                       ;                                 ;
   dec space_ind                 ;                                 ;
                                 ;                                 ;
   cmp space_ind,0               ;                                 ;
   jne m3                        ;                                 ;
                                 ;                                 ;
   mov space_ind,5               ;print space                      ;
   mov dl,' '                    ;                                 ;
   mov ah,2                      ;                                 ;
   int 21h                       ;                                 ;
   inc col                       ;                                 ;
m3:                              ;                                 ;
   cmp col,62                    ;                                 ;
   jb m4                         ;                                 ;
                                                                   ;
   mov col,2                     ;                                 ;
   mov dx,offset crlf__          ;send carriage return, line feed, 2 spaces
   mov ah,9                      ;                                 ;
   int 21h                       ;                                 ;
 
m4:
   mov q,0
   pop cx
   loop m1
 
exit:
   cld
   mov ax,4c00h
   int 21h
 
error_:
   mov dx,offset err_msg
   mov ah,9
   int 21h
   jmp exit
 
buf       db     7,6 dup(?)
a         dw     6600 dup(?)
 
cseg   ends
end   begin

